// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Synapse.Models
{
    /// <summary> Compute type of the cluster which will execute data flow job. </summary>
    public readonly partial struct SynapseDataFlowComputeType : IEquatable<SynapseDataFlowComputeType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SynapseDataFlowComputeType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SynapseDataFlowComputeType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string GeneralValue = "General";
        private const string MemoryOptimizedValue = "MemoryOptimized";
        private const string ComputeOptimizedValue = "ComputeOptimized";

        /// <summary> General. </summary>
        public static SynapseDataFlowComputeType General { get; } = new SynapseDataFlowComputeType(GeneralValue);
        /// <summary> MemoryOptimized. </summary>
        public static SynapseDataFlowComputeType MemoryOptimized { get; } = new SynapseDataFlowComputeType(MemoryOptimizedValue);
        /// <summary> ComputeOptimized. </summary>
        public static SynapseDataFlowComputeType ComputeOptimized { get; } = new SynapseDataFlowComputeType(ComputeOptimizedValue);
        /// <summary> Determines if two <see cref="SynapseDataFlowComputeType"/> values are the same. </summary>
        public static bool operator ==(SynapseDataFlowComputeType left, SynapseDataFlowComputeType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SynapseDataFlowComputeType"/> values are not the same. </summary>
        public static bool operator !=(SynapseDataFlowComputeType left, SynapseDataFlowComputeType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SynapseDataFlowComputeType"/>. </summary>
        public static implicit operator SynapseDataFlowComputeType(string value) => new SynapseDataFlowComputeType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SynapseDataFlowComputeType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SynapseDataFlowComputeType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
