// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Synapse.Models
{
    /// <summary> The type of resource, Microsoft.Synapse/workspaces/kustoPools/databases/dataConnections. </summary>
    public readonly partial struct SynapseDataConnectionType : IEquatable<SynapseDataConnectionType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SynapseDataConnectionType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SynapseDataConnectionType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MicrosoftSynapseWorkspacesKustoPoolsDatabasesDataConnectionsValue = "Microsoft.Synapse/workspaces/kustoPools/databases/dataConnections";

        /// <summary> Microsoft.Synapse/workspaces/kustoPools/databases/dataConnections. </summary>
        public static SynapseDataConnectionType MicrosoftSynapseWorkspacesKustoPoolsDatabasesDataConnections { get; } = new SynapseDataConnectionType(MicrosoftSynapseWorkspacesKustoPoolsDatabasesDataConnectionsValue);
        /// <summary> Determines if two <see cref="SynapseDataConnectionType"/> values are the same. </summary>
        public static bool operator ==(SynapseDataConnectionType left, SynapseDataConnectionType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SynapseDataConnectionType"/> values are not the same. </summary>
        public static bool operator !=(SynapseDataConnectionType left, SynapseDataConnectionType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SynapseDataConnectionType"/>. </summary>
        public static implicit operator SynapseDataConnectionType(string value) => new SynapseDataConnectionType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SynapseDataConnectionType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SynapseDataConnectionType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
