// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Synapse.Models
{
    /// <summary> The SqlServerSecurityAlertPolicyName. </summary>
    public readonly partial struct SqlServerSecurityAlertPolicyName : IEquatable<SqlServerSecurityAlertPolicyName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SqlServerSecurityAlertPolicyName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SqlServerSecurityAlertPolicyName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DefaultValue = "Default";

        /// <summary> Default. </summary>
        public static SqlServerSecurityAlertPolicyName Default { get; } = new SqlServerSecurityAlertPolicyName(DefaultValue);
        /// <summary> Determines if two <see cref="SqlServerSecurityAlertPolicyName"/> values are the same. </summary>
        public static bool operator ==(SqlServerSecurityAlertPolicyName left, SqlServerSecurityAlertPolicyName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SqlServerSecurityAlertPolicyName"/> values are not the same. </summary>
        public static bool operator !=(SqlServerSecurityAlertPolicyName left, SqlServerSecurityAlertPolicyName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SqlServerSecurityAlertPolicyName"/>. </summary>
        public static implicit operator SqlServerSecurityAlertPolicyName(string value) => new SqlServerSecurityAlertPolicyName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SqlServerSecurityAlertPolicyName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SqlServerSecurityAlertPolicyName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
