// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Synapse.Models
{
    /// <summary> The SqlPoolConnectionPolicyName. </summary>
    public readonly partial struct SqlPoolConnectionPolicyName : IEquatable<SqlPoolConnectionPolicyName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SqlPoolConnectionPolicyName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SqlPoolConnectionPolicyName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DefaultValue = "default";

        /// <summary> default. </summary>
        public static SqlPoolConnectionPolicyName Default { get; } = new SqlPoolConnectionPolicyName(DefaultValue);
        /// <summary> Determines if two <see cref="SqlPoolConnectionPolicyName"/> values are the same. </summary>
        public static bool operator ==(SqlPoolConnectionPolicyName left, SqlPoolConnectionPolicyName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SqlPoolConnectionPolicyName"/> values are not the same. </summary>
        public static bool operator !=(SqlPoolConnectionPolicyName left, SqlPoolConnectionPolicyName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SqlPoolConnectionPolicyName"/>. </summary>
        public static implicit operator SqlPoolConnectionPolicyName(string value) => new SqlPoolConnectionPolicyName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SqlPoolConnectionPolicyName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SqlPoolConnectionPolicyName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
