// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Synapse.Models
{
    /// <summary> The column data type. </summary>
    public readonly partial struct SqlPoolColumnDataType : IEquatable<SqlPoolColumnDataType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SqlPoolColumnDataType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SqlPoolColumnDataType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ImageValue = "image";
        private const string TextValue = "text";
        private const string UniqueIdentifierValue = "uniqueidentifier";
        private const string DateValue = "date";
        private const string TimeValue = "time";
        private const string DateTime2Value = "datetime2";
        private const string DateTimeOffsetValue = "datetimeoffset";
        private const string TinyIntValue = "tinyint";
        private const string SmallIntValue = "smallint";
        private const string IntValue = "int";
        private const string SmallDateTimeValue = "smalldatetime";
        private const string RealValue = "real";
        private const string MoneyValue = "money";
        private const string DateTimeValue = "datetime";
        private const string FloatValue = "float";
        private const string SqlVariantValue = "sql_variant";
        private const string NtextValue = "ntext";
        private const string BitValue = "bit";
        private const string DecimalValue = "decimal";
        private const string NumericValue = "numeric";
        private const string SmallMoneyValue = "smallmoney";
        private const string BigIntValue = "bigint";
        private const string HierarchyidValue = "hierarchyid";
        private const string GeometryValue = "geometry";
        private const string GeographyValue = "geography";
        private const string VarbinaryValue = "varbinary";
        private const string VarcharValue = "varchar";
        private const string BinaryValue = "binary";
        private const string CharValue = "char";
        private const string TimestampValue = "timestamp";
        private const string NvarcharValue = "nvarchar";
        private const string NcharValue = "nchar";
        private const string XmlValue = "xml";
        private const string SysnameValue = "sysname";

        /// <summary> image. </summary>
        public static SqlPoolColumnDataType Image { get; } = new SqlPoolColumnDataType(ImageValue);
        /// <summary> text. </summary>
        public static SqlPoolColumnDataType Text { get; } = new SqlPoolColumnDataType(TextValue);
        /// <summary> uniqueidentifier. </summary>
        public static SqlPoolColumnDataType UniqueIdentifier { get; } = new SqlPoolColumnDataType(UniqueIdentifierValue);
        /// <summary> date. </summary>
        public static SqlPoolColumnDataType Date { get; } = new SqlPoolColumnDataType(DateValue);
        /// <summary> time. </summary>
        public static SqlPoolColumnDataType Time { get; } = new SqlPoolColumnDataType(TimeValue);
        /// <summary> datetime2. </summary>
        public static SqlPoolColumnDataType DateTime2 { get; } = new SqlPoolColumnDataType(DateTime2Value);
        /// <summary> datetimeoffset. </summary>
        public static SqlPoolColumnDataType DateTimeOffset { get; } = new SqlPoolColumnDataType(DateTimeOffsetValue);
        /// <summary> tinyint. </summary>
        public static SqlPoolColumnDataType TinyInt { get; } = new SqlPoolColumnDataType(TinyIntValue);
        /// <summary> smallint. </summary>
        public static SqlPoolColumnDataType SmallInt { get; } = new SqlPoolColumnDataType(SmallIntValue);
        /// <summary> int. </summary>
        public static SqlPoolColumnDataType Int { get; } = new SqlPoolColumnDataType(IntValue);
        /// <summary> smalldatetime. </summary>
        public static SqlPoolColumnDataType SmallDateTime { get; } = new SqlPoolColumnDataType(SmallDateTimeValue);
        /// <summary> real. </summary>
        public static SqlPoolColumnDataType Real { get; } = new SqlPoolColumnDataType(RealValue);
        /// <summary> money. </summary>
        public static SqlPoolColumnDataType Money { get; } = new SqlPoolColumnDataType(MoneyValue);
        /// <summary> datetime. </summary>
        public static SqlPoolColumnDataType DateTime { get; } = new SqlPoolColumnDataType(DateTimeValue);
        /// <summary> float. </summary>
        public static SqlPoolColumnDataType Float { get; } = new SqlPoolColumnDataType(FloatValue);
        /// <summary> sql_variant. </summary>
        public static SqlPoolColumnDataType SqlVariant { get; } = new SqlPoolColumnDataType(SqlVariantValue);
        /// <summary> ntext. </summary>
        public static SqlPoolColumnDataType Ntext { get; } = new SqlPoolColumnDataType(NtextValue);
        /// <summary> bit. </summary>
        public static SqlPoolColumnDataType Bit { get; } = new SqlPoolColumnDataType(BitValue);
        /// <summary> decimal. </summary>
        public static SqlPoolColumnDataType Decimal { get; } = new SqlPoolColumnDataType(DecimalValue);
        /// <summary> numeric. </summary>
        public static SqlPoolColumnDataType Numeric { get; } = new SqlPoolColumnDataType(NumericValue);
        /// <summary> smallmoney. </summary>
        public static SqlPoolColumnDataType SmallMoney { get; } = new SqlPoolColumnDataType(SmallMoneyValue);
        /// <summary> bigint. </summary>
        public static SqlPoolColumnDataType BigInt { get; } = new SqlPoolColumnDataType(BigIntValue);
        /// <summary> hierarchyid. </summary>
        public static SqlPoolColumnDataType Hierarchyid { get; } = new SqlPoolColumnDataType(HierarchyidValue);
        /// <summary> geometry. </summary>
        public static SqlPoolColumnDataType Geometry { get; } = new SqlPoolColumnDataType(GeometryValue);
        /// <summary> geography. </summary>
        public static SqlPoolColumnDataType Geography { get; } = new SqlPoolColumnDataType(GeographyValue);
        /// <summary> varbinary. </summary>
        public static SqlPoolColumnDataType Varbinary { get; } = new SqlPoolColumnDataType(VarbinaryValue);
        /// <summary> varchar. </summary>
        public static SqlPoolColumnDataType Varchar { get; } = new SqlPoolColumnDataType(VarcharValue);
        /// <summary> binary. </summary>
        public static SqlPoolColumnDataType Binary { get; } = new SqlPoolColumnDataType(BinaryValue);
        /// <summary> char. </summary>
        public static SqlPoolColumnDataType Char { get; } = new SqlPoolColumnDataType(CharValue);
        /// <summary> timestamp. </summary>
        public static SqlPoolColumnDataType Timestamp { get; } = new SqlPoolColumnDataType(TimestampValue);
        /// <summary> nvarchar. </summary>
        public static SqlPoolColumnDataType Nvarchar { get; } = new SqlPoolColumnDataType(NvarcharValue);
        /// <summary> nchar. </summary>
        public static SqlPoolColumnDataType Nchar { get; } = new SqlPoolColumnDataType(NcharValue);
        /// <summary> xml. </summary>
        public static SqlPoolColumnDataType Xml { get; } = new SqlPoolColumnDataType(XmlValue);
        /// <summary> sysname. </summary>
        public static SqlPoolColumnDataType Sysname { get; } = new SqlPoolColumnDataType(SysnameValue);
        /// <summary> Determines if two <see cref="SqlPoolColumnDataType"/> values are the same. </summary>
        public static bool operator ==(SqlPoolColumnDataType left, SqlPoolColumnDataType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SqlPoolColumnDataType"/> values are not the same. </summary>
        public static bool operator !=(SqlPoolColumnDataType left, SqlPoolColumnDataType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SqlPoolColumnDataType"/>. </summary>
        public static implicit operator SqlPoolColumnDataType(string value) => new SqlPoolColumnDataType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SqlPoolColumnDataType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SqlPoolColumnDataType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
