// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Synapse.Models
{
    /// <summary> The provisioned state of the resource. </summary>
    public readonly partial struct ResourceProvisioningState : IEquatable<ResourceProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ResourceProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ResourceProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string RunningValue = "Running";
        private const string CreatingValue = "Creating";
        private const string DeletingValue = "Deleting";
        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string MovingValue = "Moving";
        private const string CanceledValue = "Canceled";

        /// <summary> Running. </summary>
        public static ResourceProvisioningState Running { get; } = new ResourceProvisioningState(RunningValue);
        /// <summary> Creating. </summary>
        public static ResourceProvisioningState Creating { get; } = new ResourceProvisioningState(CreatingValue);
        /// <summary> Deleting. </summary>
        public static ResourceProvisioningState Deleting { get; } = new ResourceProvisioningState(DeletingValue);
        /// <summary> Succeeded. </summary>
        public static ResourceProvisioningState Succeeded { get; } = new ResourceProvisioningState(SucceededValue);
        /// <summary> Failed. </summary>
        public static ResourceProvisioningState Failed { get; } = new ResourceProvisioningState(FailedValue);
        /// <summary> Moving. </summary>
        public static ResourceProvisioningState Moving { get; } = new ResourceProvisioningState(MovingValue);
        /// <summary> Canceled. </summary>
        public static ResourceProvisioningState Canceled { get; } = new ResourceProvisioningState(CanceledValue);
        /// <summary> Determines if two <see cref="ResourceProvisioningState"/> values are the same. </summary>
        public static bool operator ==(ResourceProvisioningState left, ResourceProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ResourceProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(ResourceProvisioningState left, ResourceProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ResourceProvisioningState"/>. </summary>
        public static implicit operator ResourceProvisioningState(string value) => new ResourceProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ResourceProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ResourceProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
