// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Synapse.Models
{
    /// <summary> The type of resource, Microsoft.Synapse/workspaces/kustoPools. </summary>
    public readonly partial struct KustoPoolType : IEquatable<KustoPoolType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="KustoPoolType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public KustoPoolType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MicrosoftSynapseWorkspacesKustoPoolsValue = "Microsoft.Synapse/workspaces/kustoPools";

        /// <summary> Microsoft.Synapse/workspaces/kustoPools. </summary>
        public static KustoPoolType MicrosoftSynapseWorkspacesKustoPools { get; } = new KustoPoolType(MicrosoftSynapseWorkspacesKustoPoolsValue);
        /// <summary> Determines if two <see cref="KustoPoolType"/> values are the same. </summary>
        public static bool operator ==(KustoPoolType left, KustoPoolType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="KustoPoolType"/> values are not the same. </summary>
        public static bool operator !=(KustoPoolType left, KustoPoolType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="KustoPoolType"/>. </summary>
        public static implicit operator KustoPoolType(string value) => new KustoPoolType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is KustoPoolType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(KustoPoolType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
