// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Synapse.Models
{
    /// <summary> The state of the resource. </summary>
    public readonly partial struct KustoPoolState : IEquatable<KustoPoolState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="KustoPoolState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public KustoPoolState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CreatingValue = "Creating";
        private const string UnavailableValue = "Unavailable";
        private const string RunningValue = "Running";
        private const string DeletingValue = "Deleting";
        private const string DeletedValue = "Deleted";
        private const string StoppingValue = "Stopping";
        private const string StoppedValue = "Stopped";
        private const string StartingValue = "Starting";
        private const string UpdatingValue = "Updating";

        /// <summary> Creating. </summary>
        public static KustoPoolState Creating { get; } = new KustoPoolState(CreatingValue);
        /// <summary> Unavailable. </summary>
        public static KustoPoolState Unavailable { get; } = new KustoPoolState(UnavailableValue);
        /// <summary> Running. </summary>
        public static KustoPoolState Running { get; } = new KustoPoolState(RunningValue);
        /// <summary> Deleting. </summary>
        public static KustoPoolState Deleting { get; } = new KustoPoolState(DeletingValue);
        /// <summary> Deleted. </summary>
        public static KustoPoolState Deleted { get; } = new KustoPoolState(DeletedValue);
        /// <summary> Stopping. </summary>
        public static KustoPoolState Stopping { get; } = new KustoPoolState(StoppingValue);
        /// <summary> Stopped. </summary>
        public static KustoPoolState Stopped { get; } = new KustoPoolState(StoppedValue);
        /// <summary> Starting. </summary>
        public static KustoPoolState Starting { get; } = new KustoPoolState(StartingValue);
        /// <summary> Updating. </summary>
        public static KustoPoolState Updating { get; } = new KustoPoolState(UpdatingValue);
        /// <summary> Determines if two <see cref="KustoPoolState"/> values are the same. </summary>
        public static bool operator ==(KustoPoolState left, KustoPoolState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="KustoPoolState"/> values are not the same. </summary>
        public static bool operator !=(KustoPoolState left, KustoPoolState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="KustoPoolState"/>. </summary>
        public static implicit operator KustoPoolState(string value) => new KustoPoolState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is KustoPoolState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(KustoPoolState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
