// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Synapse.Models
{
    /// <summary> Message providing the reason why the given name is invalid. </summary>
    public readonly partial struct KustoPoolNameUnavailableReason : IEquatable<KustoPoolNameUnavailableReason>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="KustoPoolNameUnavailableReason"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public KustoPoolNameUnavailableReason(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InvalidValue = "Invalid";
        private const string AlreadyExistsValue = "AlreadyExists";

        /// <summary> Invalid. </summary>
        public static KustoPoolNameUnavailableReason Invalid { get; } = new KustoPoolNameUnavailableReason(InvalidValue);
        /// <summary> AlreadyExists. </summary>
        public static KustoPoolNameUnavailableReason AlreadyExists { get; } = new KustoPoolNameUnavailableReason(AlreadyExistsValue);
        /// <summary> Determines if two <see cref="KustoPoolNameUnavailableReason"/> values are the same. </summary>
        public static bool operator ==(KustoPoolNameUnavailableReason left, KustoPoolNameUnavailableReason right) => left.Equals(right);
        /// <summary> Determines if two <see cref="KustoPoolNameUnavailableReason"/> values are not the same. </summary>
        public static bool operator !=(KustoPoolNameUnavailableReason left, KustoPoolNameUnavailableReason right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="KustoPoolNameUnavailableReason"/>. </summary>
        public static implicit operator KustoPoolNameUnavailableReason(string value) => new KustoPoolNameUnavailableReason(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is KustoPoolNameUnavailableReason other && Equals(other);
        /// <inheritdoc />
        public bool Equals(KustoPoolNameUnavailableReason other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
