// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Synapse.Models
{
    internal static partial class KustoPoolDatabaseTypeExtensions
    {
        public static string ToSerialString(this KustoPoolDatabaseType value) => value switch
        {
            KustoPoolDatabaseType.MicrosoftSynapseWorkspacesKustoPoolsDatabases => "Microsoft.Synapse/workspaces/kustoPools/databases",
            KustoPoolDatabaseType.MicrosoftSynapseWorkspacesKustoPoolsAttachedDatabaseConfigurations => "Microsoft.Synapse/workspaces/kustoPools/attachedDatabaseConfigurations",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown KustoPoolDatabaseType value.")
        };

        public static KustoPoolDatabaseType ToKustoPoolDatabaseType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Microsoft.Synapse/workspaces/kustoPools/databases")) return KustoPoolDatabaseType.MicrosoftSynapseWorkspacesKustoPoolsDatabases;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Microsoft.Synapse/workspaces/kustoPools/attachedDatabaseConfigurations")) return KustoPoolDatabaseType.MicrosoftSynapseWorkspacesKustoPoolsAttachedDatabaseConfigurations;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown KustoPoolDatabaseType value.");
        }
    }
}
