// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Synapse.Models
{
    /// <summary> The compression type. </summary>
    public readonly partial struct KustoPoolCompressionType : IEquatable<KustoPoolCompressionType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="KustoPoolCompressionType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public KustoPoolCompressionType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string GZipValue = "GZip";

        /// <summary> None. </summary>
        public static KustoPoolCompressionType None { get; } = new KustoPoolCompressionType(NoneValue);
        /// <summary> GZip. </summary>
        public static KustoPoolCompressionType GZip { get; } = new KustoPoolCompressionType(GZipValue);
        /// <summary> Determines if two <see cref="KustoPoolCompressionType"/> values are the same. </summary>
        public static bool operator ==(KustoPoolCompressionType left, KustoPoolCompressionType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="KustoPoolCompressionType"/> values are not the same. </summary>
        public static bool operator !=(KustoPoolCompressionType left, KustoPoolCompressionType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="KustoPoolCompressionType"/>. </summary>
        public static implicit operator KustoPoolCompressionType(string value) => new KustoPoolCompressionType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is KustoPoolCompressionType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(KustoPoolCompressionType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
