// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Synapse.Models
{
    /// <summary> The kind of nodes that the Big Data pool provides. </summary>
    public readonly partial struct BigDataPoolNodeSizeFamily : IEquatable<BigDataPoolNodeSizeFamily>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BigDataPoolNodeSizeFamily"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BigDataPoolNodeSizeFamily(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string MemoryOptimizedValue = "MemoryOptimized";
        private const string HardwareAcceleratedFpgaValue = "HardwareAcceleratedFPGA";
        private const string HardwareAcceleratedGpuValue = "HardwareAcceleratedGPU";

        /// <summary> None. </summary>
        public static BigDataPoolNodeSizeFamily None { get; } = new BigDataPoolNodeSizeFamily(NoneValue);
        /// <summary> MemoryOptimized. </summary>
        public static BigDataPoolNodeSizeFamily MemoryOptimized { get; } = new BigDataPoolNodeSizeFamily(MemoryOptimizedValue);
        /// <summary> HardwareAcceleratedFPGA. </summary>
        public static BigDataPoolNodeSizeFamily HardwareAcceleratedFpga { get; } = new BigDataPoolNodeSizeFamily(HardwareAcceleratedFpgaValue);
        /// <summary> HardwareAcceleratedGPU. </summary>
        public static BigDataPoolNodeSizeFamily HardwareAcceleratedGpu { get; } = new BigDataPoolNodeSizeFamily(HardwareAcceleratedGpuValue);
        /// <summary> Determines if two <see cref="BigDataPoolNodeSizeFamily"/> values are the same. </summary>
        public static bool operator ==(BigDataPoolNodeSizeFamily left, BigDataPoolNodeSizeFamily right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BigDataPoolNodeSizeFamily"/> values are not the same. </summary>
        public static bool operator !=(BigDataPoolNodeSizeFamily left, BigDataPoolNodeSizeFamily right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BigDataPoolNodeSizeFamily"/>. </summary>
        public static implicit operator BigDataPoolNodeSizeFamily(string value) => new BigDataPoolNodeSizeFamily(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BigDataPoolNodeSizeFamily other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BigDataPoolNodeSizeFamily other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
