// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Synapse.Models
{
    /// <summary> Library/package information of a Big Data pool powered by Apache Spark. </summary>
    public partial class BigDataPoolLibraryInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BigDataPoolLibraryInfo"/>. </summary>
        public BigDataPoolLibraryInfo()
        {
        }

        /// <summary> Initializes a new instance of <see cref="BigDataPoolLibraryInfo"/>. </summary>
        /// <param name="name"> Name of the library. </param>
        /// <param name="path"> Storage blob path of library. </param>
        /// <param name="containerName"> Storage blob container name. </param>
        /// <param name="uploadedOn"> The last update time of the library. </param>
        /// <param name="libraryInfoType"> Type of the library. </param>
        /// <param name="provisioningStatus"> Provisioning status of the library/package. </param>
        /// <param name="creatorId"> Creator Id of the library/package. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BigDataPoolLibraryInfo(string name, string path, string containerName, DateTimeOffset? uploadedOn, string libraryInfoType, string provisioningStatus, string creatorId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            Path = path;
            ContainerName = containerName;
            UploadedOn = uploadedOn;
            LibraryInfoType = libraryInfoType;
            ProvisioningStatus = provisioningStatus;
            CreatorId = creatorId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Name of the library. </summary>
        public string Name { get; set; }
        /// <summary> Storage blob path of library. </summary>
        public string Path { get; set; }
        /// <summary> Storage blob container name. </summary>
        public string ContainerName { get; set; }
        /// <summary> The last update time of the library. </summary>
        public DateTimeOffset? UploadedOn { get; set; }
        /// <summary> Type of the library. </summary>
        public string LibraryInfoType { get; set; }
        /// <summary> Provisioning status of the library/package. </summary>
        public string ProvisioningStatus { get; }
        /// <summary> Creator Id of the library/package. </summary>
        public string CreatorId { get; }
    }
}
