// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Synapse.Models
{
    /// <summary> Auto-scaling properties of a Big Data pool powered by Apache Spark. </summary>
    public partial class BigDataPoolAutoScaleProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BigDataPoolAutoScaleProperties"/>. </summary>
        public BigDataPoolAutoScaleProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="BigDataPoolAutoScaleProperties"/>. </summary>
        /// <param name="minNodeCount"> The minimum number of nodes the Big Data pool can support. </param>
        /// <param name="isEnabled"> Whether automatic scaling is enabled for the Big Data pool. </param>
        /// <param name="maxNodeCount"> The maximum number of nodes the Big Data pool can support. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BigDataPoolAutoScaleProperties(int? minNodeCount, bool? isEnabled, int? maxNodeCount, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            MinNodeCount = minNodeCount;
            IsEnabled = isEnabled;
            MaxNodeCount = maxNodeCount;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The minimum number of nodes the Big Data pool can support. </summary>
        public int? MinNodeCount { get; set; }
        /// <summary> Whether automatic scaling is enabled for the Big Data pool. </summary>
        public bool? IsEnabled { get; set; }
        /// <summary> The maximum number of nodes the Big Data pool can support. </summary>
        public int? MaxNodeCount { get; set; }
    }
}
