// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Synapse.Models
{
    /// <summary> Auto-pausing properties of a Big Data pool powered by Apache Spark. </summary>
    public partial class BigDataPoolAutoPauseProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BigDataPoolAutoPauseProperties"/>. </summary>
        public BigDataPoolAutoPauseProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="BigDataPoolAutoPauseProperties"/>. </summary>
        /// <param name="delayInMinutes"> Number of minutes of idle time before the Big Data pool is automatically paused. </param>
        /// <param name="isEnabled"> Whether auto-pausing is enabled for the Big Data pool. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BigDataPoolAutoPauseProperties(int? delayInMinutes, bool? isEnabled, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DelayInMinutes = delayInMinutes;
            IsEnabled = isEnabled;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Number of minutes of idle time before the Big Data pool is automatically paused. </summary>
        public int? DelayInMinutes { get; set; }
        /// <summary> Whether auto-pausing is enabled for the Big Data pool. </summary>
        public bool? IsEnabled { get; set; }
    }
}
