// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Synapse.Models
{
    /// <summary> property configuration state. </summary>
    public readonly partial struct AadAuthenticationState : IEquatable<AadAuthenticationState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AadAuthenticationState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AadAuthenticationState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ConsistentValue = "Consistent";
        private const string InConsistentValue = "InConsistent";
        private const string UpdatingValue = "Updating";

        /// <summary> Consistent. </summary>
        public static AadAuthenticationState Consistent { get; } = new AadAuthenticationState(ConsistentValue);
        /// <summary> InConsistent. </summary>
        public static AadAuthenticationState InConsistent { get; } = new AadAuthenticationState(InConsistentValue);
        /// <summary> Updating. </summary>
        public static AadAuthenticationState Updating { get; } = new AadAuthenticationState(UpdatingValue);
        /// <summary> Determines if two <see cref="AadAuthenticationState"/> values are the same. </summary>
        public static bool operator ==(AadAuthenticationState left, AadAuthenticationState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AadAuthenticationState"/> values are not the same. </summary>
        public static bool operator !=(AadAuthenticationState left, AadAuthenticationState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AadAuthenticationState"/>. </summary>
        public static implicit operator AadAuthenticationState(string value) => new AadAuthenticationState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AadAuthenticationState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AadAuthenticationState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
