// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Synapse
{
    internal class SynapseWorkspaceSqlAdministratorResourceOperationSource : IOperationSource<SynapseWorkspaceSqlAdministratorResource>
    {
        private readonly ArmClient _client;

        internal SynapseWorkspaceSqlAdministratorResourceOperationSource(ArmClient client)
        {
            _client = client;
        }

        SynapseWorkspaceSqlAdministratorResource IOperationSource<SynapseWorkspaceSqlAdministratorResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = SynapseWorkspaceAadAdminInfoData.DeserializeSynapseWorkspaceAadAdminInfoData(document.RootElement);
            return new SynapseWorkspaceSqlAdministratorResource(_client, data);
        }

        async ValueTask<SynapseWorkspaceSqlAdministratorResource> IOperationSource<SynapseWorkspaceSqlAdministratorResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = SynapseWorkspaceAadAdminInfoData.DeserializeSynapseWorkspaceAadAdminInfoData(document.RootElement);
            return new SynapseWorkspaceSqlAdministratorResource(_client, data);
        }
    }
}
