// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Synapse
{
    internal class SynapseWorkspaceOperationSource : IOperationSource<SynapseWorkspaceResource>
    {
        private readonly ArmClient _client;

        internal SynapseWorkspaceOperationSource(ArmClient client)
        {
            _client = client;
        }

        SynapseWorkspaceResource IOperationSource<SynapseWorkspaceResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = SynapseWorkspaceData.DeserializeSynapseWorkspaceData(document.RootElement);
            return new SynapseWorkspaceResource(_client, data);
        }

        async ValueTask<SynapseWorkspaceResource> IOperationSource<SynapseWorkspaceResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = SynapseWorkspaceData.DeserializeSynapseWorkspaceData(document.RootElement);
            return new SynapseWorkspaceResource(_client, data);
        }
    }
}
