// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Synapse
{
    internal class SynapseWorkloadGroupOperationSource : IOperationSource<SynapseWorkloadGroupResource>
    {
        private readonly ArmClient _client;

        internal SynapseWorkloadGroupOperationSource(ArmClient client)
        {
            _client = client;
        }

        SynapseWorkloadGroupResource IOperationSource<SynapseWorkloadGroupResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = SynapseWorkloadGroupData.DeserializeSynapseWorkloadGroupData(document.RootElement);
            return new SynapseWorkloadGroupResource(_client, data);
        }

        async ValueTask<SynapseWorkloadGroupResource> IOperationSource<SynapseWorkloadGroupResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = SynapseWorkloadGroupData.DeserializeSynapseWorkloadGroupData(document.RootElement);
            return new SynapseWorkloadGroupResource(_client, data);
        }
    }
}
