// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Synapse
{
    internal class SynapseSqlPoolOperationSource : IOperationSource<SynapseSqlPoolResource>
    {
        private readonly ArmClient _client;

        internal SynapseSqlPoolOperationSource(ArmClient client)
        {
            _client = client;
        }

        SynapseSqlPoolResource IOperationSource<SynapseSqlPoolResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = SynapseSqlPoolData.DeserializeSynapseSqlPoolData(document.RootElement);
            return new SynapseSqlPoolResource(_client, data);
        }

        async ValueTask<SynapseSqlPoolResource> IOperationSource<SynapseSqlPoolResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = SynapseSqlPoolData.DeserializeSynapseSqlPoolData(document.RootElement);
            return new SynapseSqlPoolResource(_client, data);
        }
    }
}
