// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Synapse
{
    internal class SynapseServerBlobAuditingPolicyOperationSource : IOperationSource<SynapseServerBlobAuditingPolicyResource>
    {
        private readonly ArmClient _client;

        internal SynapseServerBlobAuditingPolicyOperationSource(ArmClient client)
        {
            _client = client;
        }

        SynapseServerBlobAuditingPolicyResource IOperationSource<SynapseServerBlobAuditingPolicyResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = SynapseServerBlobAuditingPolicyData.DeserializeSynapseServerBlobAuditingPolicyData(document.RootElement);
            return new SynapseServerBlobAuditingPolicyResource(_client, data);
        }

        async ValueTask<SynapseServerBlobAuditingPolicyResource> IOperationSource<SynapseServerBlobAuditingPolicyResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = SynapseServerBlobAuditingPolicyData.DeserializeSynapseServerBlobAuditingPolicyData(document.RootElement);
            return new SynapseServerBlobAuditingPolicyResource(_client, data);
        }
    }
}
