// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Synapse
{
    internal class SynapseKustoPoolOperationSource : IOperationSource<SynapseKustoPoolResource>
    {
        private readonly ArmClient _client;

        internal SynapseKustoPoolOperationSource(ArmClient client)
        {
            _client = client;
        }

        SynapseKustoPoolResource IOperationSource<SynapseKustoPoolResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = SynapseKustoPoolData.DeserializeSynapseKustoPoolData(document.RootElement);
            return new SynapseKustoPoolResource(_client, data);
        }

        async ValueTask<SynapseKustoPoolResource> IOperationSource<SynapseKustoPoolResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = SynapseKustoPoolData.DeserializeSynapseKustoPoolData(document.RootElement);
            return new SynapseKustoPoolResource(_client, data);
        }
    }
}
