// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.ResourceManager.Synapse.Models;

namespace Azure.ResourceManager.Synapse
{
    internal class SynapseIntegrationRuntimeStatusResultOperationSource : IOperationSource<SynapseIntegrationRuntimeStatusResult>
    {
        SynapseIntegrationRuntimeStatusResult IOperationSource<SynapseIntegrationRuntimeStatusResult>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            return SynapseIntegrationRuntimeStatusResult.DeserializeSynapseIntegrationRuntimeStatusResult(document.RootElement);
        }

        async ValueTask<SynapseIntegrationRuntimeStatusResult> IOperationSource<SynapseIntegrationRuntimeStatusResult>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            return SynapseIntegrationRuntimeStatusResult.DeserializeSynapseIntegrationRuntimeStatusResult(document.RootElement);
        }
    }
}
