// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Synapse
{
    internal class SynapseIntegrationRuntimeOperationSource : IOperationSource<SynapseIntegrationRuntimeResource>
    {
        private readonly ArmClient _client;

        internal SynapseIntegrationRuntimeOperationSource(ArmClient client)
        {
            _client = client;
        }

        SynapseIntegrationRuntimeResource IOperationSource<SynapseIntegrationRuntimeResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = SynapseIntegrationRuntimeData.DeserializeSynapseIntegrationRuntimeData(document.RootElement);
            return new SynapseIntegrationRuntimeResource(_client, data);
        }

        async ValueTask<SynapseIntegrationRuntimeResource> IOperationSource<SynapseIntegrationRuntimeResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = SynapseIntegrationRuntimeData.DeserializeSynapseIntegrationRuntimeData(document.RootElement);
            return new SynapseIntegrationRuntimeResource(_client, data);
        }
    }
}
