// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Synapse
{
    internal class SynapseIPFirewallRuleInfoOperationSource : IOperationSource<SynapseIPFirewallRuleInfoResource>
    {
        private readonly ArmClient _client;

        internal SynapseIPFirewallRuleInfoOperationSource(ArmClient client)
        {
            _client = client;
        }

        SynapseIPFirewallRuleInfoResource IOperationSource<SynapseIPFirewallRuleInfoResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = SynapseIPFirewallRuleInfoData.DeserializeSynapseIPFirewallRuleInfoData(document.RootElement);
            return new SynapseIPFirewallRuleInfoResource(_client, data);
        }

        async ValueTask<SynapseIPFirewallRuleInfoResource> IOperationSource<SynapseIPFirewallRuleInfoResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = SynapseIPFirewallRuleInfoData.DeserializeSynapseIPFirewallRuleInfoData(document.RootElement);
            return new SynapseIPFirewallRuleInfoResource(_client, data);
        }
    }
}
