// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Synapse
{
    internal class SynapseExtendedServerBlobAuditingPolicyOperationSource : IOperationSource<SynapseExtendedServerBlobAuditingPolicyResource>
    {
        private readonly ArmClient _client;

        internal SynapseExtendedServerBlobAuditingPolicyOperationSource(ArmClient client)
        {
            _client = client;
        }

        SynapseExtendedServerBlobAuditingPolicyResource IOperationSource<SynapseExtendedServerBlobAuditingPolicyResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = SynapseExtendedServerBlobAuditingPolicyData.DeserializeSynapseExtendedServerBlobAuditingPolicyData(document.RootElement);
            return new SynapseExtendedServerBlobAuditingPolicyResource(_client, data);
        }

        async ValueTask<SynapseExtendedServerBlobAuditingPolicyResource> IOperationSource<SynapseExtendedServerBlobAuditingPolicyResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = SynapseExtendedServerBlobAuditingPolicyData.DeserializeSynapseExtendedServerBlobAuditingPolicyData(document.RootElement);
            return new SynapseExtendedServerBlobAuditingPolicyResource(_client, data);
        }
    }
}
