// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Synapse
{
    internal class SynapseEncryptionProtectorOperationSource : IOperationSource<SynapseEncryptionProtectorResource>
    {
        private readonly ArmClient _client;

        internal SynapseEncryptionProtectorOperationSource(ArmClient client)
        {
            _client = client;
        }

        SynapseEncryptionProtectorResource IOperationSource<SynapseEncryptionProtectorResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = SynapseEncryptionProtectorData.DeserializeSynapseEncryptionProtectorData(document.RootElement);
            return new SynapseEncryptionProtectorResource(_client, data);
        }

        async ValueTask<SynapseEncryptionProtectorResource> IOperationSource<SynapseEncryptionProtectorResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = SynapseEncryptionProtectorData.DeserializeSynapseEncryptionProtectorData(document.RootElement);
            return new SynapseEncryptionProtectorResource(_client, data);
        }
    }
}
