// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Synapse
{
    internal class SynapseDedicatedSqlMinimalTlsSettingOperationSource : IOperationSource<SynapseDedicatedSqlMinimalTlsSettingResource>
    {
        private readonly ArmClient _client;

        internal SynapseDedicatedSqlMinimalTlsSettingOperationSource(ArmClient client)
        {
            _client = client;
        }

        SynapseDedicatedSqlMinimalTlsSettingResource IOperationSource<SynapseDedicatedSqlMinimalTlsSettingResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = SynapseDedicatedSqlMinimalTlsSettingData.DeserializeSynapseDedicatedSqlMinimalTlsSettingData(document.RootElement);
            return new SynapseDedicatedSqlMinimalTlsSettingResource(_client, data);
        }

        async ValueTask<SynapseDedicatedSqlMinimalTlsSettingResource> IOperationSource<SynapseDedicatedSqlMinimalTlsSettingResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = SynapseDedicatedSqlMinimalTlsSettingData.DeserializeSynapseDedicatedSqlMinimalTlsSettingData(document.RootElement);
            return new SynapseDedicatedSqlMinimalTlsSettingResource(_client, data);
        }
    }
}
