// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Synapse
{
    internal class SynapseDatabasePrincipalAssignmentOperationSource : IOperationSource<SynapseDatabasePrincipalAssignmentResource>
    {
        private readonly ArmClient _client;

        internal SynapseDatabasePrincipalAssignmentOperationSource(ArmClient client)
        {
            _client = client;
        }

        SynapseDatabasePrincipalAssignmentResource IOperationSource<SynapseDatabasePrincipalAssignmentResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = SynapseDatabasePrincipalAssignmentData.DeserializeSynapseDatabasePrincipalAssignmentData(document.RootElement);
            return new SynapseDatabasePrincipalAssignmentResource(_client, data);
        }

        async ValueTask<SynapseDatabasePrincipalAssignmentResource> IOperationSource<SynapseDatabasePrincipalAssignmentResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = SynapseDatabasePrincipalAssignmentData.DeserializeSynapseDatabasePrincipalAssignmentData(document.RootElement);
            return new SynapseDatabasePrincipalAssignmentResource(_client, data);
        }
    }
}
