// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Synapse
{
    internal class SynapseDatabaseOperationSource : IOperationSource<SynapseDatabaseResource>
    {
        private readonly ArmClient _client;

        internal SynapseDatabaseOperationSource(ArmClient client)
        {
            _client = client;
        }

        SynapseDatabaseResource IOperationSource<SynapseDatabaseResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = SynapseDatabaseData.DeserializeSynapseDatabaseData(document.RootElement);
            return new SynapseDatabaseResource(_client, data);
        }

        async ValueTask<SynapseDatabaseResource> IOperationSource<SynapseDatabaseResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = SynapseDatabaseData.DeserializeSynapseDatabaseData(document.RootElement);
            return new SynapseDatabaseResource(_client, data);
        }
    }
}
