// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Synapse
{
    internal class SynapseDataConnectionOperationSource : IOperationSource<SynapseDataConnectionResource>
    {
        private readonly ArmClient _client;

        internal SynapseDataConnectionOperationSource(ArmClient client)
        {
            _client = client;
        }

        SynapseDataConnectionResource IOperationSource<SynapseDataConnectionResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = SynapseDataConnectionData.DeserializeSynapseDataConnectionData(document.RootElement);
            return new SynapseDataConnectionResource(_client, data);
        }

        async ValueTask<SynapseDataConnectionResource> IOperationSource<SynapseDataConnectionResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = SynapseDataConnectionData.DeserializeSynapseDataConnectionData(document.RootElement);
            return new SynapseDataConnectionResource(_client, data);
        }
    }
}
