// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Synapse.Models;

namespace Azure.ResourceManager.Synapse.Mocking
{
    /// <summary> A class to add extension methods to SubscriptionResource. </summary>
    public partial class MockableSynapseSubscriptionResource : ArmResource
    {
        private ClientDiagnostics _synapsePrivateLinkHubPrivateLinkHubsClientDiagnostics;
        private PrivateLinkHubsRestOperations _synapsePrivateLinkHubPrivateLinkHubsRestClient;
        private ClientDiagnostics _synapseWorkspaceWorkspacesClientDiagnostics;
        private WorkspacesRestOperations _synapseWorkspaceWorkspacesRestClient;
        private ClientDiagnostics _synapseKustoPoolKustoPoolsClientDiagnostics;
        private KustoPoolsRestOperations _synapseKustoPoolKustoPoolsRestClient;

        /// <summary> Initializes a new instance of the <see cref="MockableSynapseSubscriptionResource"/> class for mocking. </summary>
        protected MockableSynapseSubscriptionResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableSynapseSubscriptionResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableSynapseSubscriptionResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        private ClientDiagnostics SynapsePrivateLinkHubPrivateLinkHubsClientDiagnostics => _synapsePrivateLinkHubPrivateLinkHubsClientDiagnostics ??= new ClientDiagnostics("Azure.ResourceManager.Synapse", SynapsePrivateLinkHubResource.ResourceType.Namespace, Diagnostics);
        private PrivateLinkHubsRestOperations SynapsePrivateLinkHubPrivateLinkHubsRestClient => _synapsePrivateLinkHubPrivateLinkHubsRestClient ??= new PrivateLinkHubsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, GetApiVersionOrNull(SynapsePrivateLinkHubResource.ResourceType));
        private ClientDiagnostics SynapseWorkspaceWorkspacesClientDiagnostics => _synapseWorkspaceWorkspacesClientDiagnostics ??= new ClientDiagnostics("Azure.ResourceManager.Synapse", SynapseWorkspaceResource.ResourceType.Namespace, Diagnostics);
        private WorkspacesRestOperations SynapseWorkspaceWorkspacesRestClient => _synapseWorkspaceWorkspacesRestClient ??= new WorkspacesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, GetApiVersionOrNull(SynapseWorkspaceResource.ResourceType));
        private ClientDiagnostics SynapseKustoPoolKustoPoolsClientDiagnostics => _synapseKustoPoolKustoPoolsClientDiagnostics ??= new ClientDiagnostics("Azure.ResourceManager.Synapse", SynapseKustoPoolResource.ResourceType.Namespace, Diagnostics);
        private KustoPoolsRestOperations SynapseKustoPoolKustoPoolsRestClient => _synapseKustoPoolKustoPoolsRestClient ??= new KustoPoolsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, GetApiVersionOrNull(SynapseKustoPoolResource.ResourceType));

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Returns a list of privateLinkHubs in a subscription
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Synapse/privateLinkHubs</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>PrivateLinkHubs_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapsePrivateLinkHubResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="SynapsePrivateLinkHubResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<SynapsePrivateLinkHubResource> GetSynapsePrivateLinkHubsAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => SynapsePrivateLinkHubPrivateLinkHubsRestClient.CreateListRequest(Id.SubscriptionId);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => SynapsePrivateLinkHubPrivateLinkHubsRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new SynapsePrivateLinkHubResource(Client, SynapsePrivateLinkHubData.DeserializeSynapsePrivateLinkHubData(e)), SynapsePrivateLinkHubPrivateLinkHubsClientDiagnostics, Pipeline, "MockableSynapseSubscriptionResource.GetSynapsePrivateLinkHubs", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Returns a list of privateLinkHubs in a subscription
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Synapse/privateLinkHubs</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>PrivateLinkHubs_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapsePrivateLinkHubResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="SynapsePrivateLinkHubResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<SynapsePrivateLinkHubResource> GetSynapsePrivateLinkHubs(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => SynapsePrivateLinkHubPrivateLinkHubsRestClient.CreateListRequest(Id.SubscriptionId);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => SynapsePrivateLinkHubPrivateLinkHubsRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new SynapsePrivateLinkHubResource(Client, SynapsePrivateLinkHubData.DeserializeSynapsePrivateLinkHubData(e)), SynapsePrivateLinkHubPrivateLinkHubsClientDiagnostics, Pipeline, "MockableSynapseSubscriptionResource.GetSynapsePrivateLinkHubs", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Returns a list of workspaces in a subscription
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Synapse/workspaces</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Workspaces_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseWorkspaceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="SynapseWorkspaceResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<SynapseWorkspaceResource> GetSynapseWorkspacesAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => SynapseWorkspaceWorkspacesRestClient.CreateListRequest(Id.SubscriptionId);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => SynapseWorkspaceWorkspacesRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new SynapseWorkspaceResource(Client, SynapseWorkspaceData.DeserializeSynapseWorkspaceData(e)), SynapseWorkspaceWorkspacesClientDiagnostics, Pipeline, "MockableSynapseSubscriptionResource.GetSynapseWorkspaces", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Returns a list of workspaces in a subscription
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Synapse/workspaces</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Workspaces_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseWorkspaceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="SynapseWorkspaceResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<SynapseWorkspaceResource> GetSynapseWorkspaces(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => SynapseWorkspaceWorkspacesRestClient.CreateListRequest(Id.SubscriptionId);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => SynapseWorkspaceWorkspacesRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new SynapseWorkspaceResource(Client, SynapseWorkspaceData.DeserializeSynapseWorkspaceData(e)), SynapseWorkspaceWorkspacesClientDiagnostics, Pipeline, "MockableSynapseSubscriptionResource.GetSynapseWorkspaces", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists eligible SKUs for Kusto Pool resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Synapse/skus</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>KustoPools_ListSkus</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseKustoPoolResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="KustoPoolSkuDescription"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<KustoPoolSkuDescription> GetSkusKustoPoolsAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => SynapseKustoPoolKustoPoolsRestClient.CreateListSkusRequest(Id.SubscriptionId);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, null, e => KustoPoolSkuDescription.DeserializeKustoPoolSkuDescription(e), SynapseKustoPoolKustoPoolsClientDiagnostics, Pipeline, "MockableSynapseSubscriptionResource.GetSkusKustoPools", "value", null, cancellationToken);
        }

        /// <summary>
        /// Lists eligible SKUs for Kusto Pool resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Synapse/skus</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>KustoPools_ListSkus</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseKustoPoolResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="KustoPoolSkuDescription"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<KustoPoolSkuDescription> GetSkusKustoPools(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => SynapseKustoPoolKustoPoolsRestClient.CreateListSkusRequest(Id.SubscriptionId);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, null, e => KustoPoolSkuDescription.DeserializeKustoPoolSkuDescription(e), SynapseKustoPoolKustoPoolsClientDiagnostics, Pipeline, "MockableSynapseSubscriptionResource.GetSkusKustoPools", "value", null, cancellationToken);
        }

        /// <summary>
        /// Checks that the kusto pool name is valid and is not already in use.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Synapse/locations/{location}/kustoPoolCheckNameAvailability</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>KustoPools_CheckNameAvailability</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseKustoPoolResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="location"> The name of Azure region. </param>
        /// <param name="content"> The name of the cluster. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        public virtual async Task<Response<KustoPoolNameAvailabilityResult>> CheckKustoPoolNameAvailabilityAsync(AzureLocation location, KustoPoolNameAvailabilityContent content, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = SynapseKustoPoolKustoPoolsClientDiagnostics.CreateScope("MockableSynapseSubscriptionResource.CheckKustoPoolNameAvailability");
            scope.Start();
            try
            {
                var response = await SynapseKustoPoolKustoPoolsRestClient.CheckNameAvailabilityAsync(Id.SubscriptionId, location, content, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks that the kusto pool name is valid and is not already in use.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Synapse/locations/{location}/kustoPoolCheckNameAvailability</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>KustoPools_CheckNameAvailability</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseKustoPoolResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="location"> The name of Azure region. </param>
        /// <param name="content"> The name of the cluster. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        public virtual Response<KustoPoolNameAvailabilityResult> CheckKustoPoolNameAvailability(AzureLocation location, KustoPoolNameAvailabilityContent content, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = SynapseKustoPoolKustoPoolsClientDiagnostics.CreateScope("MockableSynapseSubscriptionResource.CheckKustoPoolNameAvailability");
            scope.Start();
            try
            {
                var response = SynapseKustoPoolKustoPoolsRestClient.CheckNameAvailability(Id.SubscriptionId, location, content, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
