// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.Synapse.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableSynapseArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableSynapseArmClient"/> class for mocking. </summary>
        protected MockableSynapseArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableSynapseArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableSynapseArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableSynapseArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing a <see cref="SynapseAadOnlyAuthenticationResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SynapseAadOnlyAuthenticationResource.CreateResourceIdentifier" /> to create a <see cref="SynapseAadOnlyAuthenticationResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SynapseAadOnlyAuthenticationResource"/> object. </returns>
        public virtual SynapseAadOnlyAuthenticationResource GetSynapseAadOnlyAuthenticationResource(ResourceIdentifier id)
        {
            SynapseAadOnlyAuthenticationResource.ValidateResourceId(id);
            return new SynapseAadOnlyAuthenticationResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SynapseIPFirewallRuleInfoResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SynapseIPFirewallRuleInfoResource.CreateResourceIdentifier" /> to create a <see cref="SynapseIPFirewallRuleInfoResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SynapseIPFirewallRuleInfoResource"/> object. </returns>
        public virtual SynapseIPFirewallRuleInfoResource GetSynapseIPFirewallRuleInfoResource(ResourceIdentifier id)
        {
            SynapseIPFirewallRuleInfoResource.ValidateResourceId(id);
            return new SynapseIPFirewallRuleInfoResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SynapseKeyResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SynapseKeyResource.CreateResourceIdentifier" /> to create a <see cref="SynapseKeyResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SynapseKeyResource"/> object. </returns>
        public virtual SynapseKeyResource GetSynapseKeyResource(ResourceIdentifier id)
        {
            SynapseKeyResource.ValidateResourceId(id);
            return new SynapseKeyResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SynapsePrivateEndpointConnectionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SynapsePrivateEndpointConnectionResource.CreateResourceIdentifier" /> to create a <see cref="SynapsePrivateEndpointConnectionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SynapsePrivateEndpointConnectionResource"/> object. </returns>
        public virtual SynapsePrivateEndpointConnectionResource GetSynapsePrivateEndpointConnectionResource(ResourceIdentifier id)
        {
            SynapsePrivateEndpointConnectionResource.ValidateResourceId(id);
            return new SynapsePrivateEndpointConnectionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SynapseWorkspacePrivateLinkResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SynapseWorkspacePrivateLinkResource.CreateResourceIdentifier" /> to create a <see cref="SynapseWorkspacePrivateLinkResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SynapseWorkspacePrivateLinkResource"/> object. </returns>
        public virtual SynapseWorkspacePrivateLinkResource GetSynapseWorkspacePrivateLinkResource(ResourceIdentifier id)
        {
            SynapseWorkspacePrivateLinkResource.ValidateResourceId(id);
            return new SynapseWorkspacePrivateLinkResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SynapsePrivateLinkResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SynapsePrivateLinkResource.CreateResourceIdentifier" /> to create a <see cref="SynapsePrivateLinkResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SynapsePrivateLinkResource"/> object. </returns>
        public virtual SynapsePrivateLinkResource GetSynapsePrivateLinkResource(ResourceIdentifier id)
        {
            SynapsePrivateLinkResource.ValidateResourceId(id);
            return new SynapsePrivateLinkResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SynapsePrivateLinkHubResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SynapsePrivateLinkHubResource.CreateResourceIdentifier" /> to create a <see cref="SynapsePrivateLinkHubResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SynapsePrivateLinkHubResource"/> object. </returns>
        public virtual SynapsePrivateLinkHubResource GetSynapsePrivateLinkHubResource(ResourceIdentifier id)
        {
            SynapsePrivateLinkHubResource.ValidateResourceId(id);
            return new SynapsePrivateLinkHubResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SynapsePrivateEndpointConnectionForPrivateLinkHubResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SynapsePrivateEndpointConnectionForPrivateLinkHubResource.CreateResourceIdentifier" /> to create a <see cref="SynapsePrivateEndpointConnectionForPrivateLinkHubResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SynapsePrivateEndpointConnectionForPrivateLinkHubResource"/> object. </returns>
        public virtual SynapsePrivateEndpointConnectionForPrivateLinkHubResource GetSynapsePrivateEndpointConnectionForPrivateLinkHubResource(ResourceIdentifier id)
        {
            SynapsePrivateEndpointConnectionForPrivateLinkHubResource.ValidateResourceId(id);
            return new SynapsePrivateEndpointConnectionForPrivateLinkHubResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SynapseSqlPoolResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SynapseSqlPoolResource.CreateResourceIdentifier" /> to create a <see cref="SynapseSqlPoolResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SynapseSqlPoolResource"/> object. </returns>
        public virtual SynapseSqlPoolResource GetSynapseSqlPoolResource(ResourceIdentifier id)
        {
            SynapseSqlPoolResource.ValidateResourceId(id);
            return new SynapseSqlPoolResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SynapseMetadataSyncConfigurationResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SynapseMetadataSyncConfigurationResource.CreateResourceIdentifier" /> to create a <see cref="SynapseMetadataSyncConfigurationResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SynapseMetadataSyncConfigurationResource"/> object. </returns>
        public virtual SynapseMetadataSyncConfigurationResource GetSynapseMetadataSyncConfigurationResource(ResourceIdentifier id)
        {
            SynapseMetadataSyncConfigurationResource.ValidateResourceId(id);
            return new SynapseMetadataSyncConfigurationResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SynapseGeoBackupPolicyResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SynapseGeoBackupPolicyResource.CreateResourceIdentifier" /> to create a <see cref="SynapseGeoBackupPolicyResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SynapseGeoBackupPolicyResource"/> object. </returns>
        public virtual SynapseGeoBackupPolicyResource GetSynapseGeoBackupPolicyResource(ResourceIdentifier id)
        {
            SynapseGeoBackupPolicyResource.ValidateResourceId(id);
            return new SynapseGeoBackupPolicyResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SynapseDataWarehouseUserActivityResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SynapseDataWarehouseUserActivityResource.CreateResourceIdentifier" /> to create a <see cref="SynapseDataWarehouseUserActivityResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SynapseDataWarehouseUserActivityResource"/> object. </returns>
        public virtual SynapseDataWarehouseUserActivityResource GetSynapseDataWarehouseUserActivityResource(ResourceIdentifier id)
        {
            SynapseDataWarehouseUserActivityResource.ValidateResourceId(id);
            return new SynapseDataWarehouseUserActivityResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SynapseRestorePointResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SynapseRestorePointResource.CreateResourceIdentifier" /> to create a <see cref="SynapseRestorePointResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SynapseRestorePointResource"/> object. </returns>
        public virtual SynapseRestorePointResource GetSynapseRestorePointResource(ResourceIdentifier id)
        {
            SynapseRestorePointResource.ValidateResourceId(id);
            return new SynapseRestorePointResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SynapseReplicationLinkResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SynapseReplicationLinkResource.CreateResourceIdentifier" /> to create a <see cref="SynapseReplicationLinkResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SynapseReplicationLinkResource"/> object. </returns>
        public virtual SynapseReplicationLinkResource GetSynapseReplicationLinkResource(ResourceIdentifier id)
        {
            SynapseReplicationLinkResource.ValidateResourceId(id);
            return new SynapseReplicationLinkResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SynapseMaintenanceWindowResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SynapseMaintenanceWindowResource.CreateResourceIdentifier" /> to create a <see cref="SynapseMaintenanceWindowResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SynapseMaintenanceWindowResource"/> object. </returns>
        public virtual SynapseMaintenanceWindowResource GetSynapseMaintenanceWindowResource(ResourceIdentifier id)
        {
            SynapseMaintenanceWindowResource.ValidateResourceId(id);
            return new SynapseMaintenanceWindowResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SynapseMaintenanceWindowOptionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SynapseMaintenanceWindowOptionResource.CreateResourceIdentifier" /> to create a <see cref="SynapseMaintenanceWindowOptionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SynapseMaintenanceWindowOptionResource"/> object. </returns>
        public virtual SynapseMaintenanceWindowOptionResource GetSynapseMaintenanceWindowOptionResource(ResourceIdentifier id)
        {
            SynapseMaintenanceWindowOptionResource.ValidateResourceId(id);
            return new SynapseMaintenanceWindowOptionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SynapseTransparentDataEncryptionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SynapseTransparentDataEncryptionResource.CreateResourceIdentifier" /> to create a <see cref="SynapseTransparentDataEncryptionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SynapseTransparentDataEncryptionResource"/> object. </returns>
        public virtual SynapseTransparentDataEncryptionResource GetSynapseTransparentDataEncryptionResource(ResourceIdentifier id)
        {
            SynapseTransparentDataEncryptionResource.ValidateResourceId(id);
            return new SynapseTransparentDataEncryptionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SynapseSqlPoolBlobAuditingPolicyResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SynapseSqlPoolBlobAuditingPolicyResource.CreateResourceIdentifier" /> to create a <see cref="SynapseSqlPoolBlobAuditingPolicyResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SynapseSqlPoolBlobAuditingPolicyResource"/> object. </returns>
        public virtual SynapseSqlPoolBlobAuditingPolicyResource GetSynapseSqlPoolBlobAuditingPolicyResource(ResourceIdentifier id)
        {
            SynapseSqlPoolBlobAuditingPolicyResource.ValidateResourceId(id);
            return new SynapseSqlPoolBlobAuditingPolicyResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SynapseSensitivityLabelResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SynapseSensitivityLabelResource.CreateResourceIdentifier" /> to create a <see cref="SynapseSensitivityLabelResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SynapseSensitivityLabelResource"/> object. </returns>
        public virtual SynapseSensitivityLabelResource GetSynapseSensitivityLabelResource(ResourceIdentifier id)
        {
            SynapseSensitivityLabelResource.ValidateResourceId(id);
            return new SynapseSensitivityLabelResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SynapseSqlPoolSchemaResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SynapseSqlPoolSchemaResource.CreateResourceIdentifier" /> to create a <see cref="SynapseSqlPoolSchemaResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SynapseSqlPoolSchemaResource"/> object. </returns>
        public virtual SynapseSqlPoolSchemaResource GetSynapseSqlPoolSchemaResource(ResourceIdentifier id)
        {
            SynapseSqlPoolSchemaResource.ValidateResourceId(id);
            return new SynapseSqlPoolSchemaResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SynapseSqlPoolTableResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SynapseSqlPoolTableResource.CreateResourceIdentifier" /> to create a <see cref="SynapseSqlPoolTableResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SynapseSqlPoolTableResource"/> object. </returns>
        public virtual SynapseSqlPoolTableResource GetSynapseSqlPoolTableResource(ResourceIdentifier id)
        {
            SynapseSqlPoolTableResource.ValidateResourceId(id);
            return new SynapseSqlPoolTableResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SynapseSqlPoolConnectionPolicyResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SynapseSqlPoolConnectionPolicyResource.CreateResourceIdentifier" /> to create a <see cref="SynapseSqlPoolConnectionPolicyResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SynapseSqlPoolConnectionPolicyResource"/> object. </returns>
        public virtual SynapseSqlPoolConnectionPolicyResource GetSynapseSqlPoolConnectionPolicyResource(ResourceIdentifier id)
        {
            SynapseSqlPoolConnectionPolicyResource.ValidateResourceId(id);
            return new SynapseSqlPoolConnectionPolicyResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SynapseSqlPoolVulnerabilityAssessmentResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SynapseSqlPoolVulnerabilityAssessmentResource.CreateResourceIdentifier" /> to create a <see cref="SynapseSqlPoolVulnerabilityAssessmentResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SynapseSqlPoolVulnerabilityAssessmentResource"/> object. </returns>
        public virtual SynapseSqlPoolVulnerabilityAssessmentResource GetSynapseSqlPoolVulnerabilityAssessmentResource(ResourceIdentifier id)
        {
            SynapseSqlPoolVulnerabilityAssessmentResource.ValidateResourceId(id);
            return new SynapseSqlPoolVulnerabilityAssessmentResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SynapseVulnerabilityAssessmentScanRecordResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SynapseVulnerabilityAssessmentScanRecordResource.CreateResourceIdentifier" /> to create a <see cref="SynapseVulnerabilityAssessmentScanRecordResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SynapseVulnerabilityAssessmentScanRecordResource"/> object. </returns>
        public virtual SynapseVulnerabilityAssessmentScanRecordResource GetSynapseVulnerabilityAssessmentScanRecordResource(ResourceIdentifier id)
        {
            SynapseVulnerabilityAssessmentScanRecordResource.ValidateResourceId(id);
            return new SynapseVulnerabilityAssessmentScanRecordResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SynapseSqlPoolSecurityAlertPolicyResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SynapseSqlPoolSecurityAlertPolicyResource.CreateResourceIdentifier" /> to create a <see cref="SynapseSqlPoolSecurityAlertPolicyResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SynapseSqlPoolSecurityAlertPolicyResource"/> object. </returns>
        public virtual SynapseSqlPoolSecurityAlertPolicyResource GetSynapseSqlPoolSecurityAlertPolicyResource(ResourceIdentifier id)
        {
            SynapseSqlPoolSecurityAlertPolicyResource.ValidateResourceId(id);
            return new SynapseSqlPoolSecurityAlertPolicyResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource.CreateResourceIdentifier" /> to create a <see cref="SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource"/> object. </returns>
        public virtual SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource GetSynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource(ResourceIdentifier id)
        {
            SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource.ValidateResourceId(id);
            return new SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SynapseExtendedSqlPoolBlobAuditingPolicyResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SynapseExtendedSqlPoolBlobAuditingPolicyResource.CreateResourceIdentifier" /> to create a <see cref="SynapseExtendedSqlPoolBlobAuditingPolicyResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SynapseExtendedSqlPoolBlobAuditingPolicyResource"/> object. </returns>
        public virtual SynapseExtendedSqlPoolBlobAuditingPolicyResource GetSynapseExtendedSqlPoolBlobAuditingPolicyResource(ResourceIdentifier id)
        {
            SynapseExtendedSqlPoolBlobAuditingPolicyResource.ValidateResourceId(id);
            return new SynapseExtendedSqlPoolBlobAuditingPolicyResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SynapseDataMaskingPolicyResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SynapseDataMaskingPolicyResource.CreateResourceIdentifier" /> to create a <see cref="SynapseDataMaskingPolicyResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SynapseDataMaskingPolicyResource"/> object. </returns>
        public virtual SynapseDataMaskingPolicyResource GetSynapseDataMaskingPolicyResource(ResourceIdentifier id)
        {
            SynapseDataMaskingPolicyResource.ValidateResourceId(id);
            return new SynapseDataMaskingPolicyResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SynapseDataMaskingRuleResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SynapseDataMaskingRuleResource.CreateResourceIdentifier" /> to create a <see cref="SynapseDataMaskingRuleResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SynapseDataMaskingRuleResource"/> object. </returns>
        public virtual SynapseDataMaskingRuleResource GetSynapseDataMaskingRuleResource(ResourceIdentifier id)
        {
            SynapseDataMaskingRuleResource.ValidateResourceId(id);
            return new SynapseDataMaskingRuleResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SynapseSqlPoolColumnResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SynapseSqlPoolColumnResource.CreateResourceIdentifier" /> to create a <see cref="SynapseSqlPoolColumnResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SynapseSqlPoolColumnResource"/> object. </returns>
        public virtual SynapseSqlPoolColumnResource GetSynapseSqlPoolColumnResource(ResourceIdentifier id)
        {
            SynapseSqlPoolColumnResource.ValidateResourceId(id);
            return new SynapseSqlPoolColumnResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SynapseWorkloadGroupResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SynapseWorkloadGroupResource.CreateResourceIdentifier" /> to create a <see cref="SynapseWorkloadGroupResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SynapseWorkloadGroupResource"/> object. </returns>
        public virtual SynapseWorkloadGroupResource GetSynapseWorkloadGroupResource(ResourceIdentifier id)
        {
            SynapseWorkloadGroupResource.ValidateResourceId(id);
            return new SynapseWorkloadGroupResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SynapseWorkloadClassifierResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SynapseWorkloadClassifierResource.CreateResourceIdentifier" /> to create a <see cref="SynapseWorkloadClassifierResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SynapseWorkloadClassifierResource"/> object. </returns>
        public virtual SynapseWorkloadClassifierResource GetSynapseWorkloadClassifierResource(ResourceIdentifier id)
        {
            SynapseWorkloadClassifierResource.ValidateResourceId(id);
            return new SynapseWorkloadClassifierResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SynapseServerBlobAuditingPolicyResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SynapseServerBlobAuditingPolicyResource.CreateResourceIdentifier" /> to create a <see cref="SynapseServerBlobAuditingPolicyResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SynapseServerBlobAuditingPolicyResource"/> object. </returns>
        public virtual SynapseServerBlobAuditingPolicyResource GetSynapseServerBlobAuditingPolicyResource(ResourceIdentifier id)
        {
            SynapseServerBlobAuditingPolicyResource.ValidateResourceId(id);
            return new SynapseServerBlobAuditingPolicyResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SynapseExtendedServerBlobAuditingPolicyResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SynapseExtendedServerBlobAuditingPolicyResource.CreateResourceIdentifier" /> to create a <see cref="SynapseExtendedServerBlobAuditingPolicyResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SynapseExtendedServerBlobAuditingPolicyResource"/> object. </returns>
        public virtual SynapseExtendedServerBlobAuditingPolicyResource GetSynapseExtendedServerBlobAuditingPolicyResource(ResourceIdentifier id)
        {
            SynapseExtendedServerBlobAuditingPolicyResource.ValidateResourceId(id);
            return new SynapseExtendedServerBlobAuditingPolicyResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SynapseServerSecurityAlertPolicyResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SynapseServerSecurityAlertPolicyResource.CreateResourceIdentifier" /> to create a <see cref="SynapseServerSecurityAlertPolicyResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SynapseServerSecurityAlertPolicyResource"/> object. </returns>
        public virtual SynapseServerSecurityAlertPolicyResource GetSynapseServerSecurityAlertPolicyResource(ResourceIdentifier id)
        {
            SynapseServerSecurityAlertPolicyResource.ValidateResourceId(id);
            return new SynapseServerSecurityAlertPolicyResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SynapseServerVulnerabilityAssessmentResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SynapseServerVulnerabilityAssessmentResource.CreateResourceIdentifier" /> to create a <see cref="SynapseServerVulnerabilityAssessmentResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SynapseServerVulnerabilityAssessmentResource"/> object. </returns>
        public virtual SynapseServerVulnerabilityAssessmentResource GetSynapseServerVulnerabilityAssessmentResource(ResourceIdentifier id)
        {
            SynapseServerVulnerabilityAssessmentResource.ValidateResourceId(id);
            return new SynapseServerVulnerabilityAssessmentResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SynapseEncryptionProtectorResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SynapseEncryptionProtectorResource.CreateResourceIdentifier" /> to create a <see cref="SynapseEncryptionProtectorResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SynapseEncryptionProtectorResource"/> object. </returns>
        public virtual SynapseEncryptionProtectorResource GetSynapseEncryptionProtectorResource(ResourceIdentifier id)
        {
            SynapseEncryptionProtectorResource.ValidateResourceId(id);
            return new SynapseEncryptionProtectorResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SynapseRecoverableSqlPoolResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SynapseRecoverableSqlPoolResource.CreateResourceIdentifier" /> to create a <see cref="SynapseRecoverableSqlPoolResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SynapseRecoverableSqlPoolResource"/> object. </returns>
        public virtual SynapseRecoverableSqlPoolResource GetSynapseRecoverableSqlPoolResource(ResourceIdentifier id)
        {
            SynapseRecoverableSqlPoolResource.ValidateResourceId(id);
            return new SynapseRecoverableSqlPoolResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SynapseDedicatedSqlMinimalTlsSettingResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SynapseDedicatedSqlMinimalTlsSettingResource.CreateResourceIdentifier" /> to create a <see cref="SynapseDedicatedSqlMinimalTlsSettingResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SynapseDedicatedSqlMinimalTlsSettingResource"/> object. </returns>
        public virtual SynapseDedicatedSqlMinimalTlsSettingResource GetSynapseDedicatedSqlMinimalTlsSettingResource(ResourceIdentifier id)
        {
            SynapseDedicatedSqlMinimalTlsSettingResource.ValidateResourceId(id);
            return new SynapseDedicatedSqlMinimalTlsSettingResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SynapseWorkspaceResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SynapseWorkspaceResource.CreateResourceIdentifier" /> to create a <see cref="SynapseWorkspaceResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SynapseWorkspaceResource"/> object. </returns>
        public virtual SynapseWorkspaceResource GetSynapseWorkspaceResource(ResourceIdentifier id)
        {
            SynapseWorkspaceResource.ValidateResourceId(id);
            return new SynapseWorkspaceResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SynapseWorkspaceAdministratorResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SynapseWorkspaceAdministratorResource.CreateResourceIdentifier" /> to create a <see cref="SynapseWorkspaceAdministratorResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SynapseWorkspaceAdministratorResource"/> object. </returns>
        public virtual SynapseWorkspaceAdministratorResource GetSynapseWorkspaceAdministratorResource(ResourceIdentifier id)
        {
            SynapseWorkspaceAdministratorResource.ValidateResourceId(id);
            return new SynapseWorkspaceAdministratorResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SynapseWorkspaceSqlAdministratorResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SynapseWorkspaceSqlAdministratorResource.CreateResourceIdentifier" /> to create a <see cref="SynapseWorkspaceSqlAdministratorResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SynapseWorkspaceSqlAdministratorResource"/> object. </returns>
        public virtual SynapseWorkspaceSqlAdministratorResource GetSynapseWorkspaceSqlAdministratorResource(ResourceIdentifier id)
        {
            SynapseWorkspaceSqlAdministratorResource.ValidateResourceId(id);
            return new SynapseWorkspaceSqlAdministratorResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SynapseManagedIdentitySqlControlSettingResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SynapseManagedIdentitySqlControlSettingResource.CreateResourceIdentifier" /> to create a <see cref="SynapseManagedIdentitySqlControlSettingResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SynapseManagedIdentitySqlControlSettingResource"/> object. </returns>
        public virtual SynapseManagedIdentitySqlControlSettingResource GetSynapseManagedIdentitySqlControlSettingResource(ResourceIdentifier id)
        {
            SynapseManagedIdentitySqlControlSettingResource.ValidateResourceId(id);
            return new SynapseManagedIdentitySqlControlSettingResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SynapseRestorableDroppedSqlPoolResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SynapseRestorableDroppedSqlPoolResource.CreateResourceIdentifier" /> to create a <see cref="SynapseRestorableDroppedSqlPoolResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SynapseRestorableDroppedSqlPoolResource"/> object. </returns>
        public virtual SynapseRestorableDroppedSqlPoolResource GetSynapseRestorableDroppedSqlPoolResource(ResourceIdentifier id)
        {
            SynapseRestorableDroppedSqlPoolResource.ValidateResourceId(id);
            return new SynapseRestorableDroppedSqlPoolResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SynapseBigDataPoolInfoResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SynapseBigDataPoolInfoResource.CreateResourceIdentifier" /> to create a <see cref="SynapseBigDataPoolInfoResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SynapseBigDataPoolInfoResource"/> object. </returns>
        public virtual SynapseBigDataPoolInfoResource GetSynapseBigDataPoolInfoResource(ResourceIdentifier id)
        {
            SynapseBigDataPoolInfoResource.ValidateResourceId(id);
            return new SynapseBigDataPoolInfoResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SynapseLibraryResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SynapseLibraryResource.CreateResourceIdentifier" /> to create a <see cref="SynapseLibraryResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SynapseLibraryResource"/> object. </returns>
        public virtual SynapseLibraryResource GetSynapseLibraryResource(ResourceIdentifier id)
        {
            SynapseLibraryResource.ValidateResourceId(id);
            return new SynapseLibraryResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SynapseIntegrationRuntimeResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SynapseIntegrationRuntimeResource.CreateResourceIdentifier" /> to create a <see cref="SynapseIntegrationRuntimeResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SynapseIntegrationRuntimeResource"/> object. </returns>
        public virtual SynapseIntegrationRuntimeResource GetSynapseIntegrationRuntimeResource(ResourceIdentifier id)
        {
            SynapseIntegrationRuntimeResource.ValidateResourceId(id);
            return new SynapseIntegrationRuntimeResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SynapseSparkConfigurationResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SynapseSparkConfigurationResource.CreateResourceIdentifier" /> to create a <see cref="SynapseSparkConfigurationResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SynapseSparkConfigurationResource"/> object. </returns>
        public virtual SynapseSparkConfigurationResource GetSynapseSparkConfigurationResource(ResourceIdentifier id)
        {
            SynapseSparkConfigurationResource.ValidateResourceId(id);
            return new SynapseSparkConfigurationResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SynapseKustoPoolResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SynapseKustoPoolResource.CreateResourceIdentifier" /> to create a <see cref="SynapseKustoPoolResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SynapseKustoPoolResource"/> object. </returns>
        public virtual SynapseKustoPoolResource GetSynapseKustoPoolResource(ResourceIdentifier id)
        {
            SynapseKustoPoolResource.ValidateResourceId(id);
            return new SynapseKustoPoolResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SynapseAttachedDatabaseConfigurationResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SynapseAttachedDatabaseConfigurationResource.CreateResourceIdentifier" /> to create a <see cref="SynapseAttachedDatabaseConfigurationResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SynapseAttachedDatabaseConfigurationResource"/> object. </returns>
        public virtual SynapseAttachedDatabaseConfigurationResource GetSynapseAttachedDatabaseConfigurationResource(ResourceIdentifier id)
        {
            SynapseAttachedDatabaseConfigurationResource.ValidateResourceId(id);
            return new SynapseAttachedDatabaseConfigurationResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SynapseDatabaseResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SynapseDatabaseResource.CreateResourceIdentifier" /> to create a <see cref="SynapseDatabaseResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SynapseDatabaseResource"/> object. </returns>
        public virtual SynapseDatabaseResource GetSynapseDatabaseResource(ResourceIdentifier id)
        {
            SynapseDatabaseResource.ValidateResourceId(id);
            return new SynapseDatabaseResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SynapseDataConnectionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SynapseDataConnectionResource.CreateResourceIdentifier" /> to create a <see cref="SynapseDataConnectionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SynapseDataConnectionResource"/> object. </returns>
        public virtual SynapseDataConnectionResource GetSynapseDataConnectionResource(ResourceIdentifier id)
        {
            SynapseDataConnectionResource.ValidateResourceId(id);
            return new SynapseDataConnectionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SynapseClusterPrincipalAssignmentResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SynapseClusterPrincipalAssignmentResource.CreateResourceIdentifier" /> to create a <see cref="SynapseClusterPrincipalAssignmentResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SynapseClusterPrincipalAssignmentResource"/> object. </returns>
        public virtual SynapseClusterPrincipalAssignmentResource GetSynapseClusterPrincipalAssignmentResource(ResourceIdentifier id)
        {
            SynapseClusterPrincipalAssignmentResource.ValidateResourceId(id);
            return new SynapseClusterPrincipalAssignmentResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SynapseDatabasePrincipalAssignmentResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SynapseDatabasePrincipalAssignmentResource.CreateResourceIdentifier" /> to create a <see cref="SynapseDatabasePrincipalAssignmentResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SynapseDatabasePrincipalAssignmentResource"/> object. </returns>
        public virtual SynapseDatabasePrincipalAssignmentResource GetSynapseDatabasePrincipalAssignmentResource(ResourceIdentifier id)
        {
            SynapseDatabasePrincipalAssignmentResource.ValidateResourceId(id);
            return new SynapseDatabasePrincipalAssignmentResource(Client, id);
        }
    }
}
