// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Synapse.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmSynapseModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="Synapse.SynapseAadOnlyAuthenticationData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="isAadOnlyAuthenticationEnabled"> Azure Active Directory only Authentication enabled. </param>
        /// <param name="state"> property configuration state. </param>
        /// <param name="createdOn"> property configuration date. </param>
        /// <returns> A new <see cref="Synapse.SynapseAadOnlyAuthenticationData"/> instance for mocking. </returns>
        public static SynapseAadOnlyAuthenticationData SynapseAadOnlyAuthenticationData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, bool? isAadOnlyAuthenticationEnabled = null, AadAuthenticationState? state = null, DateTimeOffset? createdOn = null)
        {
            return new SynapseAadOnlyAuthenticationData(
                id,
                name,
                resourceType,
                systemData,
                isAadOnlyAuthenticationEnabled,
                state,
                createdOn,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Synapse.SynapseIPFirewallRuleInfoData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="endIPAddress"> The end IP address of the firewall rule. Must be IPv4 format. Must be greater than or equal to startIpAddress. </param>
        /// <param name="provisioningState"> Resource provisioning state. </param>
        /// <param name="startIPAddress"> The start IP address of the firewall rule. Must be IPv4 format. </param>
        /// <returns> A new <see cref="Synapse.SynapseIPFirewallRuleInfoData"/> instance for mocking. </returns>
        public static SynapseIPFirewallRuleInfoData SynapseIPFirewallRuleInfoData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IPAddress endIPAddress = null, SynapseProvisioningState? provisioningState = null, IPAddress startIPAddress = null)
        {
            return new SynapseIPFirewallRuleInfoData(
                id,
                name,
                resourceType,
                systemData,
                endIPAddress,
                provisioningState,
                startIPAddress,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SynapseIPFirewallRuleProperties"/>. </summary>
        /// <param name="endIPAddress"> The end IP address of the firewall rule. Must be IPv4 format. Must be greater than or equal to startIpAddress. </param>
        /// <param name="provisioningState"> Resource provisioning state. </param>
        /// <param name="startIPAddress"> The start IP address of the firewall rule. Must be IPv4 format. </param>
        /// <returns> A new <see cref="Models.SynapseIPFirewallRuleProperties"/> instance for mocking. </returns>
        public static SynapseIPFirewallRuleProperties SynapseIPFirewallRuleProperties(IPAddress endIPAddress = null, SynapseProvisioningState? provisioningState = null, IPAddress startIPAddress = null)
        {
            return new SynapseIPFirewallRuleProperties(endIPAddress, provisioningState, startIPAddress, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ReplaceAllFirewallRulesOperationResult"/>. </summary>
        /// <param name="operationId"> The operation ID. </param>
        /// <returns> A new <see cref="Models.ReplaceAllFirewallRulesOperationResult"/> instance for mocking. </returns>
        public static ReplaceAllFirewallRulesOperationResult ReplaceAllFirewallRulesOperationResult(string operationId = null)
        {
            return new ReplaceAllFirewallRulesOperationResult(operationId, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Synapse.SynapseKeyData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="isActiveCmk"> Used to activate the workspace after a customer managed key is provided. </param>
        /// <param name="keyVaultUri"> The Key Vault Url of the workspace key. </param>
        /// <returns> A new <see cref="Synapse.SynapseKeyData"/> instance for mocking. </returns>
        public static SynapseKeyData SynapseKeyData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, bool? isActiveCmk = null, Uri keyVaultUri = null)
        {
            return new SynapseKeyData(
                id,
                name,
                resourceType,
                systemData,
                isActiveCmk,
                keyVaultUri,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Synapse.SynapsePrivateEndpointConnectionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="privateEndpointId"> The private endpoint which the connection belongs to. </param>
        /// <param name="connectionState"> Connection state of the private endpoint connection. </param>
        /// <param name="provisioningState"> Provisioning state of the private endpoint connection. </param>
        /// <returns> A new <see cref="Synapse.SynapsePrivateEndpointConnectionData"/> instance for mocking. </returns>
        public static SynapsePrivateEndpointConnectionData SynapsePrivateEndpointConnectionData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ResourceIdentifier privateEndpointId = null, SynapsePrivateLinkServiceConnectionState connectionState = null, string provisioningState = null)
        {
            return new SynapsePrivateEndpointConnectionData(
                id,
                name,
                resourceType,
                systemData,
                privateEndpointId != null ? ResourceManagerModelFactory.SubResource(privateEndpointId) : null,
                connectionState,
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SynapsePrivateEndpointConnectionProperties"/>. </summary>
        /// <param name="privateEndpointId"> The private endpoint which the connection belongs to. </param>
        /// <param name="connectionState"> Connection state of the private endpoint connection. </param>
        /// <param name="provisioningState"> Provisioning state of the private endpoint connection. </param>
        /// <returns> A new <see cref="Models.SynapsePrivateEndpointConnectionProperties"/> instance for mocking. </returns>
        public static SynapsePrivateEndpointConnectionProperties SynapsePrivateEndpointConnectionProperties(ResourceIdentifier privateEndpointId = null, SynapsePrivateLinkServiceConnectionState connectionState = null, string provisioningState = null)
        {
            return new SynapsePrivateEndpointConnectionProperties(privateEndpointId != null ? ResourceManagerModelFactory.SubResource(privateEndpointId) : null, connectionState, provisioningState, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SynapsePrivateLinkServiceConnectionState"/>. </summary>
        /// <param name="status"> The private link service connection status. </param>
        /// <param name="description"> The private link service connection description. </param>
        /// <param name="actionsRequired"> The actions required for private link service connection. </param>
        /// <returns> A new <see cref="Models.SynapsePrivateLinkServiceConnectionState"/> instance for mocking. </returns>
        public static SynapsePrivateLinkServiceConnectionState SynapsePrivateLinkServiceConnectionState(string status = null, string description = null, string actionsRequired = null)
        {
            return new SynapsePrivateLinkServiceConnectionState(status, description, actionsRequired, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Synapse.SynapsePrivateLinkResourceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> The private link resource properties. </param>
        /// <returns> A new <see cref="Synapse.SynapsePrivateLinkResourceData"/> instance for mocking. </returns>
        public static SynapsePrivateLinkResourceData SynapsePrivateLinkResourceData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, SynapsePrivateLinkResourceProperties properties = null)
        {
            return new SynapsePrivateLinkResourceData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SynapsePrivateLinkResourceProperties"/>. </summary>
        /// <param name="groupId"> The private link resource group id. </param>
        /// <param name="requiredMembers"> The private link resource required member names. </param>
        /// <param name="requiredZoneNames"> Required DNS zone names of the the private link resource. </param>
        /// <returns> A new <see cref="Models.SynapsePrivateLinkResourceProperties"/> instance for mocking. </returns>
        public static SynapsePrivateLinkResourceProperties SynapsePrivateLinkResourceProperties(string groupId = null, IEnumerable<string> requiredMembers = null, IEnumerable<string> requiredZoneNames = null)
        {
            requiredMembers ??= new List<string>();
            requiredZoneNames ??= new List<string>();

            return new SynapsePrivateLinkResourceProperties(groupId, requiredMembers?.ToList(), requiredZoneNames?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Synapse.SynapsePrivateLinkHubData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="provisioningState"> PrivateLinkHub provisioning state. </param>
        /// <param name="privateEndpointConnections"> List of private endpoint connections. </param>
        /// <returns> A new <see cref="Synapse.SynapsePrivateLinkHubData"/> instance for mocking. </returns>
        public static SynapsePrivateLinkHubData SynapsePrivateLinkHubData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, string provisioningState = null, IEnumerable<PrivateEndpointConnectionForPrivateLinkHubBasic> privateEndpointConnections = null)
        {
            tags ??= new Dictionary<string, string>();
            privateEndpointConnections ??= new List<PrivateEndpointConnectionForPrivateLinkHubBasic>();

            return new SynapsePrivateLinkHubData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                provisioningState,
                privateEndpointConnections?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PrivateEndpointConnectionForPrivateLinkHubBasic"/>. </summary>
        /// <param name="id"></param>
        /// <param name="properties"> Properties of a private endpoint connection. </param>
        /// <returns> A new <see cref="Models.PrivateEndpointConnectionForPrivateLinkHubBasic"/> instance for mocking. </returns>
        public static PrivateEndpointConnectionForPrivateLinkHubBasic PrivateEndpointConnectionForPrivateLinkHubBasic(string id = null, SynapsePrivateEndpointConnectionProperties properties = null)
        {
            return new PrivateEndpointConnectionForPrivateLinkHubBasic(id, properties, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Synapse.SynapsePrivateEndpointConnectionForPrivateLinkHubData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> Properties of a private endpoint connection. </param>
        /// <returns> A new <see cref="Synapse.SynapsePrivateEndpointConnectionForPrivateLinkHubData"/> instance for mocking. </returns>
        public static SynapsePrivateEndpointConnectionForPrivateLinkHubData SynapsePrivateEndpointConnectionForPrivateLinkHubData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, SynapsePrivateEndpointConnectionProperties properties = null)
        {
            return new SynapsePrivateEndpointConnectionForPrivateLinkHubData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Synapse.SynapseSqlPoolData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="sku"> SQL pool SKU. </param>
        /// <param name="maxSizeBytes"> Maximum size in bytes. </param>
        /// <param name="collation"> Collation mode. </param>
        /// <param name="sourceDatabaseId"> Source database to create from. </param>
        /// <param name="recoverableDatabaseId"> Backup database to restore from. </param>
        /// <param name="provisioningState"> Resource state. </param>
        /// <param name="status"> Resource status. </param>
        /// <param name="restorePointInTime"> Snapshot time to restore. </param>
        /// <param name="createMode">
        /// Specifies the mode of sql pool creation.
        ///
        /// Default: regular sql pool creation.
        ///
        /// PointInTimeRestore: Creates a sql pool by restoring a point in time backup of an existing sql pool. sourceDatabaseId must be specified as the resource ID of the existing sql pool, and restorePointInTime must be specified.
        ///
        /// Recovery: Creates a sql pool by a geo-replicated backup. sourceDatabaseId  must be specified as the recoverableDatabaseId to restore.
        ///
        /// Restore: Creates a sql pool by restoring a backup of a deleted sql  pool. SourceDatabaseId should be the sql pool's original resource ID. SourceDatabaseId and sourceDatabaseDeletionDate must be specified.
        /// </param>
        /// <param name="createdOn"> Date the SQL pool was created. </param>
        /// <param name="storageAccountType"> The storage account type used to store backups for this sql pool. </param>
        /// <param name="sourceDatabaseDeletionOn"> Specifies the time that the sql pool was deleted. </param>
        /// <returns> A new <see cref="Synapse.SynapseSqlPoolData"/> instance for mocking. </returns>
        public static SynapseSqlPoolData SynapseSqlPoolData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, SynapseSku sku = null, long? maxSizeBytes = null, string collation = null, string sourceDatabaseId = null, string recoverableDatabaseId = null, string provisioningState = null, string status = null, DateTimeOffset? restorePointInTime = null, SqlPoolCreateMode? createMode = null, DateTimeOffset? createdOn = null, SqlPoolStorageAccountType? storageAccountType = null, DateTimeOffset? sourceDatabaseDeletionOn = null)
        {
            tags ??= new Dictionary<string, string>();

            return new SynapseSqlPoolData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                sku,
                maxSizeBytes,
                collation,
                sourceDatabaseId,
                recoverableDatabaseId,
                provisioningState,
                status,
                restorePointInTime,
                createMode,
                createdOn,
                storageAccountType,
                sourceDatabaseDeletionOn,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SynapseSqlPoolPatch"/>. </summary>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="location"> The geo-location where the resource lives. </param>
        /// <param name="sku"> SQL pool SKU. </param>
        /// <param name="maxSizeBytes"> Maximum size in bytes. </param>
        /// <param name="collation"> Collation mode. </param>
        /// <param name="sourceDatabaseId"> Source database to create from. </param>
        /// <param name="recoverableDatabaseId"> Backup database to restore from. </param>
        /// <param name="provisioningState"> Resource state. </param>
        /// <param name="status"> Resource status. </param>
        /// <param name="restorePointInTime"> Snapshot time to restore. </param>
        /// <param name="createMode">
        /// Specifies the mode of sql pool creation.
        ///
        /// Default: regular sql pool creation.
        ///
        /// PointInTimeRestore: Creates a sql pool by restoring a point in time backup of an existing sql pool. sourceDatabaseId must be specified as the resource ID of the existing sql pool, and restorePointInTime must be specified.
        ///
        /// Recovery: Creates a sql pool by a geo-replicated backup. sourceDatabaseId  must be specified as the recoverableDatabaseId to restore.
        ///
        /// Restore: Creates a sql pool by restoring a backup of a deleted sql  pool. SourceDatabaseId should be the sql pool's original resource ID. SourceDatabaseId and sourceDatabaseDeletionDate must be specified.
        /// </param>
        /// <param name="createdOn"> Date the SQL pool was created. </param>
        /// <param name="storageAccountType"> The storage account type used to store backups for this sql pool. </param>
        /// <param name="sourceDatabaseDeletionOn"> Specifies the time that the sql pool was deleted. </param>
        /// <returns> A new <see cref="Models.SynapseSqlPoolPatch"/> instance for mocking. </returns>
        public static SynapseSqlPoolPatch SynapseSqlPoolPatch(IDictionary<string, string> tags = null, AzureLocation? location = null, SynapseSku sku = null, long? maxSizeBytes = null, string collation = null, string sourceDatabaseId = null, string recoverableDatabaseId = null, string provisioningState = null, string status = null, DateTimeOffset? restorePointInTime = null, SqlPoolCreateMode? createMode = null, DateTimeOffset? createdOn = null, SqlPoolStorageAccountType? storageAccountType = null, DateTimeOffset? sourceDatabaseDeletionOn = null)
        {
            tags ??= new Dictionary<string, string>();

            return new SynapseSqlPoolPatch(
                tags,
                location,
                sku,
                maxSizeBytes,
                collation,
                sourceDatabaseId,
                recoverableDatabaseId,
                provisioningState,
                status,
                restorePointInTime,
                createMode,
                createdOn,
                storageAccountType,
                sourceDatabaseDeletionOn,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Synapse.SynapseMetadataSyncConfigurationData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="isEnabled"> Indicates whether the metadata sync is enabled or disabled. </param>
        /// <param name="syncIntervalInMinutes"> The Sync Interval in minutes. </param>
        /// <returns> A new <see cref="Synapse.SynapseMetadataSyncConfigurationData"/> instance for mocking. </returns>
        public static SynapseMetadataSyncConfigurationData SynapseMetadataSyncConfigurationData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, bool? isEnabled = null, int? syncIntervalInMinutes = null)
        {
            return new SynapseMetadataSyncConfigurationData(
                id,
                name,
                resourceType,
                systemData,
                isEnabled,
                syncIntervalInMinutes,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Synapse.SynapseGeoBackupPolicyData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="kind"> Kind of geo backup policy.  This is metadata used for the Azure portal experience. </param>
        /// <param name="location"> Backup policy location. </param>
        /// <param name="state"> The state of the geo backup policy. </param>
        /// <param name="storageType"> The storage type of the geo backup policy. </param>
        /// <returns> A new <see cref="Synapse.SynapseGeoBackupPolicyData"/> instance for mocking. </returns>
        public static SynapseGeoBackupPolicyData SynapseGeoBackupPolicyData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string kind = null, AzureLocation? location = null, SynapseGeoBackupPolicyState state = default, string storageType = null)
        {
            return new SynapseGeoBackupPolicyData(
                id,
                name,
                resourceType,
                systemData,
                kind,
                location,
                state,
                storageType,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Synapse.SynapseDataWarehouseUserActivityData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="activeQueriesCount"> Count of running and suspended queries. </param>
        /// <returns> A new <see cref="Synapse.SynapseDataWarehouseUserActivityData"/> instance for mocking. </returns>
        public static SynapseDataWarehouseUserActivityData SynapseDataWarehouseUserActivityData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, int? activeQueriesCount = null)
        {
            return new SynapseDataWarehouseUserActivityData(
                id,
                name,
                resourceType,
                systemData,
                activeQueriesCount,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Synapse.SynapseRestorePointData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="restorePointType"> The type of restore point. </param>
        /// <param name="earliestRestoreOn"> The earliest time to which this database can be restored. </param>
        /// <param name="restorePointCreationOn"> The time the backup was taken. </param>
        /// <param name="restorePointLabel"> The label of restore point for backup request by user. </param>
        /// <returns> A new <see cref="Synapse.SynapseRestorePointData"/> instance for mocking. </returns>
        public static SynapseRestorePointData SynapseRestorePointData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AzureLocation? location = null, SynapseRestorePointType? restorePointType = null, DateTimeOffset? earliestRestoreOn = null, DateTimeOffset? restorePointCreationOn = null, string restorePointLabel = null)
        {
            return new SynapseRestorePointData(
                id,
                name,
                resourceType,
                systemData,
                location,
                restorePointType,
                earliestRestoreOn,
                restorePointCreationOn,
                restorePointLabel,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Synapse.SynapseReplicationLinkData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="location"> Location of the workspace that contains this firewall rule. </param>
        /// <param name="isTerminationAllowed"> Legacy value indicating whether termination is allowed.  Currently always returns true. </param>
        /// <param name="replicationMode"> Replication mode of this replication link. </param>
        /// <param name="partnerServer"> The name of the workspace hosting the partner Sql pool. </param>
        /// <param name="partnerDatabase"> The name of the partner Sql pool. </param>
        /// <param name="partnerLocation"> The Azure Region of the partner Sql pool. </param>
        /// <param name="role"> The role of the Sql pool in the replication link. </param>
        /// <param name="partnerRole"> The role of the partner Sql pool in the replication link. </param>
        /// <param name="startOn"> The start time for the replication link. </param>
        /// <param name="percentComplete"> The percentage of seeding complete for the replication link. </param>
        /// <param name="replicationState"> The replication state for the replication link. </param>
        /// <returns> A new <see cref="Synapse.SynapseReplicationLinkData"/> instance for mocking. </returns>
        public static SynapseReplicationLinkData SynapseReplicationLinkData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AzureLocation? location = null, bool? isTerminationAllowed = null, string replicationMode = null, string partnerServer = null, string partnerDatabase = null, AzureLocation? partnerLocation = null, SynapseReplicationRole? role = null, SynapseReplicationRole? partnerRole = null, DateTimeOffset? startOn = null, int? percentComplete = null, SynapseReplicationState? replicationState = null)
        {
            return new SynapseReplicationLinkData(
                id,
                name,
                resourceType,
                systemData,
                location,
                isTerminationAllowed,
                replicationMode,
                partnerServer,
                partnerDatabase,
                partnerLocation,
                role,
                partnerRole,
                startOn,
                percentComplete,
                replicationState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Synapse.SynapseMaintenanceWindowData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="timeRanges"></param>
        /// <returns> A new <see cref="Synapse.SynapseMaintenanceWindowData"/> instance for mocking. </returns>
        public static SynapseMaintenanceWindowData SynapseMaintenanceWindowData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IEnumerable<SynapseMaintenanceWindowTimeRange> timeRanges = null)
        {
            timeRanges ??= new List<SynapseMaintenanceWindowTimeRange>();

            return new SynapseMaintenanceWindowData(
                id,
                name,
                resourceType,
                systemData,
                timeRanges?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Synapse.SynapseMaintenanceWindowOptionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="isEnabled"> Whether maintenance windows are enabled for the database. </param>
        /// <param name="maintenanceWindowCycles"> Available maintenance cycles e.g. {Saturday, 0, 48*60}, {Wednesday, 0, 24*60}. </param>
        /// <param name="minDurationInMinutes"> Minimum duration of maintenance window. </param>
        /// <param name="defaultDurationInMinutes"> Default duration for maintenance window. </param>
        /// <param name="minCycles"> Minimum number of maintenance windows cycles to be set on the database. </param>
        /// <param name="timeGranularityInMinutes"> Time granularity in minutes for maintenance windows. </param>
        /// <param name="allowMultipleMaintenanceWindowsPerCycle"> Whether we allow multiple maintenance windows per cycle. </param>
        /// <returns> A new <see cref="Synapse.SynapseMaintenanceWindowOptionData"/> instance for mocking. </returns>
        public static SynapseMaintenanceWindowOptionData SynapseMaintenanceWindowOptionData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, bool? isEnabled = null, IEnumerable<SynapseMaintenanceWindowTimeRange> maintenanceWindowCycles = null, int? minDurationInMinutes = null, int? defaultDurationInMinutes = null, int? minCycles = null, int? timeGranularityInMinutes = null, bool? allowMultipleMaintenanceWindowsPerCycle = null)
        {
            maintenanceWindowCycles ??= new List<SynapseMaintenanceWindowTimeRange>();

            return new SynapseMaintenanceWindowOptionData(
                id,
                name,
                resourceType,
                systemData,
                isEnabled,
                maintenanceWindowCycles?.ToList(),
                minDurationInMinutes,
                defaultDurationInMinutes,
                minCycles,
                timeGranularityInMinutes,
                allowMultipleMaintenanceWindowsPerCycle,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Synapse.SynapseTransparentDataEncryptionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="status"> The status of the database transparent data encryption. </param>
        /// <returns> A new <see cref="Synapse.SynapseTransparentDataEncryptionData"/> instance for mocking. </returns>
        public static SynapseTransparentDataEncryptionData SynapseTransparentDataEncryptionData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AzureLocation? location = null, SynapseTransparentDataEncryptionStatus? status = null)
        {
            return new SynapseTransparentDataEncryptionData(
                id,
                name,
                resourceType,
                systemData,
                location,
                status,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Synapse.SynapseSqlPoolBlobAuditingPolicyData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="kind"> Resource kind. </param>
        /// <param name="state"> Specifies the state of the policy. If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required. </param>
        /// <param name="storageEndpoint"> Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint is required. </param>
        /// <param name="storageAccountAccessKey"> Specifies the identifier key of the auditing storage account. If state is Enabled and storageEndpoint is specified, storageAccountAccessKey is required. </param>
        /// <param name="retentionDays"> Specifies the number of days to keep in the audit logs in the storage account. </param>
        /// <param name="auditActionsAndGroups">
        /// Specifies the Actions-Groups and Actions to audit.
        ///
        /// The recommended set of action groups to use is the following combination - this will audit all the queries and stored procedures executed against the database, as well as successful and failed logins:
        ///
        /// BATCH_COMPLETED_GROUP,
        /// SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP,
        /// FAILED_DATABASE_AUTHENTICATION_GROUP.
        ///
        /// This above combination is also the set that is configured by default when enabling auditing from the Azure portal.
        ///
        /// The supported action groups to audit are (note: choose only specific groups that cover your auditing needs. Using unnecessary groups could lead to very large quantities of audit records):
        ///
        /// APPLICATION_ROLE_CHANGE_PASSWORD_GROUP
        /// BACKUP_RESTORE_GROUP
        /// DATABASE_LOGOUT_GROUP
        /// DATABASE_OBJECT_CHANGE_GROUP
        /// DATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP
        /// DATABASE_OBJECT_PERMISSION_CHANGE_GROUP
        /// DATABASE_OPERATION_GROUP
        /// DATABASE_PERMISSION_CHANGE_GROUP
        /// DATABASE_PRINCIPAL_CHANGE_GROUP
        /// DATABASE_PRINCIPAL_IMPERSONATION_GROUP
        /// DATABASE_ROLE_MEMBER_CHANGE_GROUP
        /// FAILED_DATABASE_AUTHENTICATION_GROUP
        /// SCHEMA_OBJECT_ACCESS_GROUP
        /// SCHEMA_OBJECT_CHANGE_GROUP
        /// SCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP
        /// SCHEMA_OBJECT_PERMISSION_CHANGE_GROUP
        /// SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP
        /// USER_CHANGE_PASSWORD_GROUP
        /// BATCH_STARTED_GROUP
        /// BATCH_COMPLETED_GROUP
        ///
        /// These are groups that cover all sql statements and stored procedures executed against the database, and should not be used in combination with other groups as this will result in duplicate audit logs.
        ///
        /// For more information, see [Database-Level Audit Action Groups](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups).
        ///
        /// For Database auditing policy, specific Actions can also be specified (note that Actions cannot be specified for Server auditing policy). The supported actions to audit are:
        /// SELECT
        /// UPDATE
        /// INSERT
        /// DELETE
        /// EXECUTE
        /// RECEIVE
        /// REFERENCES
        ///
        /// The general form for defining an action to be audited is:
        /// {action} ON {object} BY {principal}
        ///
        /// Note that &lt;object&gt; in the above format can refer to an object like a table, view, or stored procedure, or an entire database or schema. For the latter cases, the forms DATABASE::{db_name} and SCHEMA::{schema_name} are used, respectively.
        ///
        /// For example:
        /// SELECT on dbo.myTable by public
        /// SELECT on DATABASE::myDatabase by public
        /// SELECT on SCHEMA::mySchema by public
        ///
        /// For more information, see [Database-Level Audit Actions](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions)
        /// </param>
        /// <param name="storageAccountSubscriptionId"> Specifies the blob storage subscription Id. </param>
        /// <param name="isStorageSecondaryKeyInUse"> Specifies whether storageAccountAccessKey value is the storage's secondary key. </param>
        /// <param name="isAzureMonitorTargetEnabled">
        /// Specifies whether audit events are sent to Azure Monitor.
        /// In order to send the events to Azure Monitor, specify 'state' as 'Enabled' and 'isAzureMonitorTargetEnabled' as true.
        ///
        /// When using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents' diagnostic logs category on the database should be also created.
        /// Note that for server level audit you should use the 'master' database as {databaseName}.
        ///
        /// Diagnostic Settings URI format:
        /// PUT https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
        ///
        /// For more information, see [Diagnostic Settings REST API](https://go.microsoft.com/fwlink/?linkid=2033207)
        /// or [Diagnostic Settings PowerShell](https://go.microsoft.com/fwlink/?linkid=2033043)
        ///
        /// </param>
        /// <returns> A new <see cref="Synapse.SynapseSqlPoolBlobAuditingPolicyData"/> instance for mocking. </returns>
        public static SynapseSqlPoolBlobAuditingPolicyData SynapseSqlPoolBlobAuditingPolicyData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string kind = null, SynapseBlobAuditingPolicyState? state = null, string storageEndpoint = null, string storageAccountAccessKey = null, int? retentionDays = null, IEnumerable<string> auditActionsAndGroups = null, Guid? storageAccountSubscriptionId = null, bool? isStorageSecondaryKeyInUse = null, bool? isAzureMonitorTargetEnabled = null)
        {
            auditActionsAndGroups ??= new List<string>();

            return new SynapseSqlPoolBlobAuditingPolicyData(
                id,
                name,
                resourceType,
                systemData,
                kind,
                state,
                storageEndpoint,
                storageAccountAccessKey,
                retentionDays,
                auditActionsAndGroups?.ToList(),
                storageAccountSubscriptionId,
                isStorageSecondaryKeyInUse,
                isAzureMonitorTargetEnabled,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SqlPoolUsage"/>. </summary>
        /// <param name="name"> The name of the usage metric. </param>
        /// <param name="resourceName"> The name of the resource. </param>
        /// <param name="displayName"> The usage metric display name. </param>
        /// <param name="currentValue"> The current value of the usage metric. </param>
        /// <param name="limit"> The current limit of the usage metric. </param>
        /// <param name="unit"> The units of the usage metric. </param>
        /// <param name="nextResetOn"> The next reset time for the usage metric (ISO8601 format). </param>
        /// <returns> A new <see cref="Models.SqlPoolUsage"/> instance for mocking. </returns>
        public static SqlPoolUsage SqlPoolUsage(string name = null, string resourceName = null, string displayName = null, double? currentValue = null, double? limit = null, string unit = null, DateTimeOffset? nextResetOn = null)
        {
            return new SqlPoolUsage(
                name,
                resourceName,
                displayName,
                currentValue,
                limit,
                unit,
                nextResetOn,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Synapse.SynapseSensitivityLabelData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="managedBy"> managed by. </param>
        /// <param name="schemaName"> The schema name. </param>
        /// <param name="tableName"> The table name. </param>
        /// <param name="columnName"> The column name. </param>
        /// <param name="labelName"> The label name. </param>
        /// <param name="labelId"> The label ID. </param>
        /// <param name="informationType"> The information type. </param>
        /// <param name="informationTypeId"> The information type ID. </param>
        /// <param name="isDisabled"> Is sensitivity recommendation disabled. Applicable for recommended sensitivity label only. Specifies whether the sensitivity recommendation on this column is disabled (dismissed) or not. </param>
        /// <param name="rank"></param>
        /// <returns> A new <see cref="Synapse.SynapseSensitivityLabelData"/> instance for mocking. </returns>
        public static SynapseSensitivityLabelData SynapseSensitivityLabelData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string managedBy = null, string schemaName = null, string tableName = null, string columnName = null, string labelName = null, Guid? labelId = null, string informationType = null, Guid? informationTypeId = null, bool? isDisabled = null, SynapseSensitivityLabelRank? rank = null)
        {
            return new SynapseSensitivityLabelData(
                id,
                name,
                resourceType,
                systemData,
                managedBy,
                schemaName,
                tableName,
                columnName,
                labelName,
                labelId,
                informationType,
                informationTypeId,
                isDisabled,
                rank,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SynapseSensitivityLabelUpdate"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="op"></param>
        /// <param name="schema"> Schema name of the column to update. </param>
        /// <param name="table"> Table name of the column to update. </param>
        /// <param name="column"> Column name to update. </param>
        /// <param name="sensitivityLabel"> The sensitivity label information to apply on a column. </param>
        /// <returns> A new <see cref="Models.SynapseSensitivityLabelUpdate"/> instance for mocking. </returns>
        public static SynapseSensitivityLabelUpdate SynapseSensitivityLabelUpdate(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, SynapseSensitivityLabelUpdateKind? op = null, string schema = null, string table = null, string column = null, SynapseSensitivityLabelData sensitivityLabel = null)
        {
            return new SynapseSensitivityLabelUpdate(
                id,
                name,
                resourceType,
                systemData,
                op,
                schema,
                table,
                column,
                sensitivityLabel,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SynapseRecommendedSensitivityLabelUpdate"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="op"></param>
        /// <param name="schema"> Schema name of the column to update. </param>
        /// <param name="table"> Table name of the column to update. </param>
        /// <param name="column"> Column name to update. </param>
        /// <returns> A new <see cref="Models.SynapseRecommendedSensitivityLabelUpdate"/> instance for mocking. </returns>
        public static SynapseRecommendedSensitivityLabelUpdate SynapseRecommendedSensitivityLabelUpdate(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, SynapseRecommendedSensitivityLabelUpdateKind? op = null, string schema = null, string table = null, string column = null)
        {
            return new SynapseRecommendedSensitivityLabelUpdate(
                id,
                name,
                resourceType,
                systemData,
                op,
                schema,
                table,
                column,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Synapse.SynapseSqlPoolSchemaData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <returns> A new <see cref="Synapse.SynapseSqlPoolSchemaData"/> instance for mocking. </returns>
        public static SynapseSqlPoolSchemaData SynapseSqlPoolSchemaData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null)
        {
            return new SynapseSqlPoolSchemaData(id, name, resourceType, systemData, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Synapse.SynapseSqlPoolTableData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <returns> A new <see cref="Synapse.SynapseSqlPoolTableData"/> instance for mocking. </returns>
        public static SynapseSqlPoolTableData SynapseSqlPoolTableData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null)
        {
            return new SynapseSqlPoolTableData(id, name, resourceType, systemData, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Synapse.SynapseSqlPoolColumnData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="columnType"> The column data type. </param>
        /// <param name="isComputed"> Indicates whether column value is computed or not. </param>
        /// <returns> A new <see cref="Synapse.SynapseSqlPoolColumnData"/> instance for mocking. </returns>
        public static SynapseSqlPoolColumnData SynapseSqlPoolColumnData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, SqlPoolColumnDataType? columnType = null, bool? isComputed = null)
        {
            return new SynapseSqlPoolColumnData(
                id,
                name,
                resourceType,
                systemData,
                columnType,
                isComputed,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Synapse.SynapseSqlPoolConnectionPolicyData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="kind"> Resource kind. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="securityEnabledAccess"> The state of security access. </param>
        /// <param name="proxyDnsName"> The fully qualified host name of the auditing proxy. </param>
        /// <param name="proxyPort"> The port number of the auditing proxy. </param>
        /// <param name="visibility"> The visibility of the auditing proxy. </param>
        /// <param name="useServerDefault"> Whether server default is enabled or disabled. </param>
        /// <param name="redirectionState"> The state of proxy redirection. </param>
        /// <param name="state"> The connection policy state. </param>
        /// <returns> A new <see cref="Synapse.SynapseSqlPoolConnectionPolicyData"/> instance for mocking. </returns>
        public static SynapseSqlPoolConnectionPolicyData SynapseSqlPoolConnectionPolicyData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string kind = null, AzureLocation? location = null, string securityEnabledAccess = null, string proxyDnsName = null, string proxyPort = null, string visibility = null, string useServerDefault = null, string redirectionState = null, string state = null)
        {
            return new SynapseSqlPoolConnectionPolicyData(
                id,
                name,
                resourceType,
                systemData,
                kind,
                location,
                securityEnabledAccess,
                proxyDnsName,
                proxyPort,
                visibility,
                useServerDefault,
                redirectionState,
                state,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Synapse.SynapseSqlPoolVulnerabilityAssessmentData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="storageContainerPath"> A blob storage container path to hold the scan results (e.g. https://myStorage.blob.core.windows.net/VaScans/).  It is required if server level vulnerability assessment policy doesn't set. </param>
        /// <param name="storageContainerSasKey"> A shared access signature (SAS Key) that has write access to the blob container specified in 'storageContainerPath' parameter. If 'storageAccountAccessKey' isn't specified, StorageContainerSasKey is required. </param>
        /// <param name="storageAccountAccessKey"> Specifies the identifier key of the storage account for vulnerability assessment scan results. If 'StorageContainerSasKey' isn't specified, storageAccountAccessKey is required. </param>
        /// <param name="recurringScans"> The recurring scans settings. </param>
        /// <returns> A new <see cref="Synapse.SynapseSqlPoolVulnerabilityAssessmentData"/> instance for mocking. </returns>
        public static SynapseSqlPoolVulnerabilityAssessmentData SynapseSqlPoolVulnerabilityAssessmentData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string storageContainerPath = null, string storageContainerSasKey = null, string storageAccountAccessKey = null, SynapseVulnerabilityAssessmentRecurringScansProperties recurringScans = null)
        {
            return new SynapseSqlPoolVulnerabilityAssessmentData(
                id,
                name,
                resourceType,
                systemData,
                storageContainerPath,
                storageContainerSasKey,
                storageAccountAccessKey,
                recurringScans,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Synapse.SynapseVulnerabilityAssessmentScanRecordData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="scanId"> The scan ID. </param>
        /// <param name="triggerType"> The scan trigger type. </param>
        /// <param name="state"> The scan status. </param>
        /// <param name="startOn"> The scan start time (UTC). </param>
        /// <param name="endOn"> The scan end time (UTC). </param>
        /// <param name="errors"> The scan errors. </param>
        /// <param name="storageContainerPath"> The scan results storage container path. </param>
        /// <param name="numberOfFailedSecurityChecks"> The number of failed security checks. </param>
        /// <returns> A new <see cref="Synapse.SynapseVulnerabilityAssessmentScanRecordData"/> instance for mocking. </returns>
        public static SynapseVulnerabilityAssessmentScanRecordData SynapseVulnerabilityAssessmentScanRecordData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string scanId = null, SynapseVulnerabilityAssessmentScanTriggerType? triggerType = null, SynapseVulnerabilityAssessmentScanState? state = null, DateTimeOffset? startOn = null, DateTimeOffset? endOn = null, IEnumerable<SynapseVulnerabilityAssessmentScanError> errors = null, string storageContainerPath = null, int? numberOfFailedSecurityChecks = null)
        {
            errors ??= new List<SynapseVulnerabilityAssessmentScanError>();

            return new SynapseVulnerabilityAssessmentScanRecordData(
                id,
                name,
                resourceType,
                systemData,
                scanId,
                triggerType,
                state,
                startOn,
                endOn,
                errors?.ToList(),
                storageContainerPath,
                numberOfFailedSecurityChecks,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SynapseVulnerabilityAssessmentScanError"/>. </summary>
        /// <param name="code"> The error code. </param>
        /// <param name="message"> The error message. </param>
        /// <returns> A new <see cref="Models.SynapseVulnerabilityAssessmentScanError"/> instance for mocking. </returns>
        public static SynapseVulnerabilityAssessmentScanError SynapseVulnerabilityAssessmentScanError(string code = null, string message = null)
        {
            return new SynapseVulnerabilityAssessmentScanError(code, message, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SqlPoolVulnerabilityAssessmentScansExport"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="exportedReportLocation"> Location of the exported report (e.g. https://myStorage.blob.core.windows.net/VaScans/scans/serverName/databaseName/scan_scanId.xlsx). </param>
        /// <returns> A new <see cref="Models.SqlPoolVulnerabilityAssessmentScansExport"/> instance for mocking. </returns>
        public static SqlPoolVulnerabilityAssessmentScansExport SqlPoolVulnerabilityAssessmentScansExport(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string exportedReportLocation = null)
        {
            return new SqlPoolVulnerabilityAssessmentScansExport(
                id,
                name,
                resourceType,
                systemData,
                exportedReportLocation,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Synapse.SynapseSqlPoolSecurityAlertPolicyData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="state"> Specifies the state of the policy, whether it is enabled or disabled or a policy has not been applied yet on the specific Sql pool. </param>
        /// <param name="disabledAlerts"> Specifies an array of alerts that are disabled. Allowed values are: Sql_Injection, Sql_Injection_Vulnerability, Access_Anomaly, Data_Exfiltration, Unsafe_Action. </param>
        /// <param name="emailAddresses"> Specifies an array of e-mail addresses to which the alert is sent. </param>
        /// <param name="enableEmailToAccountAdmins"> Specifies that the alert is sent to the account administrators. </param>
        /// <param name="storageEndpoint"> Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). This blob storage will hold all Threat Detection audit logs. </param>
        /// <param name="storageAccountAccessKey"> Specifies the identifier key of the Threat Detection audit storage account. </param>
        /// <param name="retentionDays"> Specifies the number of days to keep in the Threat Detection audit logs. </param>
        /// <param name="createdOn"> Specifies the UTC creation time of the policy. </param>
        /// <returns> A new <see cref="Synapse.SynapseSqlPoolSecurityAlertPolicyData"/> instance for mocking. </returns>
        public static SynapseSqlPoolSecurityAlertPolicyData SynapseSqlPoolSecurityAlertPolicyData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, SynapseSecurityAlertPolicyState? state = null, IEnumerable<string> disabledAlerts = null, IEnumerable<string> emailAddresses = null, bool? enableEmailToAccountAdmins = null, string storageEndpoint = null, string storageAccountAccessKey = null, int? retentionDays = null, DateTimeOffset? createdOn = null)
        {
            disabledAlerts ??= new List<string>();
            emailAddresses ??= new List<string>();

            return new SynapseSqlPoolSecurityAlertPolicyData(
                id,
                name,
                resourceType,
                systemData,
                state,
                disabledAlerts?.ToList(),
                emailAddresses?.ToList(),
                enableEmailToAccountAdmins,
                storageEndpoint,
                storageAccountAccessKey,
                retentionDays,
                createdOn,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Synapse.SynapseSqlPoolVulnerabilityAssessmentRuleBaselineData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="baselineResults"> The rule baseline result. </param>
        /// <returns> A new <see cref="Synapse.SynapseSqlPoolVulnerabilityAssessmentRuleBaselineData"/> instance for mocking. </returns>
        public static SynapseSqlPoolVulnerabilityAssessmentRuleBaselineData SynapseSqlPoolVulnerabilityAssessmentRuleBaselineData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IEnumerable<SqlPoolVulnerabilityAssessmentRuleBaselineItem> baselineResults = null)
        {
            baselineResults ??= new List<SqlPoolVulnerabilityAssessmentRuleBaselineItem>();

            return new SynapseSqlPoolVulnerabilityAssessmentRuleBaselineData(
                id,
                name,
                resourceType,
                systemData,
                baselineResults?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Synapse.SynapseExtendedSqlPoolBlobAuditingPolicyData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="predicateExpression"> Specifies condition of where clause when creating an audit. </param>
        /// <param name="state"> Specifies the state of the policy. If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required. </param>
        /// <param name="storageEndpoint"> Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled is required. </param>
        /// <param name="storageAccountAccessKey">
        /// Specifies the identifier key of the auditing storage account.
        /// If state is Enabled and storageEndpoint is specified, not specifying the storageAccountAccessKey will use SQL server system-assigned managed identity to access the storage.
        /// Prerequisites for using managed identity authentication:
        /// 1. Assign SQL Server a system-assigned managed identity in Azure Active Directory (AAD).
        /// 2. Grant SQL Server identity access to the storage account by adding 'Storage Blob Data Contributor' RBAC role to the server identity.
        /// For more information, see [Auditing to storage using Managed Identity authentication](https://go.microsoft.com/fwlink/?linkid=2114355)
        /// </param>
        /// <param name="retentionDays"> Specifies the number of days to keep in the audit logs in the storage account. </param>
        /// <param name="auditActionsAndGroups">
        /// Specifies the Actions-Groups and Actions to audit.
        ///
        /// The recommended set of action groups to use is the following combination - this will audit all the queries and stored procedures executed against the database, as well as successful and failed logins:
        ///
        /// BATCH_COMPLETED_GROUP,
        /// SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP,
        /// FAILED_DATABASE_AUTHENTICATION_GROUP.
        ///
        /// This above combination is also the set that is configured by default when enabling auditing from the Azure portal.
        ///
        /// The supported action groups to audit are (note: choose only specific groups that cover your auditing needs. Using unnecessary groups could lead to very large quantities of audit records):
        ///
        /// APPLICATION_ROLE_CHANGE_PASSWORD_GROUP
        /// BACKUP_RESTORE_GROUP
        /// DATABASE_LOGOUT_GROUP
        /// DATABASE_OBJECT_CHANGE_GROUP
        /// DATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP
        /// DATABASE_OBJECT_PERMISSION_CHANGE_GROUP
        /// DATABASE_OPERATION_GROUP
        /// DATABASE_PERMISSION_CHANGE_GROUP
        /// DATABASE_PRINCIPAL_CHANGE_GROUP
        /// DATABASE_PRINCIPAL_IMPERSONATION_GROUP
        /// DATABASE_ROLE_MEMBER_CHANGE_GROUP
        /// FAILED_DATABASE_AUTHENTICATION_GROUP
        /// SCHEMA_OBJECT_ACCESS_GROUP
        /// SCHEMA_OBJECT_CHANGE_GROUP
        /// SCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP
        /// SCHEMA_OBJECT_PERMISSION_CHANGE_GROUP
        /// SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP
        /// USER_CHANGE_PASSWORD_GROUP
        /// BATCH_STARTED_GROUP
        /// BATCH_COMPLETED_GROUP
        ///
        /// These are groups that cover all sql statements and stored procedures executed against the database, and should not be used in combination with other groups as this will result in duplicate audit logs.
        ///
        /// For more information, see [Database-Level Audit Action Groups](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups).
        ///
        /// For Database auditing policy, specific Actions can also be specified (note that Actions cannot be specified for Server auditing policy). The supported actions to audit are:
        /// SELECT
        /// UPDATE
        /// INSERT
        /// DELETE
        /// EXECUTE
        /// RECEIVE
        /// REFERENCES
        ///
        /// The general form for defining an action to be audited is:
        /// {action} ON {object} BY {principal}
        ///
        /// Note that &lt;object&gt; in the above format can refer to an object like a table, view, or stored procedure, or an entire database or schema. For the latter cases, the forms DATABASE::{db_name} and SCHEMA::{schema_name} are used, respectively.
        ///
        /// For example:
        /// SELECT on dbo.myTable by public
        /// SELECT on DATABASE::myDatabase by public
        /// SELECT on SCHEMA::mySchema by public
        ///
        /// For more information, see [Database-Level Audit Actions](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions)
        /// </param>
        /// <param name="storageAccountSubscriptionId"> Specifies the blob storage subscription Id. </param>
        /// <param name="isStorageSecondaryKeyInUse"> Specifies whether storageAccountAccessKey value is the storage's secondary key. </param>
        /// <param name="isAzureMonitorTargetEnabled">
        /// Specifies whether audit events are sent to Azure Monitor.
        /// In order to send the events to Azure Monitor, specify 'state' as 'Enabled' and 'isAzureMonitorTargetEnabled' as true.
        ///
        /// When using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents' diagnostic logs category on the database should be also created.
        /// Note that for server level audit you should use the 'master' database as {databaseName}.
        ///
        /// Diagnostic Settings URI format:
        /// PUT https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
        ///
        /// For more information, see [Diagnostic Settings REST API](https://go.microsoft.com/fwlink/?linkid=2033207)
        /// or [Diagnostic Settings PowerShell](https://go.microsoft.com/fwlink/?linkid=2033043)
        ///
        /// </param>
        /// <param name="queueDelayMs">
        /// Specifies the amount of time in milliseconds that can elapse before audit actions are forced to be processed.
        /// The default minimum value is 1000 (1 second). The maximum is 2,147,483,647.
        /// </param>
        /// <returns> A new <see cref="Synapse.SynapseExtendedSqlPoolBlobAuditingPolicyData"/> instance for mocking. </returns>
        public static SynapseExtendedSqlPoolBlobAuditingPolicyData SynapseExtendedSqlPoolBlobAuditingPolicyData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string predicateExpression = null, SynapseBlobAuditingPolicyState? state = null, string storageEndpoint = null, string storageAccountAccessKey = null, int? retentionDays = null, IEnumerable<string> auditActionsAndGroups = null, Guid? storageAccountSubscriptionId = null, bool? isStorageSecondaryKeyInUse = null, bool? isAzureMonitorTargetEnabled = null, int? queueDelayMs = null)
        {
            auditActionsAndGroups ??= new List<string>();

            return new SynapseExtendedSqlPoolBlobAuditingPolicyData(
                id,
                name,
                resourceType,
                systemData,
                predicateExpression,
                state,
                storageEndpoint,
                storageAccountAccessKey,
                retentionDays,
                auditActionsAndGroups?.ToList(),
                storageAccountSubscriptionId,
                isStorageSecondaryKeyInUse,
                isAzureMonitorTargetEnabled,
                queueDelayMs,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Synapse.SynapseDataMaskingPolicyData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="location"> The location of the data masking policy. </param>
        /// <param name="kind"> The kind of data masking policy. Metadata, used for Azure portal. </param>
        /// <param name="managedBy"> Fully qualified resource ID of the sql pool. </param>
        /// <param name="dataMaskingState"> The state of the data masking policy. </param>
        /// <param name="exemptPrincipals"> The list of the exempt principals. Specifies the semicolon-separated list of database users for which the data masking policy does not apply. The specified users receive data results without masking for all of the database queries. </param>
        /// <param name="applicationPrincipals"> The list of the application principals. This is a legacy parameter and is no longer used. </param>
        /// <param name="maskingLevel"> The masking level. This is a legacy parameter and is no longer used. </param>
        /// <returns> A new <see cref="Synapse.SynapseDataMaskingPolicyData"/> instance for mocking. </returns>
        public static SynapseDataMaskingPolicyData SynapseDataMaskingPolicyData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AzureLocation? location = null, string kind = null, string managedBy = null, SynapseDataMaskingState? dataMaskingState = null, string exemptPrincipals = null, string applicationPrincipals = null, string maskingLevel = null)
        {
            return new SynapseDataMaskingPolicyData(
                id,
                name,
                resourceType,
                systemData,
                location,
                kind,
                managedBy,
                dataMaskingState,
                exemptPrincipals,
                applicationPrincipals,
                maskingLevel,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Synapse.SynapseDataMaskingRuleData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="location"> The location of the data masking rule. </param>
        /// <param name="kind"> The kind of Data Masking Rule. Metadata, used for Azure portal. </param>
        /// <param name="ruleId"> The rule Id. </param>
        /// <param name="aliasName"> The alias name. This is a legacy parameter and is no longer used. </param>
        /// <param name="ruleState"> The rule state. Used to delete a rule. To delete an existing rule, specify the schemaName, tableName, columnName, maskingFunction, and specify ruleState as disabled. However, if the rule doesn't already exist, the rule will be created with ruleState set to enabled, regardless of the provided value of ruleState. </param>
        /// <param name="schemaName"> The schema name on which the data masking rule is applied. </param>
        /// <param name="tableName"> The table name on which the data masking rule is applied. </param>
        /// <param name="columnName"> The column name on which the data masking rule is applied. </param>
        /// <param name="maskingFunction"> The masking function that is used for the data masking rule. </param>
        /// <param name="numberFrom"> The numberFrom property of the masking rule. Required if maskingFunction is set to Number, otherwise this parameter will be ignored. </param>
        /// <param name="numberTo"> The numberTo property of the data masking rule. Required if maskingFunction is set to Number, otherwise this parameter will be ignored. </param>
        /// <param name="prefixSize"> If maskingFunction is set to Text, the number of characters to show unmasked in the beginning of the string. Otherwise, this parameter will be ignored. </param>
        /// <param name="suffixSize"> If maskingFunction is set to Text, the number of characters to show unmasked at the end of the string. Otherwise, this parameter will be ignored. </param>
        /// <param name="replacementString"> If maskingFunction is set to Text, the character to use for masking the unexposed part of the string. Otherwise, this parameter will be ignored. </param>
        /// <returns> A new <see cref="Synapse.SynapseDataMaskingRuleData"/> instance for mocking. </returns>
        public static SynapseDataMaskingRuleData SynapseDataMaskingRuleData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AzureLocation? location = null, string kind = null, string ruleId = null, string aliasName = null, SynapseDataMaskingRuleState? ruleState = null, string schemaName = null, string tableName = null, string columnName = null, SynapseDataMaskingFunction? maskingFunction = null, string numberFrom = null, string numberTo = null, string prefixSize = null, string suffixSize = null, string replacementString = null)
        {
            return new SynapseDataMaskingRuleData(
                id,
                name,
                resourceType,
                systemData,
                location,
                kind,
                ruleId,
                aliasName,
                ruleState,
                schemaName,
                tableName,
                columnName,
                maskingFunction,
                numberFrom,
                numberTo,
                prefixSize,
                suffixSize,
                replacementString,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Synapse.SynapseWorkloadGroupData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="minResourcePercent"> The workload group minimum percentage resource. </param>
        /// <param name="maxResourcePercent"> The workload group cap percentage resource. </param>
        /// <param name="minResourcePercentPerRequest"> The workload group request minimum grant percentage. </param>
        /// <param name="maxResourcePercentPerRequest"> The workload group request maximum grant percentage. </param>
        /// <param name="importance"> The workload group importance level. </param>
        /// <param name="queryExecutionTimeout"> The workload group query execution timeout. </param>
        /// <returns> A new <see cref="Synapse.SynapseWorkloadGroupData"/> instance for mocking. </returns>
        public static SynapseWorkloadGroupData SynapseWorkloadGroupData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, int? minResourcePercent = null, int? maxResourcePercent = null, double? minResourcePercentPerRequest = null, double? maxResourcePercentPerRequest = null, string importance = null, int? queryExecutionTimeout = null)
        {
            return new SynapseWorkloadGroupData(
                id,
                name,
                resourceType,
                systemData,
                minResourcePercent,
                maxResourcePercent,
                minResourcePercentPerRequest,
                maxResourcePercentPerRequest,
                importance,
                queryExecutionTimeout,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Synapse.SynapseWorkloadClassifierData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="memberName"> The workload classifier member name. </param>
        /// <param name="label"> The workload classifier label. </param>
        /// <param name="context"> The workload classifier context. </param>
        /// <param name="startTime"> The workload classifier start time for classification. </param>
        /// <param name="endTime"> The workload classifier end time for classification. </param>
        /// <param name="importance"> The workload classifier importance. </param>
        /// <returns> A new <see cref="Synapse.SynapseWorkloadClassifierData"/> instance for mocking. </returns>
        public static SynapseWorkloadClassifierData SynapseWorkloadClassifierData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string memberName = null, string label = null, string context = null, string startTime = null, string endTime = null, string importance = null)
        {
            return new SynapseWorkloadClassifierData(
                id,
                name,
                resourceType,
                systemData,
                memberName,
                label,
                context,
                startTime,
                endTime,
                importance,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Synapse.SynapseServerBlobAuditingPolicyData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="state"> Specifies the state of the policy. If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required. </param>
        /// <param name="storageEndpoint"> Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled is required. </param>
        /// <param name="storageAccountAccessKey">
        /// Specifies the identifier key of the auditing storage account.
        /// If state is Enabled and storageEndpoint is specified, not specifying the storageAccountAccessKey will use SQL server system-assigned managed identity to access the storage.
        /// Prerequisites for using managed identity authentication:
        /// 1. Assign SQL Server a system-assigned managed identity in Azure Active Directory (AAD).
        /// 2. Grant SQL Server identity access to the storage account by adding 'Storage Blob Data Contributor' RBAC role to the server identity.
        /// For more information, see [Auditing to storage using Managed Identity authentication](https://go.microsoft.com/fwlink/?linkid=2114355)
        /// </param>
        /// <param name="retentionDays"> Specifies the number of days to keep in the audit logs in the storage account. </param>
        /// <param name="auditActionsAndGroups">
        /// Specifies the Actions-Groups and Actions to audit.
        ///
        /// The recommended set of action groups to use is the following combination - this will audit all the queries and stored procedures executed against the database, as well as successful and failed logins:
        ///
        /// BATCH_COMPLETED_GROUP,
        /// SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP,
        /// FAILED_DATABASE_AUTHENTICATION_GROUP.
        ///
        /// This above combination is also the set that is configured by default when enabling auditing from the Azure portal.
        ///
        /// The supported action groups to audit are (note: choose only specific groups that cover your auditing needs. Using unnecessary groups could lead to very large quantities of audit records):
        ///
        /// APPLICATION_ROLE_CHANGE_PASSWORD_GROUP
        /// BACKUP_RESTORE_GROUP
        /// DATABASE_LOGOUT_GROUP
        /// DATABASE_OBJECT_CHANGE_GROUP
        /// DATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP
        /// DATABASE_OBJECT_PERMISSION_CHANGE_GROUP
        /// DATABASE_OPERATION_GROUP
        /// DATABASE_PERMISSION_CHANGE_GROUP
        /// DATABASE_PRINCIPAL_CHANGE_GROUP
        /// DATABASE_PRINCIPAL_IMPERSONATION_GROUP
        /// DATABASE_ROLE_MEMBER_CHANGE_GROUP
        /// FAILED_DATABASE_AUTHENTICATION_GROUP
        /// SCHEMA_OBJECT_ACCESS_GROUP
        /// SCHEMA_OBJECT_CHANGE_GROUP
        /// SCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP
        /// SCHEMA_OBJECT_PERMISSION_CHANGE_GROUP
        /// SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP
        /// USER_CHANGE_PASSWORD_GROUP
        /// BATCH_STARTED_GROUP
        /// BATCH_COMPLETED_GROUP
        ///
        /// These are groups that cover all sql statements and stored procedures executed against the database, and should not be used in combination with other groups as this will result in duplicate audit logs.
        ///
        /// For more information, see [Database-Level Audit Action Groups](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups).
        ///
        /// For Database auditing policy, specific Actions can also be specified (note that Actions cannot be specified for Server auditing policy). The supported actions to audit are:
        /// SELECT
        /// UPDATE
        /// INSERT
        /// DELETE
        /// EXECUTE
        /// RECEIVE
        /// REFERENCES
        ///
        /// The general form for defining an action to be audited is:
        /// {action} ON {object} BY {principal}
        ///
        /// Note that &lt;object&gt; in the above format can refer to an object like a table, view, or stored procedure, or an entire database or schema. For the latter cases, the forms DATABASE::{db_name} and SCHEMA::{schema_name} are used, respectively.
        ///
        /// For example:
        /// SELECT on dbo.myTable by public
        /// SELECT on DATABASE::myDatabase by public
        /// SELECT on SCHEMA::mySchema by public
        ///
        /// For more information, see [Database-Level Audit Actions](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions)
        /// </param>
        /// <param name="storageAccountSubscriptionId"> Specifies the blob storage subscription Id. </param>
        /// <param name="isStorageSecondaryKeyInUse"> Specifies whether storageAccountAccessKey value is the storage's secondary key. </param>
        /// <param name="isAzureMonitorTargetEnabled">
        /// Specifies whether audit events are sent to Azure Monitor.
        /// In order to send the events to Azure Monitor, specify 'state' as 'Enabled' and 'isAzureMonitorTargetEnabled' as true.
        ///
        /// When using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents' diagnostic logs category on the database should be also created.
        /// Note that for server level audit you should use the 'master' database as {databaseName}.
        ///
        /// Diagnostic Settings URI format:
        /// PUT https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
        ///
        /// For more information, see [Diagnostic Settings REST API](https://go.microsoft.com/fwlink/?linkid=2033207)
        /// or [Diagnostic Settings PowerShell](https://go.microsoft.com/fwlink/?linkid=2033043)
        ///
        /// </param>
        /// <param name="queueDelayMs">
        /// Specifies the amount of time in milliseconds that can elapse before audit actions are forced to be processed.
        /// The default minimum value is 1000 (1 second). The maximum is 2,147,483,647.
        /// </param>
        /// <param name="isDevopsAuditEnabled">
        /// Specifies the state of devops audit. If state is Enabled, devops logs will be sent to Azure Monitor.
        /// In order to send the events to Azure Monitor, specify 'State' as 'Enabled', 'IsAzureMonitorTargetEnabled' as true and 'IsDevopsAuditEnabled' as true
        ///
        /// When using REST API to configure auditing, Diagnostic Settings with 'DevOpsOperationsAudit' diagnostic logs category on the master database should also be created.
        ///
        /// Diagnostic Settings URI format:
        /// PUT https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/master/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
        ///
        /// For more information, see [Diagnostic Settings REST API](https://go.microsoft.com/fwlink/?linkid=2033207)
        /// or [Diagnostic Settings PowerShell](https://go.microsoft.com/fwlink/?linkid=2033043)
        ///
        /// </param>
        /// <returns> A new <see cref="Synapse.SynapseServerBlobAuditingPolicyData"/> instance for mocking. </returns>
        public static SynapseServerBlobAuditingPolicyData SynapseServerBlobAuditingPolicyData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, SynapseBlobAuditingPolicyState? state = null, string storageEndpoint = null, string storageAccountAccessKey = null, int? retentionDays = null, IEnumerable<string> auditActionsAndGroups = null, Guid? storageAccountSubscriptionId = null, bool? isStorageSecondaryKeyInUse = null, bool? isAzureMonitorTargetEnabled = null, int? queueDelayMs = null, bool? isDevopsAuditEnabled = null)
        {
            auditActionsAndGroups ??= new List<string>();

            return new SynapseServerBlobAuditingPolicyData(
                id,
                name,
                resourceType,
                systemData,
                state,
                storageEndpoint,
                storageAccountAccessKey,
                retentionDays,
                auditActionsAndGroups?.ToList(),
                storageAccountSubscriptionId,
                isStorageSecondaryKeyInUse,
                isAzureMonitorTargetEnabled,
                queueDelayMs,
                isDevopsAuditEnabled,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Synapse.SynapseExtendedServerBlobAuditingPolicyData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="predicateExpression"> Specifies condition of where clause when creating an audit. </param>
        /// <param name="state"> Specifies the state of the policy. If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required. </param>
        /// <param name="storageEndpoint"> Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled is required. </param>
        /// <param name="storageAccountAccessKey">
        /// Specifies the identifier key of the auditing storage account.
        /// If state is Enabled and storageEndpoint is specified, not specifying the storageAccountAccessKey will use SQL server system-assigned managed identity to access the storage.
        /// Prerequisites for using managed identity authentication:
        /// 1. Assign SQL Server a system-assigned managed identity in Azure Active Directory (AAD).
        /// 2. Grant SQL Server identity access to the storage account by adding 'Storage Blob Data Contributor' RBAC role to the server identity.
        /// For more information, see [Auditing to storage using Managed Identity authentication](https://go.microsoft.com/fwlink/?linkid=2114355)
        /// </param>
        /// <param name="retentionDays"> Specifies the number of days to keep in the audit logs in the storage account. </param>
        /// <param name="auditActionsAndGroups">
        /// Specifies the Actions-Groups and Actions to audit.
        ///
        /// The recommended set of action groups to use is the following combination - this will audit all the queries and stored procedures executed against the database, as well as successful and failed logins:
        ///
        /// BATCH_COMPLETED_GROUP,
        /// SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP,
        /// FAILED_DATABASE_AUTHENTICATION_GROUP.
        ///
        /// This above combination is also the set that is configured by default when enabling auditing from the Azure portal.
        ///
        /// The supported action groups to audit are (note: choose only specific groups that cover your auditing needs. Using unnecessary groups could lead to very large quantities of audit records):
        ///
        /// APPLICATION_ROLE_CHANGE_PASSWORD_GROUP
        /// BACKUP_RESTORE_GROUP
        /// DATABASE_LOGOUT_GROUP
        /// DATABASE_OBJECT_CHANGE_GROUP
        /// DATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP
        /// DATABASE_OBJECT_PERMISSION_CHANGE_GROUP
        /// DATABASE_OPERATION_GROUP
        /// DATABASE_PERMISSION_CHANGE_GROUP
        /// DATABASE_PRINCIPAL_CHANGE_GROUP
        /// DATABASE_PRINCIPAL_IMPERSONATION_GROUP
        /// DATABASE_ROLE_MEMBER_CHANGE_GROUP
        /// FAILED_DATABASE_AUTHENTICATION_GROUP
        /// SCHEMA_OBJECT_ACCESS_GROUP
        /// SCHEMA_OBJECT_CHANGE_GROUP
        /// SCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP
        /// SCHEMA_OBJECT_PERMISSION_CHANGE_GROUP
        /// SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP
        /// USER_CHANGE_PASSWORD_GROUP
        /// BATCH_STARTED_GROUP
        /// BATCH_COMPLETED_GROUP
        ///
        /// These are groups that cover all sql statements and stored procedures executed against the database, and should not be used in combination with other groups as this will result in duplicate audit logs.
        ///
        /// For more information, see [Database-Level Audit Action Groups](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups).
        ///
        /// For Database auditing policy, specific Actions can also be specified (note that Actions cannot be specified for Server auditing policy). The supported actions to audit are:
        /// SELECT
        /// UPDATE
        /// INSERT
        /// DELETE
        /// EXECUTE
        /// RECEIVE
        /// REFERENCES
        ///
        /// The general form for defining an action to be audited is:
        /// {action} ON {object} BY {principal}
        ///
        /// Note that &lt;object&gt; in the above format can refer to an object like a table, view, or stored procedure, or an entire database or schema. For the latter cases, the forms DATABASE::{db_name} and SCHEMA::{schema_name} are used, respectively.
        ///
        /// For example:
        /// SELECT on dbo.myTable by public
        /// SELECT on DATABASE::myDatabase by public
        /// SELECT on SCHEMA::mySchema by public
        ///
        /// For more information, see [Database-Level Audit Actions](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions)
        /// </param>
        /// <param name="storageAccountSubscriptionId"> Specifies the blob storage subscription Id. </param>
        /// <param name="isStorageSecondaryKeyInUse"> Specifies whether storageAccountAccessKey value is the storage's secondary key. </param>
        /// <param name="isAzureMonitorTargetEnabled">
        /// Specifies whether audit events are sent to Azure Monitor.
        /// In order to send the events to Azure Monitor, specify 'state' as 'Enabled' and 'isAzureMonitorTargetEnabled' as true.
        ///
        /// When using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents' diagnostic logs category on the database should be also created.
        /// Note that for server level audit you should use the 'master' database as {databaseName}.
        ///
        /// Diagnostic Settings URI format:
        /// PUT https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
        ///
        /// For more information, see [Diagnostic Settings REST API](https://go.microsoft.com/fwlink/?linkid=2033207)
        /// or [Diagnostic Settings PowerShell](https://go.microsoft.com/fwlink/?linkid=2033043)
        ///
        /// </param>
        /// <param name="queueDelayMs">
        /// Specifies the amount of time in milliseconds that can elapse before audit actions are forced to be processed.
        /// The default minimum value is 1000 (1 second). The maximum is 2,147,483,647.
        /// </param>
        /// <param name="isDevopsAuditEnabled">
        /// Specifies the state of devops audit. If state is Enabled, devops logs will be sent to Azure Monitor.
        /// In order to send the events to Azure Monitor, specify 'State' as 'Enabled', 'IsAzureMonitorTargetEnabled' as true and 'IsDevopsAuditEnabled' as true
        ///
        /// When using REST API to configure auditing, Diagnostic Settings with 'DevOpsOperationsAudit' diagnostic logs category on the master database should also be created.
        ///
        /// Diagnostic Settings URI format:
        /// PUT https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/master/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
        ///
        /// For more information, see [Diagnostic Settings REST API](https://go.microsoft.com/fwlink/?linkid=2033207)
        /// or [Diagnostic Settings PowerShell](https://go.microsoft.com/fwlink/?linkid=2033043)
        ///
        /// </param>
        /// <returns> A new <see cref="Synapse.SynapseExtendedServerBlobAuditingPolicyData"/> instance for mocking. </returns>
        public static SynapseExtendedServerBlobAuditingPolicyData SynapseExtendedServerBlobAuditingPolicyData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string predicateExpression = null, SynapseBlobAuditingPolicyState? state = null, string storageEndpoint = null, string storageAccountAccessKey = null, int? retentionDays = null, IEnumerable<string> auditActionsAndGroups = null, Guid? storageAccountSubscriptionId = null, bool? isStorageSecondaryKeyInUse = null, bool? isAzureMonitorTargetEnabled = null, int? queueDelayMs = null, bool? isDevopsAuditEnabled = null)
        {
            auditActionsAndGroups ??= new List<string>();

            return new SynapseExtendedServerBlobAuditingPolicyData(
                id,
                name,
                resourceType,
                systemData,
                predicateExpression,
                state,
                storageEndpoint,
                storageAccountAccessKey,
                retentionDays,
                auditActionsAndGroups?.ToList(),
                storageAccountSubscriptionId,
                isStorageSecondaryKeyInUse,
                isAzureMonitorTargetEnabled,
                queueDelayMs,
                isDevopsAuditEnabled,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Synapse.SynapseServerSecurityAlertPolicyData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="state"> Specifies the state of the policy, whether it is enabled or disabled or a policy has not been applied yet on the specific server. </param>
        /// <param name="disabledAlerts"> Specifies an array of alerts that are disabled. Allowed values are: Sql_Injection, Sql_Injection_Vulnerability, Access_Anomaly, Data_Exfiltration, Unsafe_Action. </param>
        /// <param name="emailAddresses"> Specifies an array of e-mail addresses to which the alert is sent. </param>
        /// <param name="enableEmailToAccountAdmins"> Specifies that the alert is sent to the account administrators. </param>
        /// <param name="storageEndpoint"> Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). This blob storage will hold all Threat Detection audit logs. </param>
        /// <param name="storageAccountAccessKey"> Specifies the identifier key of the Threat Detection audit storage account. </param>
        /// <param name="retentionDays"> Specifies the number of days to keep in the Threat Detection audit logs. </param>
        /// <param name="createdOn"> Specifies the UTC creation time of the policy. </param>
        /// <returns> A new <see cref="Synapse.SynapseServerSecurityAlertPolicyData"/> instance for mocking. </returns>
        public static SynapseServerSecurityAlertPolicyData SynapseServerSecurityAlertPolicyData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, SynapseSecurityAlertPolicyState? state = null, IEnumerable<string> disabledAlerts = null, IEnumerable<string> emailAddresses = null, bool? enableEmailToAccountAdmins = null, string storageEndpoint = null, string storageAccountAccessKey = null, int? retentionDays = null, DateTimeOffset? createdOn = null)
        {
            disabledAlerts ??= new List<string>();
            emailAddresses ??= new List<string>();

            return new SynapseServerSecurityAlertPolicyData(
                id,
                name,
                resourceType,
                systemData,
                state,
                disabledAlerts?.ToList(),
                emailAddresses?.ToList(),
                enableEmailToAccountAdmins,
                storageEndpoint,
                storageAccountAccessKey,
                retentionDays,
                createdOn,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Synapse.SynapseServerVulnerabilityAssessmentData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="storageContainerPath"> A blob storage container path to hold the scan results (e.g. https://myStorage.blob.core.windows.net/VaScans/). </param>
        /// <param name="storageContainerSasKey"> A shared access signature (SAS Key) that has read and write access to the blob container specified in 'storageContainerPath' parameter. If 'storageAccountAccessKey' isn't specified, StorageContainerSasKey is required. </param>
        /// <param name="storageAccountAccessKey"> Specifies the identifier key of the storage account for vulnerability assessment scan results. If 'StorageContainerSasKey' isn't specified, storageAccountAccessKey is required. </param>
        /// <param name="recurringScans"> The recurring scans settings. </param>
        /// <returns> A new <see cref="Synapse.SynapseServerVulnerabilityAssessmentData"/> instance for mocking. </returns>
        public static SynapseServerVulnerabilityAssessmentData SynapseServerVulnerabilityAssessmentData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string storageContainerPath = null, string storageContainerSasKey = null, string storageAccountAccessKey = null, SynapseVulnerabilityAssessmentRecurringScansProperties recurringScans = null)
        {
            return new SynapseServerVulnerabilityAssessmentData(
                id,
                name,
                resourceType,
                systemData,
                storageContainerPath,
                storageContainerSasKey,
                storageAccountAccessKey,
                recurringScans,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Synapse.SynapseEncryptionProtectorData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="kind"> Kind of encryption protector. This is metadata used for the Azure portal experience. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="subregion"> Subregion of the encryption protector. </param>
        /// <param name="serverKeyName"> The name of the server key. </param>
        /// <param name="serverKeyType"> The encryption protector type like 'ServiceManaged', 'AzureKeyVault'. </param>
        /// <param name="uri"> The URI of the server key. </param>
        /// <param name="thumbprint"> Thumbprint of the server key. </param>
        /// <returns> A new <see cref="Synapse.SynapseEncryptionProtectorData"/> instance for mocking. </returns>
        public static SynapseEncryptionProtectorData SynapseEncryptionProtectorData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string kind = null, AzureLocation? location = null, string subregion = null, string serverKeyName = null, SynapseServerKeyType? serverKeyType = null, Uri uri = null, BinaryData thumbprint = null)
        {
            return new SynapseEncryptionProtectorData(
                id,
                name,
                resourceType,
                systemData,
                kind,
                location,
                subregion,
                serverKeyName,
                serverKeyType,
                uri,
                thumbprint,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SynapseServerUsage"/>. </summary>
        /// <param name="name"> Name of the server usage metric. </param>
        /// <param name="resourceName"> The name of the resource. </param>
        /// <param name="displayName"> The metric display name. </param>
        /// <param name="currentValue"> The current value of the metric. </param>
        /// <param name="limit"> The current limit of the metric. </param>
        /// <param name="unit"> The units of the metric. </param>
        /// <param name="nextResetOn"> The next reset time for the metric (ISO8601 format). </param>
        /// <returns> A new <see cref="Models.SynapseServerUsage"/> instance for mocking. </returns>
        public static SynapseServerUsage SynapseServerUsage(string name = null, string resourceName = null, string displayName = null, double? currentValue = null, double? limit = null, string unit = null, DateTimeOffset? nextResetOn = null)
        {
            return new SynapseServerUsage(
                name,
                resourceName,
                displayName,
                currentValue,
                limit,
                unit,
                nextResetOn,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Synapse.SynapseRecoverableSqlPoolData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="edition"> The edition of the database. </param>
        /// <param name="serviceLevelObjective"> The service level objective name of the database. </param>
        /// <param name="elasticPoolName"> The elastic pool name of the database. </param>
        /// <param name="lastAvailableBackupOn"> The last available backup date of the database (ISO8601 format). </param>
        /// <returns> A new <see cref="Synapse.SynapseRecoverableSqlPoolData"/> instance for mocking. </returns>
        public static SynapseRecoverableSqlPoolData SynapseRecoverableSqlPoolData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string edition = null, string serviceLevelObjective = null, string elasticPoolName = null, DateTimeOffset? lastAvailableBackupOn = null)
        {
            return new SynapseRecoverableSqlPoolData(
                id,
                name,
                resourceType,
                systemData,
                edition,
                serviceLevelObjective,
                elasticPoolName,
                lastAvailableBackupOn,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Synapse.SynapseDedicatedSqlMinimalTlsSettingData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="minimalTlsVersion"> The minimal tls version of the sql server. </param>
        /// <returns> A new <see cref="Synapse.SynapseDedicatedSqlMinimalTlsSettingData"/> instance for mocking. </returns>
        public static SynapseDedicatedSqlMinimalTlsSettingData SynapseDedicatedSqlMinimalTlsSettingData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AzureLocation? location = null, string minimalTlsVersion = null)
        {
            return new SynapseDedicatedSqlMinimalTlsSettingData(
                id,
                name,
                resourceType,
                systemData,
                location,
                minimalTlsVersion,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Synapse.SynapseWorkspaceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="identity"> Identity of the workspace. Current supported identity types: None, SystemAssigned, SystemAssigned,UserAssigned. </param>
        /// <param name="defaultDataLakeStorage"> Workspace default data lake storage account details. </param>
        /// <param name="sqlAdministratorLoginPassword"> SQL administrator login password. </param>
        /// <param name="managedResourceGroupName"> Workspace managed resource group. The resource group name uniquely identifies the resource group within the user subscriptionId. The resource group name must be no longer than 90 characters long, and must be alphanumeric characters (Char.IsLetterOrDigit()) and '-', '_', '(', ')' and'.'. Note that the name cannot end with '.'. </param>
        /// <param name="provisioningState"> Resource provisioning state. </param>
        /// <param name="sqlAdministratorLogin"> Login for workspace SQL active directory administrator. </param>
        /// <param name="virtualNetworkComputeSubnetId"> Virtual Network profile. </param>
        /// <param name="connectivityEndpoints"> Connectivity endpoints. </param>
        /// <param name="managedVirtualNetwork"> Setting this to 'default' will ensure that all compute for this workspace is in a virtual network managed on behalf of the user. </param>
        /// <param name="privateEndpointConnections"> Private endpoint connections to the workspace. </param>
        /// <param name="encryption"> The encryption details of the workspace. </param>
        /// <param name="workspaceUid"> The workspace unique identifier. </param>
        /// <param name="extraProperties"> Workspace level configs and feature flags. </param>
        /// <param name="managedVirtualNetworkSettings"> Managed Virtual Network Settings. </param>
        /// <param name="workspaceRepositoryConfiguration"> Git integration settings. </param>
        /// <param name="purviewResourceId"> Purview Configuration. </param>
        /// <param name="adlaResourceId"> The ADLA resource ID. </param>
        /// <param name="publicNetworkAccess"> Enable or Disable public network access to workspace. </param>
        /// <param name="initialWorkspaceAdminObjectId"> Initial workspace AAD admin properties for a CSP subscription. </param>
        /// <param name="settings"> Workspace settings. </param>
        /// <param name="isAadOnlyAuthenticationEnabled"> Enable or Disable AzureADOnlyAuthentication on All Workspace subresource. </param>
        /// <param name="isTrustedServiceBypassEnabled"> Is trustedServiceBypassEnabled for the workspace. </param>
        /// <returns> A new <see cref="Synapse.SynapseWorkspaceData"/> instance for mocking. </returns>
        public static SynapseWorkspaceData SynapseWorkspaceData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ManagedServiceIdentity identity = null, SynapseDataLakeStorageAccountDetails defaultDataLakeStorage = null, string sqlAdministratorLoginPassword = null, string managedResourceGroupName = null, string provisioningState = null, string sqlAdministratorLogin = null, string virtualNetworkComputeSubnetId = null, IDictionary<string, string> connectivityEndpoints = null, string managedVirtualNetwork = null, IEnumerable<SynapsePrivateEndpointConnectionData> privateEndpointConnections = null, SynapseEncryptionDetails encryption = null, Guid? workspaceUid = null, IReadOnlyDictionary<string, BinaryData> extraProperties = null, SynapseManagedVirtualNetworkSettings managedVirtualNetworkSettings = null, SynapseWorkspaceRepositoryConfiguration workspaceRepositoryConfiguration = null, ResourceIdentifier purviewResourceId = null, ResourceIdentifier adlaResourceId = null, WorkspacePublicNetworkAccess? publicNetworkAccess = null, Guid? initialWorkspaceAdminObjectId = null, IReadOnlyDictionary<string, BinaryData> settings = null, bool? isAadOnlyAuthenticationEnabled = null, bool? isTrustedServiceBypassEnabled = null)
        {
            tags ??= new Dictionary<string, string>();
            connectivityEndpoints ??= new Dictionary<string, string>();
            privateEndpointConnections ??= new List<SynapsePrivateEndpointConnectionData>();
            extraProperties ??= new Dictionary<string, BinaryData>();
            settings ??= new Dictionary<string, BinaryData>();

            return new SynapseWorkspaceData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                identity,
                defaultDataLakeStorage,
                sqlAdministratorLoginPassword,
                managedResourceGroupName,
                provisioningState,
                sqlAdministratorLogin,
                virtualNetworkComputeSubnetId != null ? new VirtualNetworkProfile(virtualNetworkComputeSubnetId, serializedAdditionalRawData: null) : null,
                connectivityEndpoints,
                managedVirtualNetwork,
                privateEndpointConnections?.ToList(),
                encryption,
                workspaceUid,
                extraProperties,
                managedVirtualNetworkSettings,
                workspaceRepositoryConfiguration,
                purviewResourceId != null ? new PurviewConfiguration(purviewResourceId, serializedAdditionalRawData: null) : null,
                adlaResourceId,
                publicNetworkAccess,
                initialWorkspaceAdminObjectId != null ? new CspWorkspaceAdminProperties(initialWorkspaceAdminObjectId, serializedAdditionalRawData: null) : null,
                settings,
                isAadOnlyAuthenticationEnabled,
                isTrustedServiceBypassEnabled,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SynapseEncryptionDetails"/>. </summary>
        /// <param name="isDoubleEncryptionEnabled"> Double Encryption enabled. </param>
        /// <param name="cmk"> Customer Managed Key Details. </param>
        /// <returns> A new <see cref="Models.SynapseEncryptionDetails"/> instance for mocking. </returns>
        public static SynapseEncryptionDetails SynapseEncryptionDetails(bool? isDoubleEncryptionEnabled = null, WorkspaceCustomerManagedKeyDetails cmk = null)
        {
            return new SynapseEncryptionDetails(isDoubleEncryptionEnabled, cmk, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.WorkspaceCustomerManagedKeyDetails"/>. </summary>
        /// <param name="status"> The customer managed key status on the workspace. </param>
        /// <param name="key"> The key object of the workspace. </param>
        /// <param name="kekIdentity"> Key encryption key. </param>
        /// <returns> A new <see cref="Models.WorkspaceCustomerManagedKeyDetails"/> instance for mocking. </returns>
        public static WorkspaceCustomerManagedKeyDetails WorkspaceCustomerManagedKeyDetails(string status = null, SynapseWorkspaceKeyDetails key = null, KekIdentityProperties kekIdentity = null)
        {
            return new WorkspaceCustomerManagedKeyDetails(status, key, kekIdentity, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SynapseWorkspacePatch"/>. </summary>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="identity"> The identity of the workspace. Current supported identity types: None, SystemAssigned, SystemAssigned,UserAssigned. </param>
        /// <param name="sqlAdministratorLoginPassword"> SQL administrator login password. </param>
        /// <param name="managedVirtualNetworkSettings"> Managed Virtual Network Settings. </param>
        /// <param name="workspaceRepositoryConfiguration"> Git integration settings. </param>
        /// <param name="purviewResourceId"> Purview Configuration. </param>
        /// <param name="provisioningState"> Resource provisioning state. </param>
        /// <param name="encryption"> The encryption details of the workspace. </param>
        /// <param name="publicNetworkAccess"> Enable or Disable public network access to workspace. </param>
        /// <returns> A new <see cref="Models.SynapseWorkspacePatch"/> instance for mocking. </returns>
        public static SynapseWorkspacePatch SynapseWorkspacePatch(IDictionary<string, string> tags = null, ManagedServiceIdentity identity = null, string sqlAdministratorLoginPassword = null, SynapseManagedVirtualNetworkSettings managedVirtualNetworkSettings = null, SynapseWorkspaceRepositoryConfiguration workspaceRepositoryConfiguration = null, ResourceIdentifier purviewResourceId = null, string provisioningState = null, SynapseEncryptionDetails encryption = null, WorkspacePublicNetworkAccess? publicNetworkAccess = null)
        {
            tags ??= new Dictionary<string, string>();

            return new SynapseWorkspacePatch(
                tags,
                identity,
                sqlAdministratorLoginPassword,
                managedVirtualNetworkSettings,
                workspaceRepositoryConfiguration,
                purviewResourceId != null ? new PurviewConfiguration(purviewResourceId, serializedAdditionalRawData: null) : null,
                provisioningState,
                encryption,
                publicNetworkAccess,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Synapse.SynapseWorkspaceAadAdminInfoData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tenantId"> Tenant ID of the workspace active directory administrator. </param>
        /// <param name="login"> Login of the workspace active directory administrator. </param>
        /// <param name="administratorType"> Workspace active directory administrator type. </param>
        /// <param name="sid"> Object ID of the workspace active directory administrator. </param>
        /// <returns> A new <see cref="Synapse.SynapseWorkspaceAadAdminInfoData"/> instance for mocking. </returns>
        public static SynapseWorkspaceAadAdminInfoData SynapseWorkspaceAadAdminInfoData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, Guid? tenantId = null, string login = null, string administratorType = null, string sid = null)
        {
            return new SynapseWorkspaceAadAdminInfoData(
                id,
                name,
                resourceType,
                systemData,
                tenantId,
                login,
                administratorType,
                sid,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Synapse.SynapseManagedIdentitySqlControlSettingData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="grantSqlControlToManagedIdentity"> Grant sql control to managed identity. </param>
        /// <returns> A new <see cref="Synapse.SynapseManagedIdentitySqlControlSettingData"/> instance for mocking. </returns>
        public static SynapseManagedIdentitySqlControlSettingData SynapseManagedIdentitySqlControlSettingData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, SynapseGrantSqlControlToManagedIdentity grantSqlControlToManagedIdentity = null)
        {
            return new SynapseManagedIdentitySqlControlSettingData(
                id,
                name,
                resourceType,
                systemData,
                grantSqlControlToManagedIdentity,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SynapseGrantSqlControlToManagedIdentity"/>. </summary>
        /// <param name="desiredState"> Desired state. </param>
        /// <param name="actualState"> Actual state. </param>
        /// <returns> A new <see cref="Models.SynapseGrantSqlControlToManagedIdentity"/> instance for mocking. </returns>
        public static SynapseGrantSqlControlToManagedIdentity SynapseGrantSqlControlToManagedIdentity(SynapseDesiredState? desiredState = null, SynapseGrantSqlControlToManagedIdentityState? actualState = null)
        {
            return new SynapseGrantSqlControlToManagedIdentity(desiredState, actualState, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Synapse.SynapseRestorableDroppedSqlPoolData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="location"> The geo-location where the resource lives. </param>
        /// <param name="databaseName"> The name of the database. </param>
        /// <param name="edition"> The edition of the database. </param>
        /// <param name="maxSizeBytes"> The max size in bytes of the database. </param>
        /// <param name="serviceLevelObjective"> The service level objective name of the database. </param>
        /// <param name="elasticPoolName"> The elastic pool name of the database. </param>
        /// <param name="createdOn"> The creation date of the database (ISO8601 format). </param>
        /// <param name="deletedOn"> The deletion date of the database (ISO8601 format). </param>
        /// <param name="earliestRestoreOn"> The earliest restore date of the database (ISO8601 format). </param>
        /// <returns> A new <see cref="Synapse.SynapseRestorableDroppedSqlPoolData"/> instance for mocking. </returns>
        public static SynapseRestorableDroppedSqlPoolData SynapseRestorableDroppedSqlPoolData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AzureLocation? location = null, string databaseName = null, string edition = null, string maxSizeBytes = null, string serviceLevelObjective = null, string elasticPoolName = null, DateTimeOffset? createdOn = null, DateTimeOffset? deletedOn = null, DateTimeOffset? earliestRestoreOn = null)
        {
            return new SynapseRestorableDroppedSqlPoolData(
                id,
                name,
                resourceType,
                systemData,
                location,
                databaseName,
                edition,
                maxSizeBytes,
                serviceLevelObjective,
                elasticPoolName,
                createdOn,
                deletedOn,
                earliestRestoreOn,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Synapse.SynapseBigDataPoolInfoData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="provisioningState"> The state of the Big Data pool. </param>
        /// <param name="autoScale"> Auto-scaling properties. </param>
        /// <param name="createdOn"> The time when the Big Data pool was created. </param>
        /// <param name="autoPause"> Auto-pausing properties. </param>
        /// <param name="isComputeIsolationEnabled"> Whether compute isolation is required or not. </param>
        /// <param name="isAutotuneEnabled"> Whether autotune is required or not. </param>
        /// <param name="isSessionLevelPackagesEnabled"> Whether session level packages enabled. </param>
        /// <param name="cacheSize"> The cache size. </param>
        /// <param name="dynamicExecutorAllocation"> Dynamic Executor Allocation. </param>
        /// <param name="sparkEventsFolder"> The Spark events folder. </param>
        /// <param name="nodeCount"> The number of nodes in the Big Data pool. </param>
        /// <param name="libraryRequirements"> Library version requirements. </param>
        /// <param name="customLibraries"> List of custom libraries/packages associated with the spark pool. </param>
        /// <param name="sparkConfigProperties"> Spark configuration file to specify additional properties. </param>
        /// <param name="sparkVersion"> The Apache Spark version. </param>
        /// <param name="defaultSparkLogFolder"> The default folder where Spark logs will be written. </param>
        /// <param name="nodeSize"> The level of compute power that each node in the Big Data pool has. </param>
        /// <param name="nodeSizeFamily"> The kind of nodes that the Big Data pool provides. </param>
        /// <param name="lastSucceededOn"> The time when the Big Data pool was updated successfully. </param>
        /// <returns> A new <see cref="Synapse.SynapseBigDataPoolInfoData"/> instance for mocking. </returns>
        public static SynapseBigDataPoolInfoData SynapseBigDataPoolInfoData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, string provisioningState = null, BigDataPoolAutoScaleProperties autoScale = null, DateTimeOffset? createdOn = null, BigDataPoolAutoPauseProperties autoPause = null, bool? isComputeIsolationEnabled = null, bool? isAutotuneEnabled = null, bool? isSessionLevelPackagesEnabled = null, int? cacheSize = null, SynapseDynamicExecutorAllocation dynamicExecutorAllocation = null, string sparkEventsFolder = null, int? nodeCount = null, BigDataPoolLibraryRequirements libraryRequirements = null, IEnumerable<BigDataPoolLibraryInfo> customLibraries = null, BigDataPoolSparkConfigProperties sparkConfigProperties = null, string sparkVersion = null, string defaultSparkLogFolder = null, BigDataPoolNodeSize? nodeSize = null, BigDataPoolNodeSizeFamily? nodeSizeFamily = null, DateTimeOffset? lastSucceededOn = null)
        {
            tags ??= new Dictionary<string, string>();
            customLibraries ??= new List<BigDataPoolLibraryInfo>();

            return new SynapseBigDataPoolInfoData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                provisioningState,
                autoScale,
                createdOn,
                autoPause,
                isComputeIsolationEnabled,
                isAutotuneEnabled,
                isSessionLevelPackagesEnabled,
                cacheSize,
                dynamicExecutorAllocation,
                sparkEventsFolder,
                nodeCount,
                libraryRequirements,
                customLibraries?.ToList(),
                sparkConfigProperties,
                sparkVersion,
                defaultSparkLogFolder,
                nodeSize,
                nodeSizeFamily,
                lastSucceededOn,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.BigDataPoolLibraryRequirements"/>. </summary>
        /// <param name="updatedOn"> The last update time of the library requirements file. </param>
        /// <param name="content"> The library requirements. </param>
        /// <param name="filename"> The filename of the library requirements file. </param>
        /// <returns> A new <see cref="Models.BigDataPoolLibraryRequirements"/> instance for mocking. </returns>
        public static BigDataPoolLibraryRequirements BigDataPoolLibraryRequirements(DateTimeOffset? updatedOn = null, string content = null, string filename = null)
        {
            return new BigDataPoolLibraryRequirements(updatedOn, content, filename, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.BigDataPoolLibraryInfo"/>. </summary>
        /// <param name="name"> Name of the library. </param>
        /// <param name="path"> Storage blob path of library. </param>
        /// <param name="containerName"> Storage blob container name. </param>
        /// <param name="uploadedOn"> The last update time of the library. </param>
        /// <param name="libraryInfoType"> Type of the library. </param>
        /// <param name="provisioningStatus"> Provisioning status of the library/package. </param>
        /// <param name="creatorId"> Creator Id of the library/package. </param>
        /// <returns> A new <see cref="Models.BigDataPoolLibraryInfo"/> instance for mocking. </returns>
        public static BigDataPoolLibraryInfo BigDataPoolLibraryInfo(string name = null, string path = null, string containerName = null, DateTimeOffset? uploadedOn = null, string libraryInfoType = null, string provisioningStatus = null, string creatorId = null)
        {
            return new BigDataPoolLibraryInfo(
                name,
                path,
                containerName,
                uploadedOn,
                libraryInfoType,
                provisioningStatus,
                creatorId,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.BigDataPoolSparkConfigProperties"/>. </summary>
        /// <param name="updatedOn"> The last update time of the spark config properties file. </param>
        /// <param name="content"> The spark config properties. </param>
        /// <param name="filename"> The filename of the spark config properties file. </param>
        /// <param name="configurationType"> The type of the spark config properties file. </param>
        /// <returns> A new <see cref="Models.BigDataPoolSparkConfigProperties"/> instance for mocking. </returns>
        public static BigDataPoolSparkConfigProperties BigDataPoolSparkConfigProperties(DateTimeOffset? updatedOn = null, string content = null, string filename = null, SynapseSparkConfigurationType? configurationType = null)
        {
            return new BigDataPoolSparkConfigProperties(updatedOn, content, filename, configurationType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Synapse.SynapseLibraryData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="namePropertiesName"> Name of the library. </param>
        /// <param name="path"> Storage blob path of library. </param>
        /// <param name="containerName"> Storage blob container name. </param>
        /// <param name="uploadedOn"> The last update time of the library. </param>
        /// <param name="typePropertiesType"> Type of the library. </param>
        /// <param name="provisioningStatus"> Provisioning status of the library/package. </param>
        /// <param name="creatorId"> Creator Id of the library/package. </param>
        /// <param name="etag"> Resource Etag. </param>
        /// <returns> A new <see cref="Synapse.SynapseLibraryData"/> instance for mocking. </returns>
        public static SynapseLibraryData SynapseLibraryData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string namePropertiesName = null, string path = null, string containerName = null, DateTimeOffset? uploadedOn = null, string typePropertiesType = null, string provisioningStatus = null, string creatorId = null, ETag? etag = null)
        {
            return new SynapseLibraryData(
                id,
                name,
                resourceType,
                systemData,
                namePropertiesName,
                path,
                containerName,
                uploadedOn,
                typePropertiesType,
                provisioningStatus,
                creatorId,
                etag,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Synapse.SynapseIntegrationRuntimeData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties">
        /// Integration runtime properties.
        /// Please note <see cref="SynapseIntegrationRuntimeProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.SynapseManagedIntegrationRuntime"/> and <see cref="SynapseSelfHostedIntegrationRuntime"/>.
        /// </param>
        /// <param name="etag"> Resource Etag. </param>
        /// <returns> A new <see cref="Synapse.SynapseIntegrationRuntimeData"/> instance for mocking. </returns>
        public static SynapseIntegrationRuntimeData SynapseIntegrationRuntimeData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, SynapseIntegrationRuntimeProperties properties = null, ETag? etag = null)
        {
            return new SynapseIntegrationRuntimeData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                etag,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SynapseIntegrationRuntimeNodeIPAddress"/>. </summary>
        /// <param name="ipAddress"> The IP address of self-hosted integration runtime node. </param>
        /// <returns> A new <see cref="Models.SynapseIntegrationRuntimeNodeIPAddress"/> instance for mocking. </returns>
        public static SynapseIntegrationRuntimeNodeIPAddress SynapseIntegrationRuntimeNodeIPAddress(IPAddress ipAddress = null)
        {
            return new SynapseIntegrationRuntimeNodeIPAddress(ipAddress, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SynapseSsisObjectMetadata"/>. </summary>
        /// <param name="metadataType"> Type of metadata. </param>
        /// <param name="id"> Metadata id. </param>
        /// <param name="name"> Metadata name. </param>
        /// <param name="description"> Metadata description. </param>
        /// <returns> A new <see cref="Models.SynapseSsisObjectMetadata"/> instance for mocking. </returns>
        public static SynapseSsisObjectMetadata SynapseSsisObjectMetadata(string metadataType = null, long? id = null, string name = null, string description = null)
        {
            return new UnknownSsisObjectMetadata(metadataType == null ? default : new SynapseSsisObjectMetadataType(metadataType), id, name, description, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SynapseSelfHostedIntegrationRuntimeNode"/>. </summary>
        /// <param name="nodeName"> Name of the integration runtime node. </param>
        /// <param name="machineName"> Machine name of the integration runtime node. </param>
        /// <param name="hostServiceUri"> URI for the host machine of the integration runtime. </param>
        /// <param name="status"> Status of the integration runtime node. </param>
        /// <param name="capabilities"> The integration runtime capabilities dictionary. </param>
        /// <param name="versionStatus"> Status of the integration runtime node version. </param>
        /// <param name="version"> Version of the integration runtime node. </param>
        /// <param name="registerOn"> The time at which the integration runtime node was registered in ISO8601 format. </param>
        /// <param name="lastConnectedOn"> The most recent time at which the integration runtime was connected in ISO8601 format. </param>
        /// <param name="expireOn"> The time at which the integration runtime will expire in ISO8601 format. </param>
        /// <param name="lastStartedOn"> The time the node last started up. </param>
        /// <param name="lastStopOn"> The integration runtime node last stop time. </param>
        /// <param name="lastUpdateResult"> The result of the last integration runtime node update. </param>
        /// <param name="lastStartUpdateOn"> The last time for the integration runtime node update start. </param>
        /// <param name="lastEndUpdateOn"> The last time for the integration runtime node update end. </param>
        /// <param name="isActiveDispatcher"> Indicates whether this node is the active dispatcher for integration runtime requests. </param>
        /// <param name="concurrentJobsLimit"> Maximum concurrent jobs on the integration runtime node. </param>
        /// <param name="maxConcurrentJobs"> The maximum concurrent jobs in this integration runtime. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <returns> A new <see cref="Models.SynapseSelfHostedIntegrationRuntimeNode"/> instance for mocking. </returns>
        public static SynapseSelfHostedIntegrationRuntimeNode SynapseSelfHostedIntegrationRuntimeNode(string nodeName = null, string machineName = null, Uri hostServiceUri = null, SynapseSelfHostedIntegrationRuntimeNodeStatus? status = null, IReadOnlyDictionary<string, string> capabilities = null, string versionStatus = null, string version = null, DateTimeOffset? registerOn = null, DateTimeOffset? lastConnectedOn = null, DateTimeOffset? expireOn = null, DateTimeOffset? lastStartedOn = null, DateTimeOffset? lastStopOn = null, SynapseIntegrationRuntimeUpdateResult? lastUpdateResult = null, DateTimeOffset? lastStartUpdateOn = null, DateTimeOffset? lastEndUpdateOn = null, bool? isActiveDispatcher = null, int? concurrentJobsLimit = null, int? maxConcurrentJobs = null, IReadOnlyDictionary<string, BinaryData> additionalProperties = null)
        {
            capabilities ??= new Dictionary<string, string>();
            additionalProperties ??= new Dictionary<string, BinaryData>();

            return new SynapseSelfHostedIntegrationRuntimeNode(
                nodeName,
                machineName,
                hostServiceUri,
                status,
                capabilities,
                versionStatus,
                version,
                registerOn,
                lastConnectedOn,
                expireOn,
                lastStartedOn,
                lastStopOn,
                lastUpdateResult,
                lastStartUpdateOn,
                lastEndUpdateOn,
                isActiveDispatcher,
                concurrentJobsLimit,
                maxConcurrentJobs,
                additionalProperties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SynapseIntegrationRuntimeConnectionInfo"/>. </summary>
        /// <param name="serviceToken"> The token generated in service. Callers use this token to authenticate to integration runtime. </param>
        /// <param name="identityCertThumbprint"> The integration runtime SSL certificate thumbprint. Click-Once application uses it to do server validation. </param>
        /// <param name="hostServiceUri"> The on-premises integration runtime host URL. </param>
        /// <param name="version"> The integration runtime version. </param>
        /// <param name="publicKey"> The public key for encrypting a credential when transferring the credential to the integration runtime. </param>
        /// <param name="isIdentityCertExprired"> Whether the identity certificate is expired. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <returns> A new <see cref="Models.SynapseIntegrationRuntimeConnectionInfo"/> instance for mocking. </returns>
        public static SynapseIntegrationRuntimeConnectionInfo SynapseIntegrationRuntimeConnectionInfo(string serviceToken = null, BinaryData identityCertThumbprint = null, Uri hostServiceUri = null, string version = null, string publicKey = null, bool? isIdentityCertExprired = null, IReadOnlyDictionary<string, BinaryData> additionalProperties = null)
        {
            additionalProperties ??= new Dictionary<string, BinaryData>();

            return new SynapseIntegrationRuntimeConnectionInfo(
                serviceToken,
                identityCertThumbprint,
                hostServiceUri,
                version,
                publicKey,
                isIdentityCertExprired,
                additionalProperties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SynapseIntegrationRuntimeStatusResult"/>. </summary>
        /// <param name="name"> The integration runtime name. </param>
        /// <param name="properties">
        /// Integration runtime properties.
        /// Please note <see cref="Models.SynapseIntegrationRuntimeStatus"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.SynapseManagedIntegrationRuntimeStatus"/> and <see cref="Models.SynapseSelfHostedIntegrationRuntimeStatus"/>.
        /// </param>
        /// <returns> A new <see cref="Models.SynapseIntegrationRuntimeStatusResult"/> instance for mocking. </returns>
        public static SynapseIntegrationRuntimeStatusResult SynapseIntegrationRuntimeStatusResult(string name = null, SynapseIntegrationRuntimeStatus properties = null)
        {
            return new SynapseIntegrationRuntimeStatusResult(name, properties, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SynapseIntegrationRuntimeStatus"/>. </summary>
        /// <param name="runtimeType"> Type of integration runtime. </param>
        /// <param name="dataFactoryName"> The workspace name which the integration runtime belong to. </param>
        /// <param name="state"> The state of integration runtime. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <returns> A new <see cref="Models.SynapseIntegrationRuntimeStatus"/> instance for mocking. </returns>
        public static SynapseIntegrationRuntimeStatus SynapseIntegrationRuntimeStatus(string runtimeType = null, string dataFactoryName = null, SynapseIntegrationRuntimeState? state = null, IReadOnlyDictionary<string, BinaryData> additionalProperties = null)
        {
            additionalProperties ??= new Dictionary<string, BinaryData>();

            return new SynapseIntegrationRuntimeStatus(runtimeType == null ? default : new IntegrationRuntimeType(runtimeType), dataFactoryName, state, additionalProperties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SynapseIntegrationRuntimeAuthKeys"/>. </summary>
        /// <param name="authKey1"> The primary integration runtime authentication key. </param>
        /// <param name="authKey2"> The secondary integration runtime authentication key. </param>
        /// <returns> A new <see cref="Models.SynapseIntegrationRuntimeAuthKeys"/> instance for mocking. </returns>
        public static SynapseIntegrationRuntimeAuthKeys SynapseIntegrationRuntimeAuthKeys(string authKey1 = null, string authKey2 = null)
        {
            return new SynapseIntegrationRuntimeAuthKeys(authKey1, authKey2, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SynapseIntegrationRuntimeMonitoringResult"/>. </summary>
        /// <param name="name"> Integration runtime name. </param>
        /// <param name="nodes"> Integration runtime node monitoring data. </param>
        /// <returns> A new <see cref="Models.SynapseIntegrationRuntimeMonitoringResult"/> instance for mocking. </returns>
        public static SynapseIntegrationRuntimeMonitoringResult SynapseIntegrationRuntimeMonitoringResult(string name = null, IEnumerable<SynapseIntegrationRuntimeNodeMonitoringResult> nodes = null)
        {
            nodes ??= new List<SynapseIntegrationRuntimeNodeMonitoringResult>();

            return new SynapseIntegrationRuntimeMonitoringResult(name, nodes?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SynapseIntegrationRuntimeNodeMonitoringResult"/>. </summary>
        /// <param name="nodeName"> Name of the integration runtime node. </param>
        /// <param name="availableMemoryInMB"> Available memory (MB) on the integration runtime node. </param>
        /// <param name="cpuUtilization"> CPU percentage on the integration runtime node. </param>
        /// <param name="concurrentJobsLimit"> Maximum concurrent jobs on the integration runtime node. </param>
        /// <param name="concurrentJobsRunning"> The number of jobs currently running on the integration runtime node. </param>
        /// <param name="maxConcurrentJobs"> The maximum concurrent jobs in this integration runtime. </param>
        /// <param name="sentBytes"> Sent bytes on the integration runtime node. </param>
        /// <param name="receivedBytes"> Received bytes on the integration runtime node. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <returns> A new <see cref="Models.SynapseIntegrationRuntimeNodeMonitoringResult"/> instance for mocking. </returns>
        public static SynapseIntegrationRuntimeNodeMonitoringResult SynapseIntegrationRuntimeNodeMonitoringResult(string nodeName = null, int? availableMemoryInMB = null, int? cpuUtilization = null, int? concurrentJobsLimit = null, int? concurrentJobsRunning = null, int? maxConcurrentJobs = null, float? sentBytes = null, float? receivedBytes = null, IReadOnlyDictionary<string, BinaryData> additionalProperties = null)
        {
            additionalProperties ??= new Dictionary<string, BinaryData>();

            return new SynapseIntegrationRuntimeNodeMonitoringResult(
                nodeName,
                availableMemoryInMB,
                cpuUtilization,
                concurrentJobsLimit,
                concurrentJobsRunning,
                maxConcurrentJobs,
                sentBytes,
                receivedBytes,
                additionalProperties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SynapseSsisObjectMetadataStatusResult"/>. </summary>
        /// <param name="status"> The status of the operation. </param>
        /// <param name="name"> The operation name. </param>
        /// <param name="properties"> The operation properties. </param>
        /// <param name="error"> The operation error message. </param>
        /// <returns> A new <see cref="Models.SynapseSsisObjectMetadataStatusResult"/> instance for mocking. </returns>
        public static SynapseSsisObjectMetadataStatusResult SynapseSsisObjectMetadataStatusResult(string status = null, string name = null, string properties = null, string error = null)
        {
            return new SynapseSsisObjectMetadataStatusResult(status, name, properties, error, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SynapseIntegrationRuntimeOutboundNetworkDependenciesCategoryEndpoint"/>. </summary>
        /// <param name="category"> The category of outbound network dependency. </param>
        /// <param name="endpoints"> The endpoints for outbound network dependency. </param>
        /// <returns> A new <see cref="Models.SynapseIntegrationRuntimeOutboundNetworkDependenciesCategoryEndpoint"/> instance for mocking. </returns>
        public static SynapseIntegrationRuntimeOutboundNetworkDependenciesCategoryEndpoint SynapseIntegrationRuntimeOutboundNetworkDependenciesCategoryEndpoint(string category = null, IEnumerable<SynapseIntegrationRuntimeOutboundNetworkDependenciesEndpoint> endpoints = null)
        {
            endpoints ??= new List<SynapseIntegrationRuntimeOutboundNetworkDependenciesEndpoint>();

            return new SynapseIntegrationRuntimeOutboundNetworkDependenciesCategoryEndpoint(category, endpoints?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SynapseIntegrationRuntimeOutboundNetworkDependenciesEndpoint"/>. </summary>
        /// <param name="domainName"> The domain name of endpoint. </param>
        /// <param name="endpointDetails"> The details of endpoint. </param>
        /// <returns> A new <see cref="Models.SynapseIntegrationRuntimeOutboundNetworkDependenciesEndpoint"/> instance for mocking. </returns>
        public static SynapseIntegrationRuntimeOutboundNetworkDependenciesEndpoint SynapseIntegrationRuntimeOutboundNetworkDependenciesEndpoint(string domainName = null, IEnumerable<SynapseIntegrationRuntimeOutboundNetworkDependenciesEndpointDetails> endpointDetails = null)
        {
            endpointDetails ??= new List<SynapseIntegrationRuntimeOutboundNetworkDependenciesEndpointDetails>();

            return new SynapseIntegrationRuntimeOutboundNetworkDependenciesEndpoint(domainName, endpointDetails?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SynapseIntegrationRuntimeOutboundNetworkDependenciesEndpointDetails"/>. </summary>
        /// <param name="port"> The port of endpoint. </param>
        /// <returns> A new <see cref="Models.SynapseIntegrationRuntimeOutboundNetworkDependenciesEndpointDetails"/> instance for mocking. </returns>
        public static SynapseIntegrationRuntimeOutboundNetworkDependenciesEndpointDetails SynapseIntegrationRuntimeOutboundNetworkDependenciesEndpointDetails(int? port = null)
        {
            return new SynapseIntegrationRuntimeOutboundNetworkDependenciesEndpointDetails(port, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Synapse.SynapseSparkConfigurationData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="description"> Description about the SparkConfiguration. </param>
        /// <param name="configs"> SparkConfiguration configs. </param>
        /// <param name="annotations"> Annotations for SparkConfiguration. </param>
        /// <param name="notes"> additional Notes. </param>
        /// <param name="createdBy"> The identity that created the resource. </param>
        /// <param name="createdOn"> The timestamp of resource creation. </param>
        /// <param name="configMergeRule"> SparkConfiguration merge configs. </param>
        /// <param name="etag"> Resource Etag. </param>
        /// <returns> A new <see cref="Synapse.SynapseSparkConfigurationData"/> instance for mocking. </returns>
        public static SynapseSparkConfigurationData SynapseSparkConfigurationData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string description = null, IDictionary<string, string> configs = null, IEnumerable<string> annotations = null, string notes = null, string createdBy = null, DateTimeOffset? createdOn = null, IDictionary<string, string> configMergeRule = null, ETag? etag = null)
        {
            configs ??= new Dictionary<string, string>();
            annotations ??= new List<string>();
            configMergeRule ??= new Dictionary<string, string>();

            return new SynapseSparkConfigurationData(
                id,
                name,
                resourceType,
                systemData,
                description,
                configs,
                annotations?.ToList(),
                notes,
                createdBy,
                createdOn,
                configMergeRule,
                etag,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.KustoPoolSkuDescription"/>. </summary>
        /// <param name="resourceType"> The resource type. </param>
        /// <param name="name"> The name of the SKU. </param>
        /// <param name="size"> The size of the SKU. </param>
        /// <param name="locations"> The set of locations that the SKU is available. </param>
        /// <param name="locationInfo"> Locations and zones. </param>
        /// <param name="restrictions"> The restrictions because of which SKU cannot be used. </param>
        /// <returns> A new <see cref="Models.KustoPoolSkuDescription"/> instance for mocking. </returns>
        public static KustoPoolSkuDescription KustoPoolSkuDescription(string resourceType = null, string name = null, string size = null, IEnumerable<AzureLocation> locations = null, IEnumerable<KustoPoolSkuLocationInfoItem> locationInfo = null, IEnumerable<BinaryData> restrictions = null)
        {
            locations ??= new List<AzureLocation>();
            locationInfo ??= new List<KustoPoolSkuLocationInfoItem>();
            restrictions ??= new List<BinaryData>();

            return new KustoPoolSkuDescription(
                resourceType,
                name,
                size,
                locations?.ToList(),
                locationInfo?.ToList(),
                restrictions?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.KustoPoolSkuLocationInfoItem"/>. </summary>
        /// <param name="location"> The available location of the SKU. </param>
        /// <param name="zones"> The available zone of the SKU. </param>
        /// <returns> A new <see cref="Models.KustoPoolSkuLocationInfoItem"/> instance for mocking. </returns>
        public static KustoPoolSkuLocationInfoItem KustoPoolSkuLocationInfoItem(AzureLocation location = default, IEnumerable<string> zones = null)
        {
            zones ??= new List<string>();

            return new KustoPoolSkuLocationInfoItem(location, zones?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.KustoPoolNameAvailabilityContent"/>. </summary>
        /// <param name="name"> Kusto Pool name. </param>
        /// <param name="resourceType"> The type of resource, Microsoft.Synapse/workspaces/kustoPools. </param>
        /// <returns> A new <see cref="Models.KustoPoolNameAvailabilityContent"/> instance for mocking. </returns>
        public static KustoPoolNameAvailabilityContent KustoPoolNameAvailabilityContent(string name = null, KustoPoolType resourceType = default)
        {
            return new KustoPoolNameAvailabilityContent(name, resourceType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.KustoPoolNameAvailabilityResult"/>. </summary>
        /// <param name="isNameAvailable"> Specifies a Boolean value that indicates if the name is available. </param>
        /// <param name="name"> The name that was checked. </param>
        /// <param name="message"> Message indicating an unavailable name due to a conflict, or a description of the naming rules that are violated. </param>
        /// <param name="reason"> Message providing the reason why the given name is invalid. </param>
        /// <returns> A new <see cref="Models.KustoPoolNameAvailabilityResult"/> instance for mocking. </returns>
        public static KustoPoolNameAvailabilityResult KustoPoolNameAvailabilityResult(bool? isNameAvailable = null, string name = null, string message = null, KustoPoolNameUnavailableReason? reason = null)
        {
            return new KustoPoolNameAvailabilityResult(isNameAvailable, name, message, reason, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Synapse.SynapseKustoPoolData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="sku"> The SKU of the kusto pool. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="state"> The state of the resource. </param>
        /// <param name="provisioningState"> The provisioned state of the resource. </param>
        /// <param name="uri"> The Kusto Pool URI. </param>
        /// <param name="dataIngestionUri"> The Kusto Pool data ingestion URI. </param>
        /// <param name="stateReason"> The reason for the Kusto Pool's current state. </param>
        /// <param name="optimizedAutoscale"> Optimized auto scale definition. </param>
        /// <param name="enableStreamingIngest"> A boolean value that indicates if the streaming ingest is enabled. </param>
        /// <param name="enablePurge"> A boolean value that indicates if the purge operations are enabled. </param>
        /// <param name="languageExtensionsValue"> List of the Kusto Pool's language extensions. </param>
        /// <param name="workspaceUid"> The workspace unique identifier. </param>
        /// <returns> A new <see cref="Synapse.SynapseKustoPoolData"/> instance for mocking. </returns>
        public static SynapseKustoPoolData SynapseKustoPoolData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, SynapseDataSourceSku sku = null, ETag? etag = null, KustoPoolState? state = null, ResourceProvisioningState? provisioningState = null, Uri uri = null, Uri dataIngestionUri = null, string stateReason = null, SynapseOptimizedAutoscale optimizedAutoscale = null, bool? enableStreamingIngest = null, bool? enablePurge = null, IEnumerable<SynapseLanguageExtension> languageExtensionsValue = null, Guid? workspaceUid = null)
        {
            tags ??= new Dictionary<string, string>();
            languageExtensionsValue ??= new List<SynapseLanguageExtension>();

            return new SynapseKustoPoolData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                sku,
                etag,
                state,
                provisioningState,
                uri,
                dataIngestionUri,
                stateReason,
                optimizedAutoscale,
                enableStreamingIngest,
                enablePurge,
                languageExtensionsValue != null ? new SynapseLanguageExtensionsList(languageExtensionsValue?.ToList(), serializedAdditionalRawData: null) : null,
                workspaceUid,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SynapseKustoPoolPatch"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="sku"> The SKU of the kusto pool. </param>
        /// <param name="state"> The state of the resource. </param>
        /// <param name="provisioningState"> The provisioned state of the resource. </param>
        /// <param name="uri"> The Kusto Pool URI. </param>
        /// <param name="dataIngestionUri"> The Kusto Pool data ingestion URI. </param>
        /// <param name="stateReason"> The reason for the Kusto Pool's current state. </param>
        /// <param name="optimizedAutoscale"> Optimized auto scale definition. </param>
        /// <param name="enableStreamingIngest"> A boolean value that indicates if the streaming ingest is enabled. </param>
        /// <param name="enablePurge"> A boolean value that indicates if the purge operations are enabled. </param>
        /// <param name="languageExtensionsValue"> List of the Kusto Pool's language extensions. </param>
        /// <param name="workspaceUid"> The workspace unique identifier. </param>
        /// <returns> A new <see cref="Models.SynapseKustoPoolPatch"/> instance for mocking. </returns>
        public static SynapseKustoPoolPatch SynapseKustoPoolPatch(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, SynapseDataSourceSku sku = null, KustoPoolState? state = null, ResourceProvisioningState? provisioningState = null, Uri uri = null, Uri dataIngestionUri = null, string stateReason = null, SynapseOptimizedAutoscale optimizedAutoscale = null, bool? enableStreamingIngest = null, bool? enablePurge = null, IEnumerable<SynapseLanguageExtension> languageExtensionsValue = null, Guid? workspaceUid = null)
        {
            tags ??= new Dictionary<string, string>();
            languageExtensionsValue ??= new List<SynapseLanguageExtension>();

            return new SynapseKustoPoolPatch(
                id,
                name,
                resourceType,
                systemData,
                tags,
                sku,
                state,
                provisioningState,
                uri,
                dataIngestionUri,
                stateReason,
                optimizedAutoscale,
                enableStreamingIngest,
                enablePurge,
                languageExtensionsValue != null ? new SynapseLanguageExtensionsList(languageExtensionsValue?.ToList(), serializedAdditionalRawData: null) : null,
                workspaceUid,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SynapseDataSourceResourceSku"/>. </summary>
        /// <param name="resourceType"> Resource Namespace and Type. </param>
        /// <param name="sku"> The SKU details. </param>
        /// <param name="capacity"> The number of instances of the cluster. </param>
        /// <returns> A new <see cref="Models.SynapseDataSourceResourceSku"/> instance for mocking. </returns>
        public static SynapseDataSourceResourceSku SynapseDataSourceResourceSku(string resourceType = null, SynapseDataSourceSku sku = null, SynapseDataSourceCapacity capacity = null)
        {
            return new SynapseDataSourceResourceSku(resourceType, sku, capacity, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SynapseDataSourceCapacity"/>. </summary>
        /// <param name="scaleType"> Scale type. </param>
        /// <param name="minimum"> Minimum allowed capacity. </param>
        /// <param name="maximum"> Maximum allowed capacity. </param>
        /// <param name="default"> The default capacity that would be used. </param>
        /// <returns> A new <see cref="Models.SynapseDataSourceCapacity"/> instance for mocking. </returns>
        public static SynapseDataSourceCapacity SynapseDataSourceCapacity(SynapseDataSourceScaleType scaleType = default, int minimum = default, int maximum = default, int @default = default)
        {
            return new SynapseDataSourceCapacity(scaleType, minimum, maximum, @default, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SynapseFollowerDatabaseDefinition"/>. </summary>
        /// <param name="kustoPoolResourceId"> Resource id of the cluster that follows a database owned by this cluster. </param>
        /// <param name="attachedDatabaseConfigurationName"> Resource name of the attached database configuration in the follower cluster. </param>
        /// <param name="databaseName"> The database name owned by this cluster that was followed. * in case following all databases. </param>
        /// <returns> A new <see cref="Models.SynapseFollowerDatabaseDefinition"/> instance for mocking. </returns>
        public static SynapseFollowerDatabaseDefinition SynapseFollowerDatabaseDefinition(ResourceIdentifier kustoPoolResourceId = null, string attachedDatabaseConfigurationName = null, string databaseName = null)
        {
            return new SynapseFollowerDatabaseDefinition(kustoPoolResourceId, attachedDatabaseConfigurationName, databaseName, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Synapse.SynapseAttachedDatabaseConfigurationData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="provisioningState"> The provisioned state of the resource. </param>
        /// <param name="databaseName"> The name of the database which you would like to attach, use * if you want to follow all current and future databases. </param>
        /// <param name="kustoPoolResourceId"> The resource id of the kusto pool where the databases you would like to attach reside. </param>
        /// <param name="attachedDatabaseNames"> The list of databases from the clusterResourceId which are currently attached to the kusto pool. </param>
        /// <param name="defaultPrincipalsModificationKind"> The default principals modification kind. </param>
        /// <param name="tableLevelSharingProperties"> Table level sharing specifications. </param>
        /// <returns> A new <see cref="Synapse.SynapseAttachedDatabaseConfigurationData"/> instance for mocking. </returns>
        public static SynapseAttachedDatabaseConfigurationData SynapseAttachedDatabaseConfigurationData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AzureLocation? location = null, ResourceProvisioningState? provisioningState = null, string databaseName = null, ResourceIdentifier kustoPoolResourceId = null, IEnumerable<string> attachedDatabaseNames = null, SynapseDefaultPrincipalsModificationKind? defaultPrincipalsModificationKind = null, SynapseTableLevelSharingProperties tableLevelSharingProperties = null)
        {
            attachedDatabaseNames ??= new List<string>();

            return new SynapseAttachedDatabaseConfigurationData(
                id,
                name,
                resourceType,
                systemData,
                location,
                provisioningState,
                databaseName,
                kustoPoolResourceId,
                attachedDatabaseNames?.ToList(),
                defaultPrincipalsModificationKind,
                tableLevelSharingProperties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Synapse.SynapseDatabaseData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="kind"> Kind of the database. </param>
        /// <returns> A new <see cref="Synapse.SynapseDatabaseData"/> instance for mocking. </returns>
        public static SynapseDatabaseData SynapseDatabaseData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AzureLocation? location = null, string kind = null)
        {
            return new SynapseDatabaseData(
                id,
                name,
                resourceType,
                systemData,
                location,
                kind == null ? default : new SynapseKind(kind),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.KustoPoolDataConnectionNameAvailabilityContent"/>. </summary>
        /// <param name="name"> Data Connection name. </param>
        /// <param name="resourceType"> The type of resource, Microsoft.Synapse/workspaces/kustoPools/databases/dataConnections. </param>
        /// <returns> A new <see cref="Models.KustoPoolDataConnectionNameAvailabilityContent"/> instance for mocking. </returns>
        public static KustoPoolDataConnectionNameAvailabilityContent KustoPoolDataConnectionNameAvailabilityContent(string name = null, SynapseDataConnectionType resourceType = default)
        {
            return new KustoPoolDataConnectionNameAvailabilityContent(name, resourceType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Synapse.SynapseDataConnectionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="kind"> Kind of the endpoint for the data connection. </param>
        /// <returns> A new <see cref="Synapse.SynapseDataConnectionData"/> instance for mocking. </returns>
        public static SynapseDataConnectionData SynapseDataConnectionData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AzureLocation? location = null, string kind = null)
        {
            return new SynapseDataConnectionData(
                id,
                name,
                resourceType,
                systemData,
                location,
                kind == null ? default : new SynapseDataConnectionKind(kind),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SynapseDataConnectionValidationListResult"/>. </summary>
        /// <param name="value"> The list of Kusto data connection validation errors. </param>
        /// <returns> A new <see cref="Models.SynapseDataConnectionValidationListResult"/> instance for mocking. </returns>
        public static SynapseDataConnectionValidationListResult SynapseDataConnectionValidationListResult(IEnumerable<SynapseDataConnectionValidationResult> value = null)
        {
            value ??= new List<SynapseDataConnectionValidationResult>();

            return new SynapseDataConnectionValidationListResult(value?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SynapseDataConnectionValidationResult"/>. </summary>
        /// <param name="errorMessage"> A message which indicates a problem in data connection validation. </param>
        /// <returns> A new <see cref="Models.SynapseDataConnectionValidationResult"/> instance for mocking. </returns>
        public static SynapseDataConnectionValidationResult SynapseDataConnectionValidationResult(string errorMessage = null)
        {
            return new SynapseDataConnectionValidationResult(errorMessage, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.KustoPoolPrincipalAssignmentNameAvailabilityContent"/>. </summary>
        /// <param name="name"> Principal Assignment resource name. </param>
        /// <param name="resourceType"> The type of resource, Microsoft.Synapse/workspaces/kustoPools/principalAssignments. </param>
        /// <returns> A new <see cref="Models.KustoPoolPrincipalAssignmentNameAvailabilityContent"/> instance for mocking. </returns>
        public static KustoPoolPrincipalAssignmentNameAvailabilityContent KustoPoolPrincipalAssignmentNameAvailabilityContent(string name = null, SynapsePrincipalAssignmentType resourceType = default)
        {
            return new KustoPoolPrincipalAssignmentNameAvailabilityContent(name, resourceType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Synapse.SynapseClusterPrincipalAssignmentData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="principalId"> The principal ID assigned to the cluster principal. It can be a user email, application ID, or security group name. </param>
        /// <param name="role"> Cluster principal role. </param>
        /// <param name="tenantId"> The tenant id of the principal. </param>
        /// <param name="principalType"> Principal type. </param>
        /// <param name="tenantName"> The tenant name of the principal. </param>
        /// <param name="principalName"> The principal name. </param>
        /// <param name="provisioningState"> The provisioned state of the resource. </param>
        /// <param name="aadObjectId"> The service principal object id in AAD (Azure active directory). </param>
        /// <returns> A new <see cref="Synapse.SynapseClusterPrincipalAssignmentData"/> instance for mocking. </returns>
        public static SynapseClusterPrincipalAssignmentData SynapseClusterPrincipalAssignmentData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string principalId = null, SynapseClusterPrincipalRole? role = null, Guid? tenantId = null, SynapsePrincipalType? principalType = null, string tenantName = null, string principalName = null, ResourceProvisioningState? provisioningState = null, Guid? aadObjectId = null)
        {
            return new SynapseClusterPrincipalAssignmentData(
                id,
                name,
                resourceType,
                systemData,
                principalId,
                role,
                tenantId,
                principalType,
                tenantName,
                principalName,
                provisioningState,
                aadObjectId,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.KustoPoolDatabasePrincipalAssignmentNameAvailabilityContent"/>. </summary>
        /// <param name="name"> Principal Assignment resource name. </param>
        /// <param name="resourceType"> The type of resource, Microsoft.Synapse/workspaces/kustoPools/databases/principalAssignments. </param>
        /// <returns> A new <see cref="Models.KustoPoolDatabasePrincipalAssignmentNameAvailabilityContent"/> instance for mocking. </returns>
        public static KustoPoolDatabasePrincipalAssignmentNameAvailabilityContent KustoPoolDatabasePrincipalAssignmentNameAvailabilityContent(string name = null, SynapseDatabasePrincipalAssignmentType resourceType = default)
        {
            return new KustoPoolDatabasePrincipalAssignmentNameAvailabilityContent(name, resourceType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Synapse.SynapseDatabasePrincipalAssignmentData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="principalId"> The principal ID assigned to the database principal. It can be a user email, application ID, or security group name. </param>
        /// <param name="role"> Database principal role. </param>
        /// <param name="tenantId"> The tenant id of the principal. </param>
        /// <param name="principalType"> Principal type. </param>
        /// <param name="tenantName"> The tenant name of the principal. </param>
        /// <param name="principalName"> The principal name. </param>
        /// <param name="provisioningState"> The provisioned state of the resource. </param>
        /// <param name="aadObjectId"> The service principal object id in AAD (Azure active directory). </param>
        /// <returns> A new <see cref="Synapse.SynapseDatabasePrincipalAssignmentData"/> instance for mocking. </returns>
        public static SynapseDatabasePrincipalAssignmentData SynapseDatabasePrincipalAssignmentData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string principalId = null, SynapseDatabasePrincipalRole? role = null, Guid? tenantId = null, SynapsePrincipalType? principalType = null, string tenantName = null, string principalName = null, ResourceProvisioningState? provisioningState = null, Guid? aadObjectId = null)
        {
            return new SynapseDatabasePrincipalAssignmentData(
                id,
                name,
                resourceType,
                systemData,
                principalId,
                role,
                tenantId,
                principalType,
                tenantName,
                principalName,
                provisioningState,
                aadObjectId,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SynapseKustoPoolPrivateLinkData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="groupId"> The Private link resources GroupId. </param>
        /// <param name="requiredMembers"> The private link resource required member names. </param>
        /// <param name="requiredZoneNames"> The private link resource required zone names. </param>
        /// <param name="provisioningState"> The provisioned state of the resource. </param>
        /// <returns> A new <see cref="Models.SynapseKustoPoolPrivateLinkData"/> instance for mocking. </returns>
        public static SynapseKustoPoolPrivateLinkData SynapseKustoPoolPrivateLinkData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string groupId = null, IEnumerable<string> requiredMembers = null, IEnumerable<string> requiredZoneNames = null, ResourceProvisioningState? provisioningState = null)
        {
            requiredMembers ??= new List<string>();
            requiredZoneNames ??= new List<string>();

            return new SynapseKustoPoolPrivateLinkData(
                id,
                name,
                resourceType,
                systemData,
                groupId,
                requiredMembers?.ToList(),
                requiredZoneNames?.ToList(),
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SynapseManagedIntegrationRuntime"/>. </summary>
        /// <param name="description"> Integration runtime description. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="state"> Integration runtime state, only valid for managed dedicated integration runtime. </param>
        /// <param name="referenceName"> The reference name of the managed virtual network. </param>
        /// <param name="typeManagedVirtualNetworkType"> The type of the managed virtual network. </param>
        /// <param name="id"> The id of the managed virtual network. </param>
        /// <param name="computeProperties"> The compute resource for managed integration runtime. </param>
        /// <param name="ssisProperties"> SSIS properties for managed integration runtime. </param>
        /// <returns> A new <see cref="Models.SynapseManagedIntegrationRuntime"/> instance for mocking. </returns>
        public static SynapseManagedIntegrationRuntime SynapseManagedIntegrationRuntime(string description = null, IDictionary<string, BinaryData> additionalProperties = null, SynapseIntegrationRuntimeState? state = null, string referenceName = null, string typeManagedVirtualNetworkType = null, string id = null, SynapseIntegrationRuntimeComputeProperties computeProperties = null, SynapseIntegrationRuntimeSsisProperties ssisProperties = null)
        {
            additionalProperties ??= new Dictionary<string, BinaryData>();

            return new SynapseManagedIntegrationRuntime(
                IntegrationRuntimeType.Managed,
                description,
                additionalProperties,
                state,
                referenceName,
                typeManagedVirtualNetworkType,
                id,
                computeProperties,
                ssisProperties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SynapseManagedIntegrationRuntimeStatus"/>. </summary>
        /// <param name="dataFactoryName"> The workspace name which the integration runtime belong to. </param>
        /// <param name="state"> The state of integration runtime. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="createOn"> The time at which the integration runtime was created, in ISO8601 format. </param>
        /// <param name="nodes"> The list of nodes for managed integration runtime. </param>
        /// <param name="otherErrors"> The errors that occurred on this integration runtime. </param>
        /// <param name="lastOperation"> The last operation result that occurred on this integration runtime. </param>
        /// <returns> A new <see cref="Models.SynapseManagedIntegrationRuntimeStatus"/> instance for mocking. </returns>
        public static SynapseManagedIntegrationRuntimeStatus SynapseManagedIntegrationRuntimeStatus(string dataFactoryName = null, SynapseIntegrationRuntimeState? state = null, IReadOnlyDictionary<string, BinaryData> additionalProperties = null, DateTimeOffset? createOn = null, IEnumerable<SynapseManagedIntegrationRuntimeNode> nodes = null, IEnumerable<SynapseManagedIntegrationRuntimeError> otherErrors = null, SynapseManagedIntegrationRuntimeOperationResult lastOperation = null)
        {
            additionalProperties ??= new Dictionary<string, BinaryData>();
            nodes ??= new List<SynapseManagedIntegrationRuntimeNode>();
            otherErrors ??= new List<SynapseManagedIntegrationRuntimeError>();

            return new SynapseManagedIntegrationRuntimeStatus(
                IntegrationRuntimeType.Managed,
                dataFactoryName,
                state,
                additionalProperties,
                createOn,
                nodes?.ToList(),
                otherErrors?.ToList(),
                lastOperation);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SynapseManagedIntegrationRuntimeNode"/>. </summary>
        /// <param name="nodeId"> The managed integration runtime node id. </param>
        /// <param name="status"> The managed integration runtime node status. </param>
        /// <param name="errors"> The errors that occurred on this integration runtime node. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <returns> A new <see cref="Models.SynapseManagedIntegrationRuntimeNode"/> instance for mocking. </returns>
        public static SynapseManagedIntegrationRuntimeNode SynapseManagedIntegrationRuntimeNode(string nodeId = null, SynapseManagedIntegrationRuntimeNodeStatus? status = null, IEnumerable<SynapseManagedIntegrationRuntimeError> errors = null, IReadOnlyDictionary<string, BinaryData> additionalProperties = null)
        {
            errors ??= new List<SynapseManagedIntegrationRuntimeError>();
            additionalProperties ??= new Dictionary<string, BinaryData>();

            return new SynapseManagedIntegrationRuntimeNode(nodeId, status, errors?.ToList(), additionalProperties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SynapseManagedIntegrationRuntimeError"/>. </summary>
        /// <param name="time"> The time when the error occurred. </param>
        /// <param name="code"> Error code. </param>
        /// <param name="parameters"> Managed integration runtime error parameters. </param>
        /// <param name="message"> Error message. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <returns> A new <see cref="Models.SynapseManagedIntegrationRuntimeError"/> instance for mocking. </returns>
        public static SynapseManagedIntegrationRuntimeError SynapseManagedIntegrationRuntimeError(DateTimeOffset? time = null, string code = null, IEnumerable<string> parameters = null, string message = null, IReadOnlyDictionary<string, BinaryData> additionalProperties = null)
        {
            parameters ??= new List<string>();
            additionalProperties ??= new Dictionary<string, BinaryData>();

            return new SynapseManagedIntegrationRuntimeError(time, code, parameters?.ToList(), message, additionalProperties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SynapseManagedIntegrationRuntimeOperationResult"/>. </summary>
        /// <param name="managedIntegrationRuntimeOperationResultType"> The operation type. Could be start or stop. </param>
        /// <param name="startOn"> The start time of the operation. </param>
        /// <param name="result"> The operation result. </param>
        /// <param name="errorCode"> The error code. </param>
        /// <param name="parameters"> Managed integration runtime error parameters. </param>
        /// <param name="activityId"> The activity id for the operation request. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <returns> A new <see cref="Models.SynapseManagedIntegrationRuntimeOperationResult"/> instance for mocking. </returns>
        public static SynapseManagedIntegrationRuntimeOperationResult SynapseManagedIntegrationRuntimeOperationResult(string managedIntegrationRuntimeOperationResultType = null, DateTimeOffset? startOn = null, string result = null, string errorCode = null, IEnumerable<string> parameters = null, string activityId = null, IReadOnlyDictionary<string, BinaryData> additionalProperties = null)
        {
            parameters ??= new List<string>();
            additionalProperties ??= new Dictionary<string, BinaryData>();

            return new SynapseManagedIntegrationRuntimeOperationResult(
                managedIntegrationRuntimeOperationResultType,
                startOn,
                result,
                errorCode,
                parameters?.ToList(),
                activityId,
                additionalProperties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SynapseSelfHostedIntegrationRuntimeStatus"/>. </summary>
        /// <param name="dataFactoryName"> The workspace name which the integration runtime belong to. </param>
        /// <param name="state"> The state of integration runtime. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="createOn"> The time at which the integration runtime was created, in ISO8601 format. </param>
        /// <param name="taskQueueId"> The task queue id of the integration runtime. </param>
        /// <param name="nodeCommunicationChannelEncryptionMode"> The node communication Channel encryption mode. </param>
        /// <param name="internalChannelEncryption"> It is used to set the encryption mode for node-node communication channel (when more than 2 self-hosted integration runtime nodes exist). </param>
        /// <param name="version"> Version of the integration runtime. </param>
        /// <param name="nodes"> The list of nodes for this integration runtime. </param>
        /// <param name="scheduledUpdateOn"> The date at which the integration runtime will be scheduled to update, in ISO8601 format. </param>
        /// <param name="updateDelayOffset"> The time in the date scheduled by service to update the integration runtime, e.g., PT03H is 3 hours. </param>
        /// <param name="localTimeZoneOffset"> The local time zone offset in hours. </param>
        /// <param name="capabilities"> Object with additional information about integration runtime capabilities. </param>
        /// <param name="serviceUrls"> The URLs for the services used in integration runtime backend service. </param>
        /// <param name="autoUpdate"> Whether Self-hosted integration runtime auto update has been turned on. </param>
        /// <param name="versionStatus"> Status of the integration runtime version. </param>
        /// <param name="links"> The list of linked integration runtimes that are created to share with this integration runtime. </param>
        /// <param name="pushedVersion"> The version that the integration runtime is going to update to. </param>
        /// <param name="latestVersion"> The latest version on download center. </param>
        /// <param name="autoUpdateEta"> The estimated time when the self-hosted integration runtime will be updated. </param>
        /// <param name="serviceRegion"> The service region of the integration runtime. </param>
        /// <param name="newerVersions"> The newer versions on download center. </param>
        /// <returns> A new <see cref="Models.SynapseSelfHostedIntegrationRuntimeStatus"/> instance for mocking. </returns>
        public static SynapseSelfHostedIntegrationRuntimeStatus SynapseSelfHostedIntegrationRuntimeStatus(string dataFactoryName = null, SynapseIntegrationRuntimeState? state = null, IReadOnlyDictionary<string, BinaryData> additionalProperties = null, DateTimeOffset? createOn = null, string taskQueueId = null, string nodeCommunicationChannelEncryptionMode = null, SynapseIntegrationRuntimeInternalChannelEncryptionMode? internalChannelEncryption = null, string version = null, IEnumerable<SynapseSelfHostedIntegrationRuntimeNode> nodes = null, DateTimeOffset? scheduledUpdateOn = null, string updateDelayOffset = null, string localTimeZoneOffset = null, IReadOnlyDictionary<string, string> capabilities = null, IEnumerable<string> serviceUrls = null, SynapseIntegrationRuntimeAutoUpdate? autoUpdate = null, string versionStatus = null, IEnumerable<SynapseLinkedIntegrationRuntime> links = null, string pushedVersion = null, string latestVersion = null, DateTimeOffset? autoUpdateEta = null, string serviceRegion = null, IEnumerable<string> newerVersions = null)
        {
            additionalProperties ??= new Dictionary<string, BinaryData>();
            nodes ??= new List<SynapseSelfHostedIntegrationRuntimeNode>();
            capabilities ??= new Dictionary<string, string>();
            serviceUrls ??= new List<string>();
            links ??= new List<SynapseLinkedIntegrationRuntime>();
            newerVersions ??= new List<string>();

            return new SynapseSelfHostedIntegrationRuntimeStatus(
                IntegrationRuntimeType.SelfHosted,
                dataFactoryName,
                state,
                additionalProperties,
                createOn,
                taskQueueId,
                nodeCommunicationChannelEncryptionMode,
                internalChannelEncryption,
                version,
                nodes?.ToList(),
                scheduledUpdateOn,
                updateDelayOffset,
                localTimeZoneOffset,
                capabilities,
                serviceUrls?.ToList(),
                autoUpdate,
                versionStatus,
                links?.ToList(),
                pushedVersion,
                latestVersion,
                autoUpdateEta,
                serviceRegion,
                newerVersions?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.SynapseLinkedIntegrationRuntime"/>. </summary>
        /// <param name="name"> The name of the linked integration runtime. </param>
        /// <param name="subscriptionId"> The subscription ID for which the linked integration runtime belong to. </param>
        /// <param name="dataFactoryName"> The name of the workspace for which the linked integration runtime belong to. </param>
        /// <param name="dataFactoryLocation"> The location of the workspace for which the linked integration runtime belong to. </param>
        /// <param name="createOn"> The creating time of the linked integration runtime. </param>
        /// <returns> A new <see cref="Models.SynapseLinkedIntegrationRuntime"/> instance for mocking. </returns>
        public static SynapseLinkedIntegrationRuntime SynapseLinkedIntegrationRuntime(string name = null, string subscriptionId = null, string dataFactoryName = null, string dataFactoryLocation = null, DateTimeOffset? createOn = null)
        {
            return new SynapseLinkedIntegrationRuntime(
                name,
                subscriptionId,
                dataFactoryName,
                dataFactoryLocation,
                createOn,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SynapseSsisFolder"/>. </summary>
        /// <param name="id"> Metadata id. </param>
        /// <param name="name"> Metadata name. </param>
        /// <param name="description"> Metadata description. </param>
        /// <returns> A new <see cref="Models.SynapseSsisFolder"/> instance for mocking. </returns>
        public static SynapseSsisFolder SynapseSsisFolder(long? id = null, string name = null, string description = null)
        {
            return new SynapseSsisFolder(SynapseSsisObjectMetadataType.Folder, id, name, description, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SynapseSsisProject"/>. </summary>
        /// <param name="id"> Metadata id. </param>
        /// <param name="name"> Metadata name. </param>
        /// <param name="description"> Metadata description. </param>
        /// <param name="folderId"> Folder id which contains project. </param>
        /// <param name="version"> Project version. </param>
        /// <param name="environmentRefs"> Environment reference in project. </param>
        /// <param name="parameters"> Parameters in project. </param>
        /// <returns> A new <see cref="Models.SynapseSsisProject"/> instance for mocking. </returns>
        public static SynapseSsisProject SynapseSsisProject(long? id = null, string name = null, string description = null, long? folderId = null, long? version = null, IEnumerable<SynapseSsisEnvironmentReference> environmentRefs = null, IEnumerable<SynapseSsisParameter> parameters = null)
        {
            environmentRefs ??= new List<SynapseSsisEnvironmentReference>();
            parameters ??= new List<SynapseSsisParameter>();

            return new SynapseSsisProject(
                SynapseSsisObjectMetadataType.Project,
                id,
                name,
                description,
                serializedAdditionalRawData: null,
                folderId,
                version,
                environmentRefs?.ToList(),
                parameters?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.SynapseSsisEnvironmentReference"/>. </summary>
        /// <param name="id"> Environment reference id. </param>
        /// <param name="environmentFolderName"> Environment folder name. </param>
        /// <param name="environmentName"> Environment name. </param>
        /// <param name="referenceType"> Reference type. </param>
        /// <returns> A new <see cref="Models.SynapseSsisEnvironmentReference"/> instance for mocking. </returns>
        public static SynapseSsisEnvironmentReference SynapseSsisEnvironmentReference(long? id = null, string environmentFolderName = null, string environmentName = null, string referenceType = null)
        {
            return new SynapseSsisEnvironmentReference(id, environmentFolderName, environmentName, referenceType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SynapseSsisParameter"/>. </summary>
        /// <param name="id"> Parameter id. </param>
        /// <param name="name"> Parameter name. </param>
        /// <param name="description"> Parameter description. </param>
        /// <param name="dataType"> Parameter type. </param>
        /// <param name="isRequired"> Whether parameter is required. </param>
        /// <param name="isSensitive"> Whether parameter is sensitive. </param>
        /// <param name="designDefaultValue"> Design default value of parameter. </param>
        /// <param name="defaultValue"> Default value of parameter. </param>
        /// <param name="sensitiveDefaultValue"> Default sensitive value of parameter. </param>
        /// <param name="valueType"> Parameter value type. </param>
        /// <param name="valueSet"> Parameter value set. </param>
        /// <param name="variable"> Parameter reference variable. </param>
        /// <returns> A new <see cref="Models.SynapseSsisParameter"/> instance for mocking. </returns>
        public static SynapseSsisParameter SynapseSsisParameter(long? id = null, string name = null, string description = null, string dataType = null, bool? isRequired = null, bool? isSensitive = null, string designDefaultValue = null, string defaultValue = null, string sensitiveDefaultValue = null, string valueType = null, bool? valueSet = null, string variable = null)
        {
            return new SynapseSsisParameter(
                id,
                name,
                description,
                dataType,
                isRequired,
                isSensitive,
                designDefaultValue,
                defaultValue,
                sensitiveDefaultValue,
                valueType,
                valueSet,
                variable,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SynapseSsisPackage"/>. </summary>
        /// <param name="id"> Metadata id. </param>
        /// <param name="name"> Metadata name. </param>
        /// <param name="description"> Metadata description. </param>
        /// <param name="folderId"> Folder id which contains package. </param>
        /// <param name="projectVersion"> Project version which contains package. </param>
        /// <param name="projectId"> Project id which contains package. </param>
        /// <param name="parameters"> Parameters in package. </param>
        /// <returns> A new <see cref="Models.SynapseSsisPackage"/> instance for mocking. </returns>
        public static SynapseSsisPackage SynapseSsisPackage(long? id = null, string name = null, string description = null, long? folderId = null, long? projectVersion = null, long? projectId = null, IEnumerable<SynapseSsisParameter> parameters = null)
        {
            parameters ??= new List<SynapseSsisParameter>();

            return new SynapseSsisPackage(
                SynapseSsisObjectMetadataType.Package,
                id,
                name,
                description,
                serializedAdditionalRawData: null,
                folderId,
                projectVersion,
                projectId,
                parameters?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.SynapseSsisEnvironment"/>. </summary>
        /// <param name="id"> Metadata id. </param>
        /// <param name="name"> Metadata name. </param>
        /// <param name="description"> Metadata description. </param>
        /// <param name="folderId"> Folder id which contains environment. </param>
        /// <param name="variables"> Variable in environment. </param>
        /// <returns> A new <see cref="Models.SynapseSsisEnvironment"/> instance for mocking. </returns>
        public static SynapseSsisEnvironment SynapseSsisEnvironment(long? id = null, string name = null, string description = null, long? folderId = null, IEnumerable<SynapseSsisVariable> variables = null)
        {
            variables ??= new List<SynapseSsisVariable>();

            return new SynapseSsisEnvironment(
                SynapseSsisObjectMetadataType.Environment,
                id,
                name,
                description,
                serializedAdditionalRawData: null,
                folderId,
                variables?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.SynapseSsisVariable"/>. </summary>
        /// <param name="id"> Variable id. </param>
        /// <param name="name"> Variable name. </param>
        /// <param name="description"> Variable description. </param>
        /// <param name="dataType"> Variable type. </param>
        /// <param name="isSensitive"> Whether variable is sensitive. </param>
        /// <param name="value"> Variable value. </param>
        /// <param name="sensitiveValue"> Variable sensitive value. </param>
        /// <returns> A new <see cref="Models.SynapseSsisVariable"/> instance for mocking. </returns>
        public static SynapseSsisVariable SynapseSsisVariable(long? id = null, string name = null, string description = null, string dataType = null, bool? isSensitive = null, string value = null, string sensitiveValue = null)
        {
            return new SynapseSsisVariable(
                id,
                name,
                description,
                dataType,
                isSensitive,
                value,
                sensitiveValue,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SynapseReadWriteDatabase"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="provisioningState"> The provisioned state of the resource. </param>
        /// <param name="softDeletePeriod"> The time the data should be kept before it stops being accessible to queries in TimeSpan. </param>
        /// <param name="hotCachePeriod"> The time the data should be kept in cache for fast queries in TimeSpan. </param>
        /// <param name="statisticsSize"> The statistics of the database. </param>
        /// <param name="isFollowed"> Indicates whether the database is followed. </param>
        /// <returns> A new <see cref="Models.SynapseReadWriteDatabase"/> instance for mocking. </returns>
        public static SynapseReadWriteDatabase SynapseReadWriteDatabase(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AzureLocation? location = null, ResourceProvisioningState? provisioningState = null, TimeSpan? softDeletePeriod = null, TimeSpan? hotCachePeriod = null, float? statisticsSize = null, bool? isFollowed = null)
        {
            return new SynapseReadWriteDatabase(
                id,
                name,
                resourceType,
                systemData,
                location,
                SynapseKind.ReadWrite,
                serializedAdditionalRawData: null,
                provisioningState,
                softDeletePeriod,
                hotCachePeriod,
                statisticsSize != null ? new DatabaseStatistics(statisticsSize, serializedAdditionalRawData: null) : null,
                isFollowed);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SynapseReadOnlyFollowingDatabase"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="provisioningState"> The provisioned state of the resource. </param>
        /// <param name="softDeletePeriod"> The time the data should be kept before it stops being accessible to queries in TimeSpan. </param>
        /// <param name="hotCachePeriod"> The time the data should be kept in cache for fast queries in TimeSpan. </param>
        /// <param name="statisticsSize"> The statistics of the database. </param>
        /// <param name="leaderClusterResourceId"> The name of the leader cluster. </param>
        /// <param name="attachedDatabaseConfigurationName"> The name of the attached database configuration cluster. </param>
        /// <param name="principalsModificationKind"> The principals modification kind of the database. </param>
        /// <returns> A new <see cref="Models.SynapseReadOnlyFollowingDatabase"/> instance for mocking. </returns>
        public static SynapseReadOnlyFollowingDatabase SynapseReadOnlyFollowingDatabase(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AzureLocation? location = null, ResourceProvisioningState? provisioningState = null, TimeSpan? softDeletePeriod = null, TimeSpan? hotCachePeriod = null, float? statisticsSize = null, string leaderClusterResourceId = null, string attachedDatabaseConfigurationName = null, SynapsePrincipalsModificationKind? principalsModificationKind = null)
        {
            return new SynapseReadOnlyFollowingDatabase(
                id,
                name,
                resourceType,
                systemData,
                location,
                SynapseKind.ReadOnlyFollowing,
                serializedAdditionalRawData: null,
                provisioningState,
                softDeletePeriod,
                hotCachePeriod,
                statisticsSize != null ? new DatabaseStatistics(statisticsSize, serializedAdditionalRawData: null) : null,
                leaderClusterResourceId,
                attachedDatabaseConfigurationName,
                principalsModificationKind);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SynapseEventHubDataConnection"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="eventHubResourceId"> The resource ID of the event hub to be used to create a data connection. </param>
        /// <param name="consumerGroup"> The event hub consumer group. </param>
        /// <param name="tableName"> The table where the data should be ingested. Optionally the table information can be added to each message. </param>
        /// <param name="mappingRuleName"> The mapping rule to be used to ingest the data. Optionally the mapping information can be added to each message. </param>
        /// <param name="dataFormat"> The data format of the message. Optionally the data format can be added to each message. </param>
        /// <param name="eventSystemProperties"> System properties of the event hub. </param>
        /// <param name="compression"> The event hub messages compression type. </param>
        /// <param name="provisioningState"> The provisioned state of the resource. </param>
        /// <param name="managedIdentityResourceId"> The resource ID of a managed identity (system or user assigned) to be used to authenticate with event hub. </param>
        /// <returns> A new <see cref="Models.SynapseEventHubDataConnection"/> instance for mocking. </returns>
        public static SynapseEventHubDataConnection SynapseEventHubDataConnection(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AzureLocation? location = null, ResourceIdentifier eventHubResourceId = null, string consumerGroup = null, string tableName = null, string mappingRuleName = null, SynapseEventHubDataFormat? dataFormat = null, IEnumerable<string> eventSystemProperties = null, KustoPoolCompressionType? compression = null, ResourceProvisioningState? provisioningState = null, ResourceIdentifier managedIdentityResourceId = null)
        {
            eventSystemProperties ??= new List<string>();

            return new SynapseEventHubDataConnection(
                id,
                name,
                resourceType,
                systemData,
                location,
                SynapseDataConnectionKind.EventHub,
                serializedAdditionalRawData: null,
                eventHubResourceId,
                consumerGroup,
                tableName,
                mappingRuleName,
                dataFormat,
                eventSystemProperties?.ToList(),
                compression,
                provisioningState,
                managedIdentityResourceId);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SynapseIotHubDataConnection"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="iotHubResourceId"> The resource ID of the Iot hub to be used to create a data connection. </param>
        /// <param name="consumerGroup"> The iot hub consumer group. </param>
        /// <param name="tableName"> The table where the data should be ingested. Optionally the table information can be added to each message. </param>
        /// <param name="mappingRuleName"> The mapping rule to be used to ingest the data. Optionally the mapping information can be added to each message. </param>
        /// <param name="dataFormat"> The data format of the message. Optionally the data format can be added to each message. </param>
        /// <param name="eventSystemProperties"> System properties of the iot hub. </param>
        /// <param name="sharedAccessPolicyName"> The name of the share access policy. </param>
        /// <param name="provisioningState"> The provisioned state of the resource. </param>
        /// <returns> A new <see cref="Models.SynapseIotHubDataConnection"/> instance for mocking. </returns>
        public static SynapseIotHubDataConnection SynapseIotHubDataConnection(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AzureLocation? location = null, ResourceIdentifier iotHubResourceId = null, string consumerGroup = null, string tableName = null, string mappingRuleName = null, SynapseIotHubDataFormat? dataFormat = null, IEnumerable<string> eventSystemProperties = null, string sharedAccessPolicyName = null, ResourceProvisioningState? provisioningState = null)
        {
            eventSystemProperties ??= new List<string>();

            return new SynapseIotHubDataConnection(
                id,
                name,
                resourceType,
                systemData,
                location,
                SynapseDataConnectionKind.IotHub,
                serializedAdditionalRawData: null,
                iotHubResourceId,
                consumerGroup,
                tableName,
                mappingRuleName,
                dataFormat,
                eventSystemProperties?.ToList(),
                sharedAccessPolicyName,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SynapseEventGridDataConnection"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="storageAccountResourceId"> The resource ID of the storage account where the data resides. </param>
        /// <param name="eventHubResourceId"> The resource ID where the event grid is configured to send events. </param>
        /// <param name="consumerGroup"> The event hub consumer group. </param>
        /// <param name="tableName"> The table where the data should be ingested. Optionally the table information can be added to each message. </param>
        /// <param name="mappingRuleName"> The mapping rule to be used to ingest the data. Optionally the mapping information can be added to each message. </param>
        /// <param name="dataFormat"> The data format of the message. Optionally the data format can be added to each message. </param>
        /// <param name="ignoreFirstRecord"> A Boolean value that, if set to true, indicates that ingestion should ignore the first record of every file. </param>
        /// <param name="blobStorageEventType"> The name of blob storage event type to process. </param>
        /// <param name="provisioningState"> The provisioned state of the resource. </param>
        /// <returns> A new <see cref="Models.SynapseEventGridDataConnection"/> instance for mocking. </returns>
        public static SynapseEventGridDataConnection SynapseEventGridDataConnection(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AzureLocation? location = null, ResourceIdentifier storageAccountResourceId = null, ResourceIdentifier eventHubResourceId = null, string consumerGroup = null, string tableName = null, string mappingRuleName = null, SynapseEventGridDataFormat? dataFormat = null, bool? ignoreFirstRecord = null, SynapseBlobStorageEventType? blobStorageEventType = null, ResourceProvisioningState? provisioningState = null)
        {
            return new SynapseEventGridDataConnection(
                id,
                name,
                resourceType,
                systemData,
                location,
                SynapseDataConnectionKind.EventGrid,
                serializedAdditionalRawData: null,
                storageAccountResourceId,
                eventHubResourceId,
                consumerGroup,
                tableName,
                mappingRuleName,
                dataFormat,
                ignoreFirstRecord,
                blobStorageEventType,
                provisioningState);
        }
    }
}
