// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Synapse.Models;

namespace Azure.ResourceManager.Synapse.Samples
{
    public partial class Sample_SynapseVulnerabilityAssessmentScanRecordResource
    {
        // Executes a Sql pool's vulnerability assessment scan.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task InitiateScan_ExecutesASqlPoolSVulnerabilityAssessmentScan()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/ExecuteSqlPoolVulnerabilityAssessmentScans.json
            // this example is just showing the usage of "SqlPoolVulnerabilityAssessmentScans_InitiateScan" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseVulnerabilityAssessmentScanRecordResource created on azure
            // for more information of creating SynapseVulnerabilityAssessmentScanRecordResource, please refer to the document of SynapseVulnerabilityAssessmentScanRecordResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityassessmenttest-4711";
            string workspaceName = "vulnerabilityassessmenttest-6411";
            string sqlPoolName = "testdb";
            SynapseVulnerabilityAssessmentName vulnerabilityAssessmentName = SynapseVulnerabilityAssessmentName.Default;
            string scanId = "scan01";
            ResourceIdentifier synapseVulnerabilityAssessmentScanRecordResourceId = SynapseVulnerabilityAssessmentScanRecordResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName, sqlPoolName, vulnerabilityAssessmentName, scanId);
            SynapseVulnerabilityAssessmentScanRecordResource synapseVulnerabilityAssessmentScanRecord = client.GetSynapseVulnerabilityAssessmentScanRecordResource(synapseVulnerabilityAssessmentScanRecordResourceId);

            // invoke the operation
            await synapseVulnerabilityAssessmentScanRecord.InitiateScanAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Export a database's vulnerability assessment scan results.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Export_ExportADatabaseSVulnerabilityAssessmentScanResults()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/ExportSqlPoolVulnerabilityAssessmentScan.json
            // this example is just showing the usage of "SqlPoolVulnerabilityAssessmentScans_Export" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseVulnerabilityAssessmentScanRecordResource created on azure
            // for more information of creating SynapseVulnerabilityAssessmentScanRecordResource, please refer to the document of SynapseVulnerabilityAssessmentScanRecordResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityassessmenttest-4799";
            string workspaceName = "vulnerabilityassessmenttest-6440";
            string sqlPoolName = "testdb";
            SynapseVulnerabilityAssessmentName vulnerabilityAssessmentName = SynapseVulnerabilityAssessmentName.Default;
            string scanId = "scan001";
            ResourceIdentifier synapseVulnerabilityAssessmentScanRecordResourceId = SynapseVulnerabilityAssessmentScanRecordResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName, sqlPoolName, vulnerabilityAssessmentName, scanId);
            SynapseVulnerabilityAssessmentScanRecordResource synapseVulnerabilityAssessmentScanRecord = client.GetSynapseVulnerabilityAssessmentScanRecordResource(synapseVulnerabilityAssessmentScanRecordResourceId);

            // invoke the operation
            SqlPoolVulnerabilityAssessmentScansExport result = await synapseVulnerabilityAssessmentScanRecord.ExportAsync();

            Console.WriteLine($"Succeeded: {result}");
        }

        // Gets a database vulnerability assessment scan record by scan ID
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetsADatabaseVulnerabilityAssessmentScanRecordByScanID()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/SqlPoolVulnerabilityAssessmentScanRecordsGet.json
            // this example is just showing the usage of "SqlPoolVulnerabilityAssessmentScans_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseVulnerabilityAssessmentScanRecordResource created on azure
            // for more information of creating SynapseVulnerabilityAssessmentScanRecordResource, please refer to the document of SynapseVulnerabilityAssessmentScanRecordResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityassessmenttest-4711";
            string workspaceName = "vulnerabilityassessmenttest-6411";
            string sqlPoolName = "testdb";
            SynapseVulnerabilityAssessmentName vulnerabilityAssessmentName = SynapseVulnerabilityAssessmentName.Default;
            string scanId = "scan001";
            ResourceIdentifier synapseVulnerabilityAssessmentScanRecordResourceId = SynapseVulnerabilityAssessmentScanRecordResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName, sqlPoolName, vulnerabilityAssessmentName, scanId);
            SynapseVulnerabilityAssessmentScanRecordResource synapseVulnerabilityAssessmentScanRecord = client.GetSynapseVulnerabilityAssessmentScanRecordResource(synapseVulnerabilityAssessmentScanRecordResourceId);

            // invoke the operation
            SynapseVulnerabilityAssessmentScanRecordResource result = await synapseVulnerabilityAssessmentScanRecord.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SynapseVulnerabilityAssessmentScanRecordData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
