// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Synapse.Models;

namespace Azure.ResourceManager.Synapse.Samples
{
    public partial class Sample_SynapseVulnerabilityAssessmentScanRecordCollection
    {
        // Get a vulnerability scan record of a SQL Analytics pool
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_GetAVulnerabilityScanRecordOfASQLAnalyticsPool()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/ListSqlPoolVulnerabilityAssessmentScanRecords.json
            // this example is just showing the usage of "SqlPoolVulnerabilityAssessmentScans_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseSqlPoolVulnerabilityAssessmentResource created on azure
            // for more information of creating SynapseSqlPoolVulnerabilityAssessmentResource, please refer to the document of SynapseSqlPoolVulnerabilityAssessmentResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityassessmenttest-4711";
            string workspaceName = "vulnerabilityassessmenttest-6411";
            string sqlPoolName = "testdb";
            SynapseVulnerabilityAssessmentName vulnerabilityAssessmentName = SynapseVulnerabilityAssessmentName.Default;
            ResourceIdentifier synapseSqlPoolVulnerabilityAssessmentResourceId = SynapseSqlPoolVulnerabilityAssessmentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName, sqlPoolName, vulnerabilityAssessmentName);
            SynapseSqlPoolVulnerabilityAssessmentResource synapseSqlPoolVulnerabilityAssessment = client.GetSynapseSqlPoolVulnerabilityAssessmentResource(synapseSqlPoolVulnerabilityAssessmentResourceId);

            // get the collection of this SynapseVulnerabilityAssessmentScanRecordResource
            SynapseVulnerabilityAssessmentScanRecordCollection collection = synapseSqlPoolVulnerabilityAssessment.GetSynapseVulnerabilityAssessmentScanRecords();

            // invoke the operation and iterate over the result
            await foreach (SynapseVulnerabilityAssessmentScanRecordResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                SynapseVulnerabilityAssessmentScanRecordData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Gets a database vulnerability assessment scan record by scan ID
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetsADatabaseVulnerabilityAssessmentScanRecordByScanID()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/SqlPoolVulnerabilityAssessmentScanRecordsGet.json
            // this example is just showing the usage of "SqlPoolVulnerabilityAssessmentScans_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseSqlPoolVulnerabilityAssessmentResource created on azure
            // for more information of creating SynapseSqlPoolVulnerabilityAssessmentResource, please refer to the document of SynapseSqlPoolVulnerabilityAssessmentResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityassessmenttest-4711";
            string workspaceName = "vulnerabilityassessmenttest-6411";
            string sqlPoolName = "testdb";
            SynapseVulnerabilityAssessmentName vulnerabilityAssessmentName = SynapseVulnerabilityAssessmentName.Default;
            ResourceIdentifier synapseSqlPoolVulnerabilityAssessmentResourceId = SynapseSqlPoolVulnerabilityAssessmentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName, sqlPoolName, vulnerabilityAssessmentName);
            SynapseSqlPoolVulnerabilityAssessmentResource synapseSqlPoolVulnerabilityAssessment = client.GetSynapseSqlPoolVulnerabilityAssessmentResource(synapseSqlPoolVulnerabilityAssessmentResourceId);

            // get the collection of this SynapseVulnerabilityAssessmentScanRecordResource
            SynapseVulnerabilityAssessmentScanRecordCollection collection = synapseSqlPoolVulnerabilityAssessment.GetSynapseVulnerabilityAssessmentScanRecords();

            // invoke the operation
            string scanId = "scan001";
            SynapseVulnerabilityAssessmentScanRecordResource result = await collection.GetAsync(scanId);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SynapseVulnerabilityAssessmentScanRecordData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Gets a database vulnerability assessment scan record by scan ID
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetsADatabaseVulnerabilityAssessmentScanRecordByScanID()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/SqlPoolVulnerabilityAssessmentScanRecordsGet.json
            // this example is just showing the usage of "SqlPoolVulnerabilityAssessmentScans_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseSqlPoolVulnerabilityAssessmentResource created on azure
            // for more information of creating SynapseSqlPoolVulnerabilityAssessmentResource, please refer to the document of SynapseSqlPoolVulnerabilityAssessmentResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityassessmenttest-4711";
            string workspaceName = "vulnerabilityassessmenttest-6411";
            string sqlPoolName = "testdb";
            SynapseVulnerabilityAssessmentName vulnerabilityAssessmentName = SynapseVulnerabilityAssessmentName.Default;
            ResourceIdentifier synapseSqlPoolVulnerabilityAssessmentResourceId = SynapseSqlPoolVulnerabilityAssessmentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName, sqlPoolName, vulnerabilityAssessmentName);
            SynapseSqlPoolVulnerabilityAssessmentResource synapseSqlPoolVulnerabilityAssessment = client.GetSynapseSqlPoolVulnerabilityAssessmentResource(synapseSqlPoolVulnerabilityAssessmentResourceId);

            // get the collection of this SynapseVulnerabilityAssessmentScanRecordResource
            SynapseVulnerabilityAssessmentScanRecordCollection collection = synapseSqlPoolVulnerabilityAssessment.GetSynapseVulnerabilityAssessmentScanRecords();

            // invoke the operation
            string scanId = "scan001";
            bool result = await collection.ExistsAsync(scanId);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Gets a database vulnerability assessment scan record by scan ID
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetsADatabaseVulnerabilityAssessmentScanRecordByScanID()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/SqlPoolVulnerabilityAssessmentScanRecordsGet.json
            // this example is just showing the usage of "SqlPoolVulnerabilityAssessmentScans_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseSqlPoolVulnerabilityAssessmentResource created on azure
            // for more information of creating SynapseSqlPoolVulnerabilityAssessmentResource, please refer to the document of SynapseSqlPoolVulnerabilityAssessmentResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityassessmenttest-4711";
            string workspaceName = "vulnerabilityassessmenttest-6411";
            string sqlPoolName = "testdb";
            SynapseVulnerabilityAssessmentName vulnerabilityAssessmentName = SynapseVulnerabilityAssessmentName.Default;
            ResourceIdentifier synapseSqlPoolVulnerabilityAssessmentResourceId = SynapseSqlPoolVulnerabilityAssessmentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName, sqlPoolName, vulnerabilityAssessmentName);
            SynapseSqlPoolVulnerabilityAssessmentResource synapseSqlPoolVulnerabilityAssessment = client.GetSynapseSqlPoolVulnerabilityAssessmentResource(synapseSqlPoolVulnerabilityAssessmentResourceId);

            // get the collection of this SynapseVulnerabilityAssessmentScanRecordResource
            SynapseVulnerabilityAssessmentScanRecordCollection collection = synapseSqlPoolVulnerabilityAssessment.GetSynapseVulnerabilityAssessmentScanRecords();

            // invoke the operation
            string scanId = "scan001";
            NullableResponse<SynapseVulnerabilityAssessmentScanRecordResource> response = await collection.GetIfExistsAsync(scanId);
            SynapseVulnerabilityAssessmentScanRecordResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                SynapseVulnerabilityAssessmentScanRecordData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }
    }
}
