// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Synapse.Models;

namespace Azure.ResourceManager.Synapse.Samples
{
    public partial class Sample_SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource
    {
        // Creates or updates a database's vulnerability assessment rule baseline.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreatesOrUpdatesADatabaseSVulnerabilityAssessmentRuleBaseline()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/CreateOrUpdateSqlPoolVulnerabilityAssessmentRuleBaseline.json
            // this example is just showing the usage of "SqlPoolVulnerabilityAssessmentRuleBaselines_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource created on azure
            // for more information of creating SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource, please refer to the document of SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityaseessmenttest-4799";
            string workspaceName = "vulnerabilityaseessmenttest-6440";
            string sqlPoolName = "testdb";
            SynapseVulnerabilityAssessmentName vulnerabilityAssessmentName = SynapseVulnerabilityAssessmentName.Default;
            string ruleId = "VA1001";
            SynapseVulnerabilityAssessmentPolicyBaselineName baselineName = SynapseVulnerabilityAssessmentPolicyBaselineName.Default;
            ResourceIdentifier synapseSqlPoolVulnerabilityAssessmentRuleBaselineResourceId = SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName, sqlPoolName, vulnerabilityAssessmentName, ruleId, baselineName);
            SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource synapseSqlPoolVulnerabilityAssessmentRuleBaseline = client.GetSynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource(synapseSqlPoolVulnerabilityAssessmentRuleBaselineResourceId);

            // invoke the operation
            SynapseSqlPoolVulnerabilityAssessmentRuleBaselineData data = new SynapseSqlPoolVulnerabilityAssessmentRuleBaselineData()
            {
                BaselineResults =
{
new SqlPoolVulnerabilityAssessmentRuleBaselineItem(new string[]
{
"userA","SELECT"
}),new SqlPoolVulnerabilityAssessmentRuleBaselineItem(new string[]
{
"userB","SELECT"
}),new SqlPoolVulnerabilityAssessmentRuleBaselineItem(new string[]
{
"userC","SELECT","tableId_4"
})
},
            };
            ArmOperation<SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource> lro = await synapseSqlPoolVulnerabilityAssessmentRuleBaseline.UpdateAsync(WaitUntil.Completed, data);
            SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SynapseSqlPoolVulnerabilityAssessmentRuleBaselineData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Removes a database's vulnerability assessment rule baseline.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_RemovesADatabaseSVulnerabilityAssessmentRuleBaseline()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/DeleteSqlPoolVulnerabilityAssessmentRuleBaseline.json
            // this example is just showing the usage of "SqlPoolVulnerabilityAssessmentRuleBaselines_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource created on azure
            // for more information of creating SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource, please refer to the document of SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityaseessmenttest-4799";
            string workspaceName = "vulnerabilityaseessmenttest-6440";
            string sqlPoolName = "testdb";
            SynapseVulnerabilityAssessmentName vulnerabilityAssessmentName = SynapseVulnerabilityAssessmentName.Default;
            string ruleId = "VA1001";
            SynapseVulnerabilityAssessmentPolicyBaselineName baselineName = SynapseVulnerabilityAssessmentPolicyBaselineName.Default;
            ResourceIdentifier synapseSqlPoolVulnerabilityAssessmentRuleBaselineResourceId = SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName, sqlPoolName, vulnerabilityAssessmentName, ruleId, baselineName);
            SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource synapseSqlPoolVulnerabilityAssessmentRuleBaseline = client.GetSynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource(synapseSqlPoolVulnerabilityAssessmentRuleBaselineResourceId);

            // invoke the operation
            await synapseSqlPoolVulnerabilityAssessmentRuleBaseline.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Gets a Sql pool's vulnerability assessment rule baseline.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetsASqlPoolSVulnerabilityAssessmentRuleBaseline()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/SqlPoolVulnerabilityAssessmentRuleBaselineGet.json
            // this example is just showing the usage of "SqlPoolVulnerabilityAssessmentRuleBaselines_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource created on azure
            // for more information of creating SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource, please refer to the document of SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityaseessmenttest-4711";
            string workspaceName = "vulnerabilityaseessmenttest-6411";
            string sqlPoolName = "testdb";
            SynapseVulnerabilityAssessmentName vulnerabilityAssessmentName = SynapseVulnerabilityAssessmentName.Default;
            string ruleId = "VA1001";
            SynapseVulnerabilityAssessmentPolicyBaselineName baselineName = SynapseVulnerabilityAssessmentPolicyBaselineName.Master;
            ResourceIdentifier synapseSqlPoolVulnerabilityAssessmentRuleBaselineResourceId = SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName, sqlPoolName, vulnerabilityAssessmentName, ruleId, baselineName);
            SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource synapseSqlPoolVulnerabilityAssessmentRuleBaseline = client.GetSynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource(synapseSqlPoolVulnerabilityAssessmentRuleBaselineResourceId);

            // invoke the operation
            SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource result = await synapseSqlPoolVulnerabilityAssessmentRuleBaseline.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SynapseSqlPoolVulnerabilityAssessmentRuleBaselineData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
