// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Synapse.Models;

namespace Azure.ResourceManager.Synapse.Samples
{
    public partial class Sample_SynapseSqlPoolVulnerabilityAssessmentRuleBaselineCollection
    {
        // Creates or updates a database's vulnerability assessment rule baseline.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreatesOrUpdatesADatabaseSVulnerabilityAssessmentRuleBaseline()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/CreateOrUpdateSqlPoolVulnerabilityAssessmentRuleBaseline.json
            // this example is just showing the usage of "SqlPoolVulnerabilityAssessmentRuleBaselines_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseSqlPoolVulnerabilityAssessmentResource created on azure
            // for more information of creating SynapseSqlPoolVulnerabilityAssessmentResource, please refer to the document of SynapseSqlPoolVulnerabilityAssessmentResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityaseessmenttest-4799";
            string workspaceName = "vulnerabilityaseessmenttest-6440";
            string sqlPoolName = "testdb";
            SynapseVulnerabilityAssessmentName vulnerabilityAssessmentName = SynapseVulnerabilityAssessmentName.Default;
            ResourceIdentifier synapseSqlPoolVulnerabilityAssessmentResourceId = SynapseSqlPoolVulnerabilityAssessmentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName, sqlPoolName, vulnerabilityAssessmentName);
            SynapseSqlPoolVulnerabilityAssessmentResource synapseSqlPoolVulnerabilityAssessment = client.GetSynapseSqlPoolVulnerabilityAssessmentResource(synapseSqlPoolVulnerabilityAssessmentResourceId);

            // get the collection of this SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource
            SynapseSqlPoolVulnerabilityAssessmentRuleBaselineCollection collection = synapseSqlPoolVulnerabilityAssessment.GetSynapseSqlPoolVulnerabilityAssessmentRuleBaselines();

            // invoke the operation
            string ruleId = "VA1001";
            SynapseVulnerabilityAssessmentPolicyBaselineName baselineName = SynapseVulnerabilityAssessmentPolicyBaselineName.Default;
            SynapseSqlPoolVulnerabilityAssessmentRuleBaselineData data = new SynapseSqlPoolVulnerabilityAssessmentRuleBaselineData()
            {
                BaselineResults =
{
new SqlPoolVulnerabilityAssessmentRuleBaselineItem(new string[]
{
"userA","SELECT"
}),new SqlPoolVulnerabilityAssessmentRuleBaselineItem(new string[]
{
"userB","SELECT"
}),new SqlPoolVulnerabilityAssessmentRuleBaselineItem(new string[]
{
"userC","SELECT","tableId_4"
})
},
            };
            ArmOperation<SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, ruleId, baselineName, data);
            SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SynapseSqlPoolVulnerabilityAssessmentRuleBaselineData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Gets a Sql pool's vulnerability assessment rule baseline.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetsASqlPoolSVulnerabilityAssessmentRuleBaseline()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/SqlPoolVulnerabilityAssessmentRuleBaselineGet.json
            // this example is just showing the usage of "SqlPoolVulnerabilityAssessmentRuleBaselines_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseSqlPoolVulnerabilityAssessmentResource created on azure
            // for more information of creating SynapseSqlPoolVulnerabilityAssessmentResource, please refer to the document of SynapseSqlPoolVulnerabilityAssessmentResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityaseessmenttest-4711";
            string workspaceName = "vulnerabilityaseessmenttest-6411";
            string sqlPoolName = "testdb";
            SynapseVulnerabilityAssessmentName vulnerabilityAssessmentName = SynapseVulnerabilityAssessmentName.Default;
            ResourceIdentifier synapseSqlPoolVulnerabilityAssessmentResourceId = SynapseSqlPoolVulnerabilityAssessmentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName, sqlPoolName, vulnerabilityAssessmentName);
            SynapseSqlPoolVulnerabilityAssessmentResource synapseSqlPoolVulnerabilityAssessment = client.GetSynapseSqlPoolVulnerabilityAssessmentResource(synapseSqlPoolVulnerabilityAssessmentResourceId);

            // get the collection of this SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource
            SynapseSqlPoolVulnerabilityAssessmentRuleBaselineCollection collection = synapseSqlPoolVulnerabilityAssessment.GetSynapseSqlPoolVulnerabilityAssessmentRuleBaselines();

            // invoke the operation
            string ruleId = "VA1001";
            SynapseVulnerabilityAssessmentPolicyBaselineName baselineName = SynapseVulnerabilityAssessmentPolicyBaselineName.Master;
            SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource result = await collection.GetAsync(ruleId, baselineName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SynapseSqlPoolVulnerabilityAssessmentRuleBaselineData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Gets a Sql pool's vulnerability assessment rule baseline.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetsASqlPoolSVulnerabilityAssessmentRuleBaseline()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/SqlPoolVulnerabilityAssessmentRuleBaselineGet.json
            // this example is just showing the usage of "SqlPoolVulnerabilityAssessmentRuleBaselines_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseSqlPoolVulnerabilityAssessmentResource created on azure
            // for more information of creating SynapseSqlPoolVulnerabilityAssessmentResource, please refer to the document of SynapseSqlPoolVulnerabilityAssessmentResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityaseessmenttest-4711";
            string workspaceName = "vulnerabilityaseessmenttest-6411";
            string sqlPoolName = "testdb";
            SynapseVulnerabilityAssessmentName vulnerabilityAssessmentName = SynapseVulnerabilityAssessmentName.Default;
            ResourceIdentifier synapseSqlPoolVulnerabilityAssessmentResourceId = SynapseSqlPoolVulnerabilityAssessmentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName, sqlPoolName, vulnerabilityAssessmentName);
            SynapseSqlPoolVulnerabilityAssessmentResource synapseSqlPoolVulnerabilityAssessment = client.GetSynapseSqlPoolVulnerabilityAssessmentResource(synapseSqlPoolVulnerabilityAssessmentResourceId);

            // get the collection of this SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource
            SynapseSqlPoolVulnerabilityAssessmentRuleBaselineCollection collection = synapseSqlPoolVulnerabilityAssessment.GetSynapseSqlPoolVulnerabilityAssessmentRuleBaselines();

            // invoke the operation
            string ruleId = "VA1001";
            SynapseVulnerabilityAssessmentPolicyBaselineName baselineName = SynapseVulnerabilityAssessmentPolicyBaselineName.Master;
            bool result = await collection.ExistsAsync(ruleId, baselineName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Gets a Sql pool's vulnerability assessment rule baseline.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetsASqlPoolSVulnerabilityAssessmentRuleBaseline()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/SqlPoolVulnerabilityAssessmentRuleBaselineGet.json
            // this example is just showing the usage of "SqlPoolVulnerabilityAssessmentRuleBaselines_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseSqlPoolVulnerabilityAssessmentResource created on azure
            // for more information of creating SynapseSqlPoolVulnerabilityAssessmentResource, please refer to the document of SynapseSqlPoolVulnerabilityAssessmentResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityaseessmenttest-4711";
            string workspaceName = "vulnerabilityaseessmenttest-6411";
            string sqlPoolName = "testdb";
            SynapseVulnerabilityAssessmentName vulnerabilityAssessmentName = SynapseVulnerabilityAssessmentName.Default;
            ResourceIdentifier synapseSqlPoolVulnerabilityAssessmentResourceId = SynapseSqlPoolVulnerabilityAssessmentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName, sqlPoolName, vulnerabilityAssessmentName);
            SynapseSqlPoolVulnerabilityAssessmentResource synapseSqlPoolVulnerabilityAssessment = client.GetSynapseSqlPoolVulnerabilityAssessmentResource(synapseSqlPoolVulnerabilityAssessmentResourceId);

            // get the collection of this SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource
            SynapseSqlPoolVulnerabilityAssessmentRuleBaselineCollection collection = synapseSqlPoolVulnerabilityAssessment.GetSynapseSqlPoolVulnerabilityAssessmentRuleBaselines();

            // invoke the operation
            string ruleId = "VA1001";
            SynapseVulnerabilityAssessmentPolicyBaselineName baselineName = SynapseVulnerabilityAssessmentPolicyBaselineName.Master;
            NullableResponse<SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource> response = await collection.GetIfExistsAsync(ruleId, baselineName);
            SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                SynapseSqlPoolVulnerabilityAssessmentRuleBaselineData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }
    }
}
