// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Synapse.Models;

namespace Azure.ResourceManager.Synapse.Samples
{
    public partial class Sample_SynapseSqlPoolVulnerabilityAssessmentResource
    {
        // Get a Sql pool's vulnerability assessment
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetASqlPoolSVulnerabilityAssessment()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/GetSqlPoolVulnerabilityAssessment.json
            // this example is just showing the usage of "SqlPoolVulnerabilityAssessments_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseSqlPoolVulnerabilityAssessmentResource created on azure
            // for more information of creating SynapseSqlPoolVulnerabilityAssessmentResource, please refer to the document of SynapseSqlPoolVulnerabilityAssessmentResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityaseessmenttest-4799";
            string workspaceName = "vulnerabilityaseessmenttest-6440";
            string sqlPoolName = "testdb";
            SynapseVulnerabilityAssessmentName vulnerabilityAssessmentName = SynapseVulnerabilityAssessmentName.Default;
            ResourceIdentifier synapseSqlPoolVulnerabilityAssessmentResourceId = SynapseSqlPoolVulnerabilityAssessmentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName, sqlPoolName, vulnerabilityAssessmentName);
            SynapseSqlPoolVulnerabilityAssessmentResource synapseSqlPoolVulnerabilityAssessment = client.GetSynapseSqlPoolVulnerabilityAssessmentResource(synapseSqlPoolVulnerabilityAssessmentResourceId);

            // invoke the operation
            SynapseSqlPoolVulnerabilityAssessmentResource result = await synapseSqlPoolVulnerabilityAssessment.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SynapseSqlPoolVulnerabilityAssessmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create a database's vulnerability assessment with all parameters
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateADatabaseSVulnerabilityAssessmentWithAllParameters()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/CreateOrUpdateSqlPoolVulnerabilityAssessmentWithAllParameters.json
            // this example is just showing the usage of "SqlPoolVulnerabilityAssessments_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseSqlPoolVulnerabilityAssessmentResource created on azure
            // for more information of creating SynapseSqlPoolVulnerabilityAssessmentResource, please refer to the document of SynapseSqlPoolVulnerabilityAssessmentResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityaseessmenttest-4799";
            string workspaceName = "vulnerabilityaseessmenttest-6440";
            string sqlPoolName = "testdb";
            SynapseVulnerabilityAssessmentName vulnerabilityAssessmentName = SynapseVulnerabilityAssessmentName.Default;
            ResourceIdentifier synapseSqlPoolVulnerabilityAssessmentResourceId = SynapseSqlPoolVulnerabilityAssessmentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName, sqlPoolName, vulnerabilityAssessmentName);
            SynapseSqlPoolVulnerabilityAssessmentResource synapseSqlPoolVulnerabilityAssessment = client.GetSynapseSqlPoolVulnerabilityAssessmentResource(synapseSqlPoolVulnerabilityAssessmentResourceId);

            // invoke the operation
            SynapseSqlPoolVulnerabilityAssessmentData data = new SynapseSqlPoolVulnerabilityAssessmentData()
            {
                StorageContainerPath = "https://myStorage.blob.core.windows.net/vulnerability-assessment/",
                StorageContainerSasKey = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
                StorageAccountAccessKey = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
                RecurringScans = new SynapseVulnerabilityAssessmentRecurringScansProperties()
                {
                    IsEnabled = true,
                    EnableEmailToAccountAdmins = true,
                    Emails =
{
"email1@mail.com","email2@mail.com"
},
                },
            };
            ArmOperation<SynapseSqlPoolVulnerabilityAssessmentResource> lro = await synapseSqlPoolVulnerabilityAssessment.UpdateAsync(WaitUntil.Completed, data);
            SynapseSqlPoolVulnerabilityAssessmentResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SynapseSqlPoolVulnerabilityAssessmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create a database's vulnerability assessment with minimal parameters, when storageAccountAccessKey is specified
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateADatabaseSVulnerabilityAssessmentWithMinimalParametersWhenStorageAccountAccessKeyIsSpecified()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/CreateOrUpdateVulnerabilityAssessmentWithStorageAccessKeyAndMinParameters.json
            // this example is just showing the usage of "SqlPoolVulnerabilityAssessments_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseSqlPoolVulnerabilityAssessmentResource created on azure
            // for more information of creating SynapseSqlPoolVulnerabilityAssessmentResource, please refer to the document of SynapseSqlPoolVulnerabilityAssessmentResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityaseessmenttest-4799";
            string workspaceName = "vulnerabilityaseessmenttest-6440";
            string sqlPoolName = "testdb";
            SynapseVulnerabilityAssessmentName vulnerabilityAssessmentName = SynapseVulnerabilityAssessmentName.Default;
            ResourceIdentifier synapseSqlPoolVulnerabilityAssessmentResourceId = SynapseSqlPoolVulnerabilityAssessmentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName, sqlPoolName, vulnerabilityAssessmentName);
            SynapseSqlPoolVulnerabilityAssessmentResource synapseSqlPoolVulnerabilityAssessment = client.GetSynapseSqlPoolVulnerabilityAssessmentResource(synapseSqlPoolVulnerabilityAssessmentResourceId);

            // invoke the operation
            SynapseSqlPoolVulnerabilityAssessmentData data = new SynapseSqlPoolVulnerabilityAssessmentData()
            {
                StorageContainerPath = "https://myStorage.blob.core.windows.net/vulnerability-assessment/",
                StorageAccountAccessKey = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
            };
            ArmOperation<SynapseSqlPoolVulnerabilityAssessmentResource> lro = await synapseSqlPoolVulnerabilityAssessment.UpdateAsync(WaitUntil.Completed, data);
            SynapseSqlPoolVulnerabilityAssessmentResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SynapseSqlPoolVulnerabilityAssessmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create a database's vulnerability assessment with minimal parameters, when storageContainerSasKey is specified
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateADatabaseSVulnerabilityAssessmentWithMinimalParametersWhenStorageContainerSasKeyIsSpecified()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/CreateOrUpdateSqlPoolVulnerabilityAssessmentWithContainerSasKeyAndMinParameters.json
            // this example is just showing the usage of "SqlPoolVulnerabilityAssessments_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseSqlPoolVulnerabilityAssessmentResource created on azure
            // for more information of creating SynapseSqlPoolVulnerabilityAssessmentResource, please refer to the document of SynapseSqlPoolVulnerabilityAssessmentResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityaseessmenttest-4799";
            string workspaceName = "vulnerabilityaseessmenttest-6440";
            string sqlPoolName = "testdb";
            SynapseVulnerabilityAssessmentName vulnerabilityAssessmentName = SynapseVulnerabilityAssessmentName.Default;
            ResourceIdentifier synapseSqlPoolVulnerabilityAssessmentResourceId = SynapseSqlPoolVulnerabilityAssessmentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName, sqlPoolName, vulnerabilityAssessmentName);
            SynapseSqlPoolVulnerabilityAssessmentResource synapseSqlPoolVulnerabilityAssessment = client.GetSynapseSqlPoolVulnerabilityAssessmentResource(synapseSqlPoolVulnerabilityAssessmentResourceId);

            // invoke the operation
            SynapseSqlPoolVulnerabilityAssessmentData data = new SynapseSqlPoolVulnerabilityAssessmentData()
            {
                StorageContainerPath = "https://myStorage.blob.core.windows.net/vulnerability-assessment/",
                StorageContainerSasKey = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
            };
            ArmOperation<SynapseSqlPoolVulnerabilityAssessmentResource> lro = await synapseSqlPoolVulnerabilityAssessment.UpdateAsync(WaitUntil.Completed, data);
            SynapseSqlPoolVulnerabilityAssessmentResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SynapseSqlPoolVulnerabilityAssessmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Remove a database's vulnerability assessment
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_RemoveADatabaseSVulnerabilityAssessment()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/DeleteSqlPoolVulnerabilityAssessment.json
            // this example is just showing the usage of "SqlPoolVulnerabilityAssessments_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseSqlPoolVulnerabilityAssessmentResource created on azure
            // for more information of creating SynapseSqlPoolVulnerabilityAssessmentResource, please refer to the document of SynapseSqlPoolVulnerabilityAssessmentResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityaseessmenttest-4799";
            string workspaceName = "vulnerabilityaseessmenttest-6440";
            string sqlPoolName = "testdb";
            SynapseVulnerabilityAssessmentName vulnerabilityAssessmentName = SynapseVulnerabilityAssessmentName.Default;
            ResourceIdentifier synapseSqlPoolVulnerabilityAssessmentResourceId = SynapseSqlPoolVulnerabilityAssessmentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName, sqlPoolName, vulnerabilityAssessmentName);
            SynapseSqlPoolVulnerabilityAssessmentResource synapseSqlPoolVulnerabilityAssessment = client.GetSynapseSqlPoolVulnerabilityAssessmentResource(synapseSqlPoolVulnerabilityAssessmentResourceId);

            // invoke the operation
            await synapseSqlPoolVulnerabilityAssessment.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
