// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Synapse.Models;

namespace Azure.ResourceManager.Synapse.Samples
{
    public partial class Sample_SynapseSqlPoolVulnerabilityAssessmentCollection
    {
        // Get a vulnerability assessment of a SQL Analytics pool
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_GetAVulnerabilityAssessmentOfASQLAnalyticsPool()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/ListSqlPoolVulnerabilityAssessments.json
            // this example is just showing the usage of "SqlPoolVulnerabilityAssessments_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseSqlPoolResource created on azure
            // for more information of creating SynapseSqlPoolResource, please refer to the document of SynapseSqlPoolResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityaseessmenttest-4799";
            string workspaceName = "vulnerabilityaseessmenttest-6440";
            string sqlPoolName = "testdb";
            ResourceIdentifier synapseSqlPoolResourceId = SynapseSqlPoolResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName, sqlPoolName);
            SynapseSqlPoolResource synapseSqlPool = client.GetSynapseSqlPoolResource(synapseSqlPoolResourceId);

            // get the collection of this SynapseSqlPoolVulnerabilityAssessmentResource
            SynapseSqlPoolVulnerabilityAssessmentCollection collection = synapseSqlPool.GetSynapseSqlPoolVulnerabilityAssessments();

            // invoke the operation and iterate over the result
            await foreach (SynapseSqlPoolVulnerabilityAssessmentResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                SynapseSqlPoolVulnerabilityAssessmentData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Get a Sql pool's vulnerability assessment
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetASqlPoolSVulnerabilityAssessment()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/GetSqlPoolVulnerabilityAssessment.json
            // this example is just showing the usage of "SqlPoolVulnerabilityAssessments_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseSqlPoolResource created on azure
            // for more information of creating SynapseSqlPoolResource, please refer to the document of SynapseSqlPoolResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityaseessmenttest-4799";
            string workspaceName = "vulnerabilityaseessmenttest-6440";
            string sqlPoolName = "testdb";
            ResourceIdentifier synapseSqlPoolResourceId = SynapseSqlPoolResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName, sqlPoolName);
            SynapseSqlPoolResource synapseSqlPool = client.GetSynapseSqlPoolResource(synapseSqlPoolResourceId);

            // get the collection of this SynapseSqlPoolVulnerabilityAssessmentResource
            SynapseSqlPoolVulnerabilityAssessmentCollection collection = synapseSqlPool.GetSynapseSqlPoolVulnerabilityAssessments();

            // invoke the operation
            SynapseVulnerabilityAssessmentName vulnerabilityAssessmentName = SynapseVulnerabilityAssessmentName.Default;
            SynapseSqlPoolVulnerabilityAssessmentResource result = await collection.GetAsync(vulnerabilityAssessmentName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SynapseSqlPoolVulnerabilityAssessmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get a Sql pool's vulnerability assessment
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetASqlPoolSVulnerabilityAssessment()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/GetSqlPoolVulnerabilityAssessment.json
            // this example is just showing the usage of "SqlPoolVulnerabilityAssessments_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseSqlPoolResource created on azure
            // for more information of creating SynapseSqlPoolResource, please refer to the document of SynapseSqlPoolResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityaseessmenttest-4799";
            string workspaceName = "vulnerabilityaseessmenttest-6440";
            string sqlPoolName = "testdb";
            ResourceIdentifier synapseSqlPoolResourceId = SynapseSqlPoolResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName, sqlPoolName);
            SynapseSqlPoolResource synapseSqlPool = client.GetSynapseSqlPoolResource(synapseSqlPoolResourceId);

            // get the collection of this SynapseSqlPoolVulnerabilityAssessmentResource
            SynapseSqlPoolVulnerabilityAssessmentCollection collection = synapseSqlPool.GetSynapseSqlPoolVulnerabilityAssessments();

            // invoke the operation
            SynapseVulnerabilityAssessmentName vulnerabilityAssessmentName = SynapseVulnerabilityAssessmentName.Default;
            bool result = await collection.ExistsAsync(vulnerabilityAssessmentName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get a Sql pool's vulnerability assessment
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetASqlPoolSVulnerabilityAssessment()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/GetSqlPoolVulnerabilityAssessment.json
            // this example is just showing the usage of "SqlPoolVulnerabilityAssessments_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseSqlPoolResource created on azure
            // for more information of creating SynapseSqlPoolResource, please refer to the document of SynapseSqlPoolResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityaseessmenttest-4799";
            string workspaceName = "vulnerabilityaseessmenttest-6440";
            string sqlPoolName = "testdb";
            ResourceIdentifier synapseSqlPoolResourceId = SynapseSqlPoolResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName, sqlPoolName);
            SynapseSqlPoolResource synapseSqlPool = client.GetSynapseSqlPoolResource(synapseSqlPoolResourceId);

            // get the collection of this SynapseSqlPoolVulnerabilityAssessmentResource
            SynapseSqlPoolVulnerabilityAssessmentCollection collection = synapseSqlPool.GetSynapseSqlPoolVulnerabilityAssessments();

            // invoke the operation
            SynapseVulnerabilityAssessmentName vulnerabilityAssessmentName = SynapseVulnerabilityAssessmentName.Default;
            NullableResponse<SynapseSqlPoolVulnerabilityAssessmentResource> response = await collection.GetIfExistsAsync(vulnerabilityAssessmentName);
            SynapseSqlPoolVulnerabilityAssessmentResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                SynapseSqlPoolVulnerabilityAssessmentData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Create a database's vulnerability assessment with all parameters
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateADatabaseSVulnerabilityAssessmentWithAllParameters()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/CreateOrUpdateSqlPoolVulnerabilityAssessmentWithAllParameters.json
            // this example is just showing the usage of "SqlPoolVulnerabilityAssessments_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseSqlPoolResource created on azure
            // for more information of creating SynapseSqlPoolResource, please refer to the document of SynapseSqlPoolResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityaseessmenttest-4799";
            string workspaceName = "vulnerabilityaseessmenttest-6440";
            string sqlPoolName = "testdb";
            ResourceIdentifier synapseSqlPoolResourceId = SynapseSqlPoolResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName, sqlPoolName);
            SynapseSqlPoolResource synapseSqlPool = client.GetSynapseSqlPoolResource(synapseSqlPoolResourceId);

            // get the collection of this SynapseSqlPoolVulnerabilityAssessmentResource
            SynapseSqlPoolVulnerabilityAssessmentCollection collection = synapseSqlPool.GetSynapseSqlPoolVulnerabilityAssessments();

            // invoke the operation
            SynapseVulnerabilityAssessmentName vulnerabilityAssessmentName = SynapseVulnerabilityAssessmentName.Default;
            SynapseSqlPoolVulnerabilityAssessmentData data = new SynapseSqlPoolVulnerabilityAssessmentData()
            {
                StorageContainerPath = "https://myStorage.blob.core.windows.net/vulnerability-assessment/",
                StorageContainerSasKey = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
                StorageAccountAccessKey = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
                RecurringScans = new SynapseVulnerabilityAssessmentRecurringScansProperties()
                {
                    IsEnabled = true,
                    EnableEmailToAccountAdmins = true,
                    Emails =
{
"email1@mail.com","email2@mail.com"
},
                },
            };
            ArmOperation<SynapseSqlPoolVulnerabilityAssessmentResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, vulnerabilityAssessmentName, data);
            SynapseSqlPoolVulnerabilityAssessmentResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SynapseSqlPoolVulnerabilityAssessmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create a database's vulnerability assessment with minimal parameters, when storageAccountAccessKey is specified
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateADatabaseSVulnerabilityAssessmentWithMinimalParametersWhenStorageAccountAccessKeyIsSpecified()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/CreateOrUpdateVulnerabilityAssessmentWithStorageAccessKeyAndMinParameters.json
            // this example is just showing the usage of "SqlPoolVulnerabilityAssessments_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseSqlPoolResource created on azure
            // for more information of creating SynapseSqlPoolResource, please refer to the document of SynapseSqlPoolResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityaseessmenttest-4799";
            string workspaceName = "vulnerabilityaseessmenttest-6440";
            string sqlPoolName = "testdb";
            ResourceIdentifier synapseSqlPoolResourceId = SynapseSqlPoolResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName, sqlPoolName);
            SynapseSqlPoolResource synapseSqlPool = client.GetSynapseSqlPoolResource(synapseSqlPoolResourceId);

            // get the collection of this SynapseSqlPoolVulnerabilityAssessmentResource
            SynapseSqlPoolVulnerabilityAssessmentCollection collection = synapseSqlPool.GetSynapseSqlPoolVulnerabilityAssessments();

            // invoke the operation
            SynapseVulnerabilityAssessmentName vulnerabilityAssessmentName = SynapseVulnerabilityAssessmentName.Default;
            SynapseSqlPoolVulnerabilityAssessmentData data = new SynapseSqlPoolVulnerabilityAssessmentData()
            {
                StorageContainerPath = "https://myStorage.blob.core.windows.net/vulnerability-assessment/",
                StorageAccountAccessKey = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
            };
            ArmOperation<SynapseSqlPoolVulnerabilityAssessmentResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, vulnerabilityAssessmentName, data);
            SynapseSqlPoolVulnerabilityAssessmentResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SynapseSqlPoolVulnerabilityAssessmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create a database's vulnerability assessment with minimal parameters, when storageContainerSasKey is specified
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateADatabaseSVulnerabilityAssessmentWithMinimalParametersWhenStorageContainerSasKeyIsSpecified()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/CreateOrUpdateSqlPoolVulnerabilityAssessmentWithContainerSasKeyAndMinParameters.json
            // this example is just showing the usage of "SqlPoolVulnerabilityAssessments_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseSqlPoolResource created on azure
            // for more information of creating SynapseSqlPoolResource, please refer to the document of SynapseSqlPoolResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityaseessmenttest-4799";
            string workspaceName = "vulnerabilityaseessmenttest-6440";
            string sqlPoolName = "testdb";
            ResourceIdentifier synapseSqlPoolResourceId = SynapseSqlPoolResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName, sqlPoolName);
            SynapseSqlPoolResource synapseSqlPool = client.GetSynapseSqlPoolResource(synapseSqlPoolResourceId);

            // get the collection of this SynapseSqlPoolVulnerabilityAssessmentResource
            SynapseSqlPoolVulnerabilityAssessmentCollection collection = synapseSqlPool.GetSynapseSqlPoolVulnerabilityAssessments();

            // invoke the operation
            SynapseVulnerabilityAssessmentName vulnerabilityAssessmentName = SynapseVulnerabilityAssessmentName.Default;
            SynapseSqlPoolVulnerabilityAssessmentData data = new SynapseSqlPoolVulnerabilityAssessmentData()
            {
                StorageContainerPath = "https://myStorage.blob.core.windows.net/vulnerability-assessment/",
                StorageContainerSasKey = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
            };
            ArmOperation<SynapseSqlPoolVulnerabilityAssessmentResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, vulnerabilityAssessmentName, data);
            SynapseSqlPoolVulnerabilityAssessmentResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SynapseSqlPoolVulnerabilityAssessmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
