// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Synapse.Models;

namespace Azure.ResourceManager.Synapse.Samples
{
    public partial class Sample_SynapseSqlPoolConnectionPolicyCollection
    {
        // Get a connection policy of a SQL Analytics pool
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAConnectionPolicyOfASQLAnalyticsPool()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/GetSqlPoolConnectionPolicy.json
            // this example is just showing the usage of "SqlPoolConnectionPolicies_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseSqlPoolResource created on azure
            // for more information of creating SynapseSqlPoolResource, please refer to the document of SynapseSqlPoolResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "blobauditingtest-6852";
            string workspaceName = "blobauditingtest-2080";
            string sqlPoolName = "testdb";
            ResourceIdentifier synapseSqlPoolResourceId = SynapseSqlPoolResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName, sqlPoolName);
            SynapseSqlPoolResource synapseSqlPool = client.GetSynapseSqlPoolResource(synapseSqlPoolResourceId);

            // get the collection of this SynapseSqlPoolConnectionPolicyResource
            SynapseSqlPoolConnectionPolicyCollection collection = synapseSqlPool.GetSynapseSqlPoolConnectionPolicies();

            // invoke the operation
            SqlPoolConnectionPolicyName connectionPolicyName = SqlPoolConnectionPolicyName.Default;
            SynapseSqlPoolConnectionPolicyResource result = await collection.GetAsync(connectionPolicyName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SynapseSqlPoolConnectionPolicyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get a connection policy of a SQL Analytics pool
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetAConnectionPolicyOfASQLAnalyticsPool()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/GetSqlPoolConnectionPolicy.json
            // this example is just showing the usage of "SqlPoolConnectionPolicies_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseSqlPoolResource created on azure
            // for more information of creating SynapseSqlPoolResource, please refer to the document of SynapseSqlPoolResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "blobauditingtest-6852";
            string workspaceName = "blobauditingtest-2080";
            string sqlPoolName = "testdb";
            ResourceIdentifier synapseSqlPoolResourceId = SynapseSqlPoolResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName, sqlPoolName);
            SynapseSqlPoolResource synapseSqlPool = client.GetSynapseSqlPoolResource(synapseSqlPoolResourceId);

            // get the collection of this SynapseSqlPoolConnectionPolicyResource
            SynapseSqlPoolConnectionPolicyCollection collection = synapseSqlPool.GetSynapseSqlPoolConnectionPolicies();

            // invoke the operation
            SqlPoolConnectionPolicyName connectionPolicyName = SqlPoolConnectionPolicyName.Default;
            bool result = await collection.ExistsAsync(connectionPolicyName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get a connection policy of a SQL Analytics pool
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetAConnectionPolicyOfASQLAnalyticsPool()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/GetSqlPoolConnectionPolicy.json
            // this example is just showing the usage of "SqlPoolConnectionPolicies_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseSqlPoolResource created on azure
            // for more information of creating SynapseSqlPoolResource, please refer to the document of SynapseSqlPoolResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "blobauditingtest-6852";
            string workspaceName = "blobauditingtest-2080";
            string sqlPoolName = "testdb";
            ResourceIdentifier synapseSqlPoolResourceId = SynapseSqlPoolResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName, sqlPoolName);
            SynapseSqlPoolResource synapseSqlPool = client.GetSynapseSqlPoolResource(synapseSqlPoolResourceId);

            // get the collection of this SynapseSqlPoolConnectionPolicyResource
            SynapseSqlPoolConnectionPolicyCollection collection = synapseSqlPool.GetSynapseSqlPoolConnectionPolicies();

            // invoke the operation
            SqlPoolConnectionPolicyName connectionPolicyName = SqlPoolConnectionPolicyName.Default;
            NullableResponse<SynapseSqlPoolConnectionPolicyResource> response = await collection.GetIfExistsAsync(connectionPolicyName);
            SynapseSqlPoolConnectionPolicyResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                SynapseSqlPoolConnectionPolicyData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }
    }
}
