// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.Synapse.Samples
{
    public partial class Sample_SynapseSqlPoolColumnCollection
    {
        // List the columns in a table of a given schema in a SQL Analytics pool
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ListTheColumnsInATableOfAGivenSchemaInASQLAnalyticsPool()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/ListSqlPoolColumns.json
            // this example is just showing the usage of "SqlPoolTableColumns_ListByTableName" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseSqlPoolTableResource created on azure
            // for more information of creating SynapseSqlPoolTableResource, please refer to the document of SynapseSqlPoolTableResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "myRG";
            string workspaceName = "serverName";
            string sqlPoolName = "myDatabase";
            string schemaName = "dbo";
            string tableName = "table1";
            ResourceIdentifier synapseSqlPoolTableResourceId = SynapseSqlPoolTableResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName, sqlPoolName, schemaName, tableName);
            SynapseSqlPoolTableResource synapseSqlPoolTable = client.GetSynapseSqlPoolTableResource(synapseSqlPoolTableResourceId);

            // get the collection of this SynapseSqlPoolColumnResource
            SynapseSqlPoolColumnCollection collection = synapseSqlPoolTable.GetSynapseSqlPoolColumns();

            // invoke the operation and iterate over the result
            await foreach (SynapseSqlPoolColumnResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                SynapseSqlPoolColumnData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Get database column
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetDatabaseColumn()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/SqlPoolColumnGet.json
            // this example is just showing the usage of "SqlPoolColumns_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseSqlPoolTableResource created on azure
            // for more information of creating SynapseSqlPoolTableResource, please refer to the document of SynapseSqlPoolTableResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "myRG";
            string workspaceName = "serverName";
            string sqlPoolName = "myDatabase";
            string schemaName = "dbo";
            string tableName = "table1";
            ResourceIdentifier synapseSqlPoolTableResourceId = SynapseSqlPoolTableResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName, sqlPoolName, schemaName, tableName);
            SynapseSqlPoolTableResource synapseSqlPoolTable = client.GetSynapseSqlPoolTableResource(synapseSqlPoolTableResourceId);

            // get the collection of this SynapseSqlPoolColumnResource
            SynapseSqlPoolColumnCollection collection = synapseSqlPoolTable.GetSynapseSqlPoolColumns();

            // invoke the operation
            string columnName = "column1";
            SynapseSqlPoolColumnResource result = await collection.GetAsync(columnName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SynapseSqlPoolColumnData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get database column
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetDatabaseColumn()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/SqlPoolColumnGet.json
            // this example is just showing the usage of "SqlPoolColumns_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseSqlPoolTableResource created on azure
            // for more information of creating SynapseSqlPoolTableResource, please refer to the document of SynapseSqlPoolTableResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "myRG";
            string workspaceName = "serverName";
            string sqlPoolName = "myDatabase";
            string schemaName = "dbo";
            string tableName = "table1";
            ResourceIdentifier synapseSqlPoolTableResourceId = SynapseSqlPoolTableResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName, sqlPoolName, schemaName, tableName);
            SynapseSqlPoolTableResource synapseSqlPoolTable = client.GetSynapseSqlPoolTableResource(synapseSqlPoolTableResourceId);

            // get the collection of this SynapseSqlPoolColumnResource
            SynapseSqlPoolColumnCollection collection = synapseSqlPoolTable.GetSynapseSqlPoolColumns();

            // invoke the operation
            string columnName = "column1";
            bool result = await collection.ExistsAsync(columnName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get database column
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetDatabaseColumn()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/SqlPoolColumnGet.json
            // this example is just showing the usage of "SqlPoolColumns_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseSqlPoolTableResource created on azure
            // for more information of creating SynapseSqlPoolTableResource, please refer to the document of SynapseSqlPoolTableResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "myRG";
            string workspaceName = "serverName";
            string sqlPoolName = "myDatabase";
            string schemaName = "dbo";
            string tableName = "table1";
            ResourceIdentifier synapseSqlPoolTableResourceId = SynapseSqlPoolTableResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName, sqlPoolName, schemaName, tableName);
            SynapseSqlPoolTableResource synapseSqlPoolTable = client.GetSynapseSqlPoolTableResource(synapseSqlPoolTableResourceId);

            // get the collection of this SynapseSqlPoolColumnResource
            SynapseSqlPoolColumnCollection collection = synapseSqlPoolTable.GetSynapseSqlPoolColumns();

            // invoke the operation
            string columnName = "column1";
            NullableResponse<SynapseSqlPoolColumnResource> response = await collection.GetIfExistsAsync(columnName);
            SynapseSqlPoolColumnResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                SynapseSqlPoolColumnData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }
    }
}
