// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Synapse.Models;

namespace Azure.ResourceManager.Synapse.Samples
{
    public partial class Sample_SynapseSqlPoolBlobAuditingPolicyResource
    {
        // Get blob auditing policy of a SQL Analytics pool
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetBlobAuditingPolicyOfASQLAnalyticsPool()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/GetSqlPoolBlobAuditing.json
            // this example is just showing the usage of "SqlPoolBlobAuditingPolicies_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseSqlPoolBlobAuditingPolicyResource created on azure
            // for more information of creating SynapseSqlPoolBlobAuditingPolicyResource, please refer to the document of SynapseSqlPoolBlobAuditingPolicyResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "blobauditingtest-6852";
            string workspaceName = "blobauditingtest-2080";
            string sqlPoolName = "testdb";
            ResourceIdentifier synapseSqlPoolBlobAuditingPolicyResourceId = SynapseSqlPoolBlobAuditingPolicyResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName, sqlPoolName);
            SynapseSqlPoolBlobAuditingPolicyResource synapseSqlPoolBlobAuditingPolicy = client.GetSynapseSqlPoolBlobAuditingPolicyResource(synapseSqlPoolBlobAuditingPolicyResourceId);

            // invoke the operation
            SynapseSqlPoolBlobAuditingPolicyResource result = await synapseSqlPoolBlobAuditingPolicy.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SynapseSqlPoolBlobAuditingPolicyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create or update a database's blob auditing policy with all parameters
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateOrUpdateADatabaseSBlobAuditingPolicyWithAllParameters()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/CreateOrUpdateSqlPoolBlobAuditingWithAllParameters.json
            // this example is just showing the usage of "SqlPoolBlobAuditingPolicies_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseSqlPoolBlobAuditingPolicyResource created on azure
            // for more information of creating SynapseSqlPoolBlobAuditingPolicyResource, please refer to the document of SynapseSqlPoolBlobAuditingPolicyResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "blobauditingtest-4799";
            string workspaceName = "blobauditingtest-6440";
            string sqlPoolName = "testdb";
            ResourceIdentifier synapseSqlPoolBlobAuditingPolicyResourceId = SynapseSqlPoolBlobAuditingPolicyResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName, sqlPoolName);
            SynapseSqlPoolBlobAuditingPolicyResource synapseSqlPoolBlobAuditingPolicy = client.GetSynapseSqlPoolBlobAuditingPolicyResource(synapseSqlPoolBlobAuditingPolicyResourceId);

            // invoke the operation
            SynapseSqlPoolBlobAuditingPolicyData data = new SynapseSqlPoolBlobAuditingPolicyData()
            {
                State = SynapseBlobAuditingPolicyState.Enabled,
                StorageEndpoint = "https://mystorage.blob.core.windows.net",
                StorageAccountAccessKey = "sdlfkjabc+sdlfkjsdlkfsjdfLDKFTERLKFDFKLjsdfksjdflsdkfD2342309432849328476458/3RSD==",
                RetentionDays = 6,
                AuditActionsAndGroups =
{
"DATABASE_LOGOUT_GROUP","DATABASE_ROLE_MEMBER_CHANGE_GROUP","UPDATE on database::TestDatabaseName by public"
},
                StorageAccountSubscriptionId = Guid.Parse("00000000-1234-0000-5678-000000000000"),
                IsStorageSecondaryKeyInUse = false,
                IsAzureMonitorTargetEnabled = true,
            };
            ArmOperation<SynapseSqlPoolBlobAuditingPolicyResource> lro = await synapseSqlPoolBlobAuditingPolicy.CreateOrUpdateAsync(WaitUntil.Completed, data);
            SynapseSqlPoolBlobAuditingPolicyResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SynapseSqlPoolBlobAuditingPolicyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create or update a database's blob auditing policy with minimal parameters
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateOrUpdateADatabaseSBlobAuditingPolicyWithMinimalParameters()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/CreateOrUpdateSqlPoolBlobAuditingWithMinParameters.json
            // this example is just showing the usage of "SqlPoolBlobAuditingPolicies_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseSqlPoolBlobAuditingPolicyResource created on azure
            // for more information of creating SynapseSqlPoolBlobAuditingPolicyResource, please refer to the document of SynapseSqlPoolBlobAuditingPolicyResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "blobauditingtest-4799";
            string workspaceName = "blobauditingtest-6440";
            string sqlPoolName = "testdb";
            ResourceIdentifier synapseSqlPoolBlobAuditingPolicyResourceId = SynapseSqlPoolBlobAuditingPolicyResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName, sqlPoolName);
            SynapseSqlPoolBlobAuditingPolicyResource synapseSqlPoolBlobAuditingPolicy = client.GetSynapseSqlPoolBlobAuditingPolicyResource(synapseSqlPoolBlobAuditingPolicyResourceId);

            // invoke the operation
            SynapseSqlPoolBlobAuditingPolicyData data = new SynapseSqlPoolBlobAuditingPolicyData()
            {
                State = SynapseBlobAuditingPolicyState.Enabled,
                StorageEndpoint = "https://mystorage.blob.core.windows.net",
                StorageAccountAccessKey = "sdlfkjabc+sdlfkjsdlkfsjdfLDKFTERLKFDFKLjsdfksjdflsdkfD2342309432849328476458/3RSD==",
            };
            ArmOperation<SynapseSqlPoolBlobAuditingPolicyResource> lro = await synapseSqlPoolBlobAuditingPolicy.CreateOrUpdateAsync(WaitUntil.Completed, data);
            SynapseSqlPoolBlobAuditingPolicyResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SynapseSqlPoolBlobAuditingPolicyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
