// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.Synapse.Samples
{
    public partial class Sample_SynapseSparkConfigurationResource
    {
        // Get SparkConfiguration by name
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetSparkConfigurationByName()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/preview/2021-06-01-preview/examples/SparkConfiguration_Get.json
            // this example is just showing the usage of "SparkConfiguration_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseSparkConfigurationResource created on azure
            // for more information of creating SynapseSparkConfigurationResource, please refer to the document of SynapseSparkConfigurationResource
            string subscriptionId = "12345678-1234-1234-1234-12345678abc";
            string resourceGroupName = "exampleResourceGroup";
            string workspaceName = "exampleWorkspace";
            string sparkConfigurationName = "exampleSparkConfigurationName";
            ResourceIdentifier synapseSparkConfigurationResourceId = SynapseSparkConfigurationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName, sparkConfigurationName);
            SynapseSparkConfigurationResource synapseSparkConfiguration = client.GetSynapseSparkConfigurationResource(synapseSparkConfigurationResourceId);

            // invoke the operation
            SynapseSparkConfigurationResource result = await synapseSparkConfiguration.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SynapseSparkConfigurationData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
