// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Synapse.Models;

namespace Azure.ResourceManager.Synapse.Samples
{
    public partial class Sample_SynapseServerVulnerabilityAssessmentResource
    {
        // Get workspace managed sql Server's vulnerability assessment
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetWorkspaceManagedSqlServerSVulnerabilityAssessment()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/GetWorkspaceManagedSqlServerVulnerabilityAssessment.json
            // this example is just showing the usage of "WorkspaceManagedSqlServerVulnerabilityAssessments_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseServerVulnerabilityAssessmentResource created on azure
            // for more information of creating SynapseServerVulnerabilityAssessmentResource, please refer to the document of SynapseServerVulnerabilityAssessmentResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "wsg-7398";
            string workspaceName = "testWorkspace";
            SynapseVulnerabilityAssessmentName vulnerabilityAssessmentName = SynapseVulnerabilityAssessmentName.Default;
            ResourceIdentifier synapseServerVulnerabilityAssessmentResourceId = SynapseServerVulnerabilityAssessmentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName, vulnerabilityAssessmentName);
            SynapseServerVulnerabilityAssessmentResource synapseServerVulnerabilityAssessment = client.GetSynapseServerVulnerabilityAssessmentResource(synapseServerVulnerabilityAssessmentResourceId);

            // invoke the operation
            SynapseServerVulnerabilityAssessmentResource result = await synapseServerVulnerabilityAssessment.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SynapseServerVulnerabilityAssessmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create or Update a workspace managed sql server's vulnerability assessment with all parameters
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateOrUpdateAWorkspaceManagedSqlServerSVulnerabilityAssessmentWithAllParameters()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/PutWorkspaceManagedSqlServerVulnerabilityAssessmentWithAllParameters.json
            // this example is just showing the usage of "WorkspaceManagedSqlServerVulnerabilityAssessments_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseServerVulnerabilityAssessmentResource created on azure
            // for more information of creating SynapseServerVulnerabilityAssessmentResource, please refer to the document of SynapseServerVulnerabilityAssessmentResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "wsg-7398";
            string workspaceName = "testWorkspace";
            SynapseVulnerabilityAssessmentName vulnerabilityAssessmentName = SynapseVulnerabilityAssessmentName.Default;
            ResourceIdentifier synapseServerVulnerabilityAssessmentResourceId = SynapseServerVulnerabilityAssessmentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName, vulnerabilityAssessmentName);
            SynapseServerVulnerabilityAssessmentResource synapseServerVulnerabilityAssessment = client.GetSynapseServerVulnerabilityAssessmentResource(synapseServerVulnerabilityAssessmentResourceId);

            // invoke the operation
            SynapseServerVulnerabilityAssessmentData data = new SynapseServerVulnerabilityAssessmentData()
            {
                StorageContainerPath = "https://myStorage.blob.core.windows.net/vulnerability-assessment/",
                StorageContainerSasKey = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
                StorageAccountAccessKey = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
                RecurringScans = new SynapseVulnerabilityAssessmentRecurringScansProperties()
                {
                    IsEnabled = true,
                    EnableEmailToAccountAdmins = true,
                    Emails =
{
"email1@mail.com","email2@mail.com"
},
                },
            };
            ArmOperation<SynapseServerVulnerabilityAssessmentResource> lro = await synapseServerVulnerabilityAssessment.UpdateAsync(WaitUntil.Completed, data);
            SynapseServerVulnerabilityAssessmentResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SynapseServerVulnerabilityAssessmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create or Update a workspace managed sql server's vulnerability assessment with minimal parameters, when storageAccountAccessKey is specified
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateOrUpdateAWorkspaceManagedSqlServerSVulnerabilityAssessmentWithMinimalParametersWhenStorageAccountAccessKeyIsSpecified()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/PutWorkspaceMangedSqlServerVulnerabilityAssessmentCreateStorageAccessKeyMin.json
            // this example is just showing the usage of "WorkspaceManagedSqlServerVulnerabilityAssessments_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseServerVulnerabilityAssessmentResource created on azure
            // for more information of creating SynapseServerVulnerabilityAssessmentResource, please refer to the document of SynapseServerVulnerabilityAssessmentResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "wsg-7398";
            string workspaceName = "testWorkspace";
            SynapseVulnerabilityAssessmentName vulnerabilityAssessmentName = SynapseVulnerabilityAssessmentName.Default;
            ResourceIdentifier synapseServerVulnerabilityAssessmentResourceId = SynapseServerVulnerabilityAssessmentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName, vulnerabilityAssessmentName);
            SynapseServerVulnerabilityAssessmentResource synapseServerVulnerabilityAssessment = client.GetSynapseServerVulnerabilityAssessmentResource(synapseServerVulnerabilityAssessmentResourceId);

            // invoke the operation
            SynapseServerVulnerabilityAssessmentData data = new SynapseServerVulnerabilityAssessmentData()
            {
                StorageContainerPath = "https://myStorage.blob.core.windows.net/vulnerability-assessment/",
                StorageAccountAccessKey = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
            };
            ArmOperation<SynapseServerVulnerabilityAssessmentResource> lro = await synapseServerVulnerabilityAssessment.UpdateAsync(WaitUntil.Completed, data);
            SynapseServerVulnerabilityAssessmentResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SynapseServerVulnerabilityAssessmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create or Update a workspace managed sql server's vulnerability assessment with minimal parameters, when storageContainerSasKey is specified
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateOrUpdateAWorkspaceManagedSqlServerSVulnerabilityAssessmentWithMinimalParametersWhenStorageContainerSasKeyIsSpecified()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/PutWorkspaceMangedSqlServerVulnerabilityAssessmentCreateContainerSasKeyMin.json
            // this example is just showing the usage of "WorkspaceManagedSqlServerVulnerabilityAssessments_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseServerVulnerabilityAssessmentResource created on azure
            // for more information of creating SynapseServerVulnerabilityAssessmentResource, please refer to the document of SynapseServerVulnerabilityAssessmentResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "wsg-7398";
            string workspaceName = "testWorkspace";
            SynapseVulnerabilityAssessmentName vulnerabilityAssessmentName = SynapseVulnerabilityAssessmentName.Default;
            ResourceIdentifier synapseServerVulnerabilityAssessmentResourceId = SynapseServerVulnerabilityAssessmentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName, vulnerabilityAssessmentName);
            SynapseServerVulnerabilityAssessmentResource synapseServerVulnerabilityAssessment = client.GetSynapseServerVulnerabilityAssessmentResource(synapseServerVulnerabilityAssessmentResourceId);

            // invoke the operation
            SynapseServerVulnerabilityAssessmentData data = new SynapseServerVulnerabilityAssessmentData()
            {
                StorageContainerPath = "https://myStorage.blob.core.windows.net/vulnerability-assessment/",
                StorageContainerSasKey = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
            };
            ArmOperation<SynapseServerVulnerabilityAssessmentResource> lro = await synapseServerVulnerabilityAssessment.UpdateAsync(WaitUntil.Completed, data);
            SynapseServerVulnerabilityAssessmentResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SynapseServerVulnerabilityAssessmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Remove workspace managed sql Server's vulnerability assessment
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_RemoveWorkspaceManagedSqlServerSVulnerabilityAssessment()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/DeleteWorkspaceManagedSqlServerVulnerabilityAssessment.json
            // this example is just showing the usage of "WorkspaceManagedSqlServerVulnerabilityAssessments_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseServerVulnerabilityAssessmentResource created on azure
            // for more information of creating SynapseServerVulnerabilityAssessmentResource, please refer to the document of SynapseServerVulnerabilityAssessmentResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "wsg-7398";
            string workspaceName = "testWorkspace";
            SynapseVulnerabilityAssessmentName vulnerabilityAssessmentName = SynapseVulnerabilityAssessmentName.Default;
            ResourceIdentifier synapseServerVulnerabilityAssessmentResourceId = SynapseServerVulnerabilityAssessmentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName, vulnerabilityAssessmentName);
            SynapseServerVulnerabilityAssessmentResource synapseServerVulnerabilityAssessment = client.GetSynapseServerVulnerabilityAssessmentResource(synapseServerVulnerabilityAssessmentResourceId);

            // invoke the operation
            await synapseServerVulnerabilityAssessment.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
