// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Synapse.Models;

namespace Azure.ResourceManager.Synapse.Samples
{
    public partial class Sample_SynapseServerVulnerabilityAssessmentCollection
    {
        // Get workspace managed sql Server's vulnerability assessment
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetWorkspaceManagedSqlServerSVulnerabilityAssessment()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/GetWorkspaceManagedSqlServerVulnerabilityAssessment.json
            // this example is just showing the usage of "WorkspaceManagedSqlServerVulnerabilityAssessments_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseWorkspaceResource created on azure
            // for more information of creating SynapseWorkspaceResource, please refer to the document of SynapseWorkspaceResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "wsg-7398";
            string workspaceName = "testWorkspace";
            ResourceIdentifier synapseWorkspaceResourceId = SynapseWorkspaceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName);
            SynapseWorkspaceResource synapseWorkspace = client.GetSynapseWorkspaceResource(synapseWorkspaceResourceId);

            // get the collection of this SynapseServerVulnerabilityAssessmentResource
            SynapseServerVulnerabilityAssessmentCollection collection = synapseWorkspace.GetSynapseServerVulnerabilityAssessments();

            // invoke the operation
            SynapseVulnerabilityAssessmentName vulnerabilityAssessmentName = SynapseVulnerabilityAssessmentName.Default;
            SynapseServerVulnerabilityAssessmentResource result = await collection.GetAsync(vulnerabilityAssessmentName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SynapseServerVulnerabilityAssessmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get workspace managed sql Server's vulnerability assessment
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetWorkspaceManagedSqlServerSVulnerabilityAssessment()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/GetWorkspaceManagedSqlServerVulnerabilityAssessment.json
            // this example is just showing the usage of "WorkspaceManagedSqlServerVulnerabilityAssessments_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseWorkspaceResource created on azure
            // for more information of creating SynapseWorkspaceResource, please refer to the document of SynapseWorkspaceResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "wsg-7398";
            string workspaceName = "testWorkspace";
            ResourceIdentifier synapseWorkspaceResourceId = SynapseWorkspaceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName);
            SynapseWorkspaceResource synapseWorkspace = client.GetSynapseWorkspaceResource(synapseWorkspaceResourceId);

            // get the collection of this SynapseServerVulnerabilityAssessmentResource
            SynapseServerVulnerabilityAssessmentCollection collection = synapseWorkspace.GetSynapseServerVulnerabilityAssessments();

            // invoke the operation
            SynapseVulnerabilityAssessmentName vulnerabilityAssessmentName = SynapseVulnerabilityAssessmentName.Default;
            bool result = await collection.ExistsAsync(vulnerabilityAssessmentName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get workspace managed sql Server's vulnerability assessment
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetWorkspaceManagedSqlServerSVulnerabilityAssessment()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/GetWorkspaceManagedSqlServerVulnerabilityAssessment.json
            // this example is just showing the usage of "WorkspaceManagedSqlServerVulnerabilityAssessments_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseWorkspaceResource created on azure
            // for more information of creating SynapseWorkspaceResource, please refer to the document of SynapseWorkspaceResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "wsg-7398";
            string workspaceName = "testWorkspace";
            ResourceIdentifier synapseWorkspaceResourceId = SynapseWorkspaceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName);
            SynapseWorkspaceResource synapseWorkspace = client.GetSynapseWorkspaceResource(synapseWorkspaceResourceId);

            // get the collection of this SynapseServerVulnerabilityAssessmentResource
            SynapseServerVulnerabilityAssessmentCollection collection = synapseWorkspace.GetSynapseServerVulnerabilityAssessments();

            // invoke the operation
            SynapseVulnerabilityAssessmentName vulnerabilityAssessmentName = SynapseVulnerabilityAssessmentName.Default;
            NullableResponse<SynapseServerVulnerabilityAssessmentResource> response = await collection.GetIfExistsAsync(vulnerabilityAssessmentName);
            SynapseServerVulnerabilityAssessmentResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                SynapseServerVulnerabilityAssessmentData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Create or Update a workspace managed sql server's vulnerability assessment with all parameters
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateOrUpdateAWorkspaceManagedSqlServerSVulnerabilityAssessmentWithAllParameters()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/PutWorkspaceManagedSqlServerVulnerabilityAssessmentWithAllParameters.json
            // this example is just showing the usage of "WorkspaceManagedSqlServerVulnerabilityAssessments_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseWorkspaceResource created on azure
            // for more information of creating SynapseWorkspaceResource, please refer to the document of SynapseWorkspaceResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "wsg-7398";
            string workspaceName = "testWorkspace";
            ResourceIdentifier synapseWorkspaceResourceId = SynapseWorkspaceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName);
            SynapseWorkspaceResource synapseWorkspace = client.GetSynapseWorkspaceResource(synapseWorkspaceResourceId);

            // get the collection of this SynapseServerVulnerabilityAssessmentResource
            SynapseServerVulnerabilityAssessmentCollection collection = synapseWorkspace.GetSynapseServerVulnerabilityAssessments();

            // invoke the operation
            SynapseVulnerabilityAssessmentName vulnerabilityAssessmentName = SynapseVulnerabilityAssessmentName.Default;
            SynapseServerVulnerabilityAssessmentData data = new SynapseServerVulnerabilityAssessmentData()
            {
                StorageContainerPath = "https://myStorage.blob.core.windows.net/vulnerability-assessment/",
                StorageContainerSasKey = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
                StorageAccountAccessKey = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
                RecurringScans = new SynapseVulnerabilityAssessmentRecurringScansProperties()
                {
                    IsEnabled = true,
                    EnableEmailToAccountAdmins = true,
                    Emails =
{
"email1@mail.com","email2@mail.com"
},
                },
            };
            ArmOperation<SynapseServerVulnerabilityAssessmentResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, vulnerabilityAssessmentName, data);
            SynapseServerVulnerabilityAssessmentResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SynapseServerVulnerabilityAssessmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create or Update a workspace managed sql server's vulnerability assessment with minimal parameters, when storageAccountAccessKey is specified
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateOrUpdateAWorkspaceManagedSqlServerSVulnerabilityAssessmentWithMinimalParametersWhenStorageAccountAccessKeyIsSpecified()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/PutWorkspaceMangedSqlServerVulnerabilityAssessmentCreateStorageAccessKeyMin.json
            // this example is just showing the usage of "WorkspaceManagedSqlServerVulnerabilityAssessments_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseWorkspaceResource created on azure
            // for more information of creating SynapseWorkspaceResource, please refer to the document of SynapseWorkspaceResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "wsg-7398";
            string workspaceName = "testWorkspace";
            ResourceIdentifier synapseWorkspaceResourceId = SynapseWorkspaceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName);
            SynapseWorkspaceResource synapseWorkspace = client.GetSynapseWorkspaceResource(synapseWorkspaceResourceId);

            // get the collection of this SynapseServerVulnerabilityAssessmentResource
            SynapseServerVulnerabilityAssessmentCollection collection = synapseWorkspace.GetSynapseServerVulnerabilityAssessments();

            // invoke the operation
            SynapseVulnerabilityAssessmentName vulnerabilityAssessmentName = SynapseVulnerabilityAssessmentName.Default;
            SynapseServerVulnerabilityAssessmentData data = new SynapseServerVulnerabilityAssessmentData()
            {
                StorageContainerPath = "https://myStorage.blob.core.windows.net/vulnerability-assessment/",
                StorageAccountAccessKey = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
            };
            ArmOperation<SynapseServerVulnerabilityAssessmentResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, vulnerabilityAssessmentName, data);
            SynapseServerVulnerabilityAssessmentResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SynapseServerVulnerabilityAssessmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create or Update a workspace managed sql server's vulnerability assessment with minimal parameters, when storageContainerSasKey is specified
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateOrUpdateAWorkspaceManagedSqlServerSVulnerabilityAssessmentWithMinimalParametersWhenStorageContainerSasKeyIsSpecified()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/PutWorkspaceMangedSqlServerVulnerabilityAssessmentCreateContainerSasKeyMin.json
            // this example is just showing the usage of "WorkspaceManagedSqlServerVulnerabilityAssessments_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseWorkspaceResource created on azure
            // for more information of creating SynapseWorkspaceResource, please refer to the document of SynapseWorkspaceResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "wsg-7398";
            string workspaceName = "testWorkspace";
            ResourceIdentifier synapseWorkspaceResourceId = SynapseWorkspaceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName);
            SynapseWorkspaceResource synapseWorkspace = client.GetSynapseWorkspaceResource(synapseWorkspaceResourceId);

            // get the collection of this SynapseServerVulnerabilityAssessmentResource
            SynapseServerVulnerabilityAssessmentCollection collection = synapseWorkspace.GetSynapseServerVulnerabilityAssessments();

            // invoke the operation
            SynapseVulnerabilityAssessmentName vulnerabilityAssessmentName = SynapseVulnerabilityAssessmentName.Default;
            SynapseServerVulnerabilityAssessmentData data = new SynapseServerVulnerabilityAssessmentData()
            {
                StorageContainerPath = "https://myStorage.blob.core.windows.net/vulnerability-assessment/",
                StorageContainerSasKey = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
            };
            ArmOperation<SynapseServerVulnerabilityAssessmentResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, vulnerabilityAssessmentName, data);
            SynapseServerVulnerabilityAssessmentResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SynapseServerVulnerabilityAssessmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get workspace managed sql Server's vulnerability assessment policies
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_GetWorkspaceManagedSqlServerSVulnerabilityAssessmentPolicies()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/ListWorkspaceManagedSqlServerVulnerabilityAssessmentPolicies.json
            // this example is just showing the usage of "WorkspaceManagedSqlServerVulnerabilityAssessments_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseWorkspaceResource created on azure
            // for more information of creating SynapseWorkspaceResource, please refer to the document of SynapseWorkspaceResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "wsg-7398";
            string workspaceName = "testWorkspace";
            ResourceIdentifier synapseWorkspaceResourceId = SynapseWorkspaceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName);
            SynapseWorkspaceResource synapseWorkspace = client.GetSynapseWorkspaceResource(synapseWorkspaceResourceId);

            // get the collection of this SynapseServerVulnerabilityAssessmentResource
            SynapseServerVulnerabilityAssessmentCollection collection = synapseWorkspace.GetSynapseServerVulnerabilityAssessments();

            // invoke the operation and iterate over the result
            await foreach (SynapseServerVulnerabilityAssessmentResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                SynapseServerVulnerabilityAssessmentData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
