// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Synapse.Models;

namespace Azure.ResourceManager.Synapse.Samples
{
    public partial class Sample_SynapseServerSecurityAlertPolicyResource
    {
        // Get workspace managed sql Server's security alert policy
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetWorkspaceManagedSqlServerSSecurityAlertPolicy()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/GetWorkspaceManagedSqlServerSecurityAlertPolicy.json
            // this example is just showing the usage of "WorkspaceManagedSqlServerSecurityAlertPolicy_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseServerSecurityAlertPolicyResource created on azure
            // for more information of creating SynapseServerSecurityAlertPolicyResource, please refer to the document of SynapseServerSecurityAlertPolicyResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "wsg-7398";
            string workspaceName = "testWorkspace";
            SqlServerSecurityAlertPolicyName securityAlertPolicyName = SqlServerSecurityAlertPolicyName.Default;
            ResourceIdentifier synapseServerSecurityAlertPolicyResourceId = SynapseServerSecurityAlertPolicyResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName, securityAlertPolicyName);
            SynapseServerSecurityAlertPolicyResource synapseServerSecurityAlertPolicy = client.GetSynapseServerSecurityAlertPolicyResource(synapseServerSecurityAlertPolicyResourceId);

            // invoke the operation
            SynapseServerSecurityAlertPolicyResource result = await synapseServerSecurityAlertPolicy.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SynapseServerSecurityAlertPolicyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update a workspace managed sql server's threat detection policy with all parameters
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateAWorkspaceManagedSqlServerSThreatDetectionPolicyWithAllParameters()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/WorkspaceManagedSqlServerSecurityAlertWithAllParameters.json
            // this example is just showing the usage of "WorkspaceManagedSqlServerSecurityAlertPolicy_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseServerSecurityAlertPolicyResource created on azure
            // for more information of creating SynapseServerSecurityAlertPolicyResource, please refer to the document of SynapseServerSecurityAlertPolicyResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "wsg-7398";
            string workspaceName = "testWorkspace";
            SqlServerSecurityAlertPolicyName securityAlertPolicyName = SqlServerSecurityAlertPolicyName.Default;
            ResourceIdentifier synapseServerSecurityAlertPolicyResourceId = SynapseServerSecurityAlertPolicyResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName, securityAlertPolicyName);
            SynapseServerSecurityAlertPolicyResource synapseServerSecurityAlertPolicy = client.GetSynapseServerSecurityAlertPolicyResource(synapseServerSecurityAlertPolicyResourceId);

            // invoke the operation
            SynapseServerSecurityAlertPolicyData data = new SynapseServerSecurityAlertPolicyData()
            {
                State = SynapseSecurityAlertPolicyState.Enabled,
                DisabledAlerts =
{
"Access_Anomaly","Usage_Anomaly"
},
                EmailAddresses =
{
"testSecurityAlert@microsoft.com"
},
                EnableEmailToAccountAdmins = true,
                StorageEndpoint = "https://mystorage.blob.core.windows.net",
                StorageAccountAccessKey = "sdlfkjabc+sdlfkjsdlkfsjdfLDKFTERLKFDFKLjsdfksjdflsdkfD2342309432849328476458/3RSD==",
                RetentionDays = 5,
            };
            ArmOperation<SynapseServerSecurityAlertPolicyResource> lro = await synapseServerSecurityAlertPolicy.UpdateAsync(WaitUntil.Completed, data);
            SynapseServerSecurityAlertPolicyResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SynapseServerSecurityAlertPolicyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update a workspace managed sql server's threat detection policy with minimal parameters
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateAWorkspaceManagedSqlServerSThreatDetectionPolicyWithMinimalParameters()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/WorkspaceManagedSqlServerSecurityAlertCreateWithMinParameters.json
            // this example is just showing the usage of "WorkspaceManagedSqlServerSecurityAlertPolicy_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseServerSecurityAlertPolicyResource created on azure
            // for more information of creating SynapseServerSecurityAlertPolicyResource, please refer to the document of SynapseServerSecurityAlertPolicyResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "wsg-7398";
            string workspaceName = "testWorkspace";
            SqlServerSecurityAlertPolicyName securityAlertPolicyName = SqlServerSecurityAlertPolicyName.Default;
            ResourceIdentifier synapseServerSecurityAlertPolicyResourceId = SynapseServerSecurityAlertPolicyResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName, securityAlertPolicyName);
            SynapseServerSecurityAlertPolicyResource synapseServerSecurityAlertPolicy = client.GetSynapseServerSecurityAlertPolicyResource(synapseServerSecurityAlertPolicyResourceId);

            // invoke the operation
            SynapseServerSecurityAlertPolicyData data = new SynapseServerSecurityAlertPolicyData()
            {
                State = SynapseSecurityAlertPolicyState.Disabled,
                EnableEmailToAccountAdmins = true,
                StorageEndpoint = "https://mystorage.blob.core.windows.net",
                StorageAccountAccessKey = "sdlfkjabc+sdlfkjsdlkfsjdfLDKFTERLKFDFKLjsdfksjdflsdkfD2342309432849328476458/3RSD==",
            };
            ArmOperation<SynapseServerSecurityAlertPolicyResource> lro = await synapseServerSecurityAlertPolicy.UpdateAsync(WaitUntil.Completed, data);
            SynapseServerSecurityAlertPolicyResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SynapseServerSecurityAlertPolicyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
