// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.Synapse.Samples
{
    public partial class Sample_SynapseRestorableDroppedSqlPoolResource
    {
        // Get a restorable dropped Sql pool
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetARestorableDroppedSqlPool()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/RestorableDroppedSqlPoolGet.json
            // this example is just showing the usage of "RestorableDroppedSqlPools_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseRestorableDroppedSqlPoolResource created on azure
            // for more information of creating SynapseRestorableDroppedSqlPoolResource, please refer to the document of SynapseRestorableDroppedSqlPoolResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "restorabledroppeddatabasetest-1257";
            string workspaceName = "restorabledroppeddatabasetest-2389";
            string restorableDroppedSqlPoolId = "restorabledroppeddatabasetest-7654,131403269876900000";
            ResourceIdentifier synapseRestorableDroppedSqlPoolResourceId = SynapseRestorableDroppedSqlPoolResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName, restorableDroppedSqlPoolId);
            SynapseRestorableDroppedSqlPoolResource synapseRestorableDroppedSqlPool = client.GetSynapseRestorableDroppedSqlPoolResource(synapseRestorableDroppedSqlPoolResourceId);

            // invoke the operation
            SynapseRestorableDroppedSqlPoolResource result = await synapseRestorableDroppedSqlPool.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SynapseRestorableDroppedSqlPoolData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
