// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.Synapse.Samples
{
    public partial class Sample_SynapseReplicationLinkResource
    {
        // Lists a Sql Analytic pool's replication links
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_ListsASqlAnalyticPoolSReplicationLinks()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/SqlPoolReplicationLinks_GetByName.json
            // this example is just showing the usage of "SqlPoolReplicationLinks_GetByName" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapseReplicationLinkResource created on azure
            // for more information of creating SynapseReplicationLinkResource, please refer to the document of SynapseReplicationLinkResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "sqlcrudtest-4799";
            string workspaceName = "sqlcrudtest-6440";
            string sqlPoolName = "testdb";
            string linkId = "5b301b68-03f6-4b26-b0f4-73ebb8634238";
            ResourceIdentifier synapseReplicationLinkResourceId = SynapseReplicationLinkResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName, sqlPoolName, linkId);
            SynapseReplicationLinkResource synapseReplicationLink = client.GetSynapseReplicationLinkResource(synapseReplicationLinkResourceId);

            // invoke the operation
            SynapseReplicationLinkResource result = await synapseReplicationLink.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SynapseReplicationLinkData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
