// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Synapse.Models;

namespace Azure.ResourceManager.Synapse.Samples
{
    public partial class Sample_SynapsePrivateEndpointConnectionResource
    {
        // Get private endpoint connection
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetPrivateEndpointConnection()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/GetPrivateEndpointConnection.json
            // this example is just showing the usage of "PrivateEndpointConnections_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapsePrivateEndpointConnectionResource created on azure
            // for more information of creating SynapsePrivateEndpointConnectionResource, please refer to the document of SynapsePrivateEndpointConnectionResource
            string subscriptionId = "01234567-89ab-4def-0123-456789abcdef";
            string resourceGroupName = "ExampleResourceGroup";
            string workspaceName = "ExampleWorkspace";
            string privateEndpointConnectionName = "ExamplePrivateEndpointConnection";
            ResourceIdentifier synapsePrivateEndpointConnectionResourceId = SynapsePrivateEndpointConnectionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName, privateEndpointConnectionName);
            SynapsePrivateEndpointConnectionResource synapsePrivateEndpointConnection = client.GetSynapsePrivateEndpointConnectionResource(synapsePrivateEndpointConnectionResourceId);

            // invoke the operation
            SynapsePrivateEndpointConnectionResource result = await synapsePrivateEndpointConnection.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SynapsePrivateEndpointConnectionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Approve private endpoint connection
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_ApprovePrivateEndpointConnection()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/ApprovePrivateEndpointConnection.json
            // this example is just showing the usage of "PrivateEndpointConnections_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapsePrivateEndpointConnectionResource created on azure
            // for more information of creating SynapsePrivateEndpointConnectionResource, please refer to the document of SynapsePrivateEndpointConnectionResource
            string subscriptionId = "01234567-89ab-4def-0123-456789abcdef";
            string resourceGroupName = "ExampleResourceGroup";
            string workspaceName = "ExampleWorkspace";
            string privateEndpointConnectionName = "ExamplePrivateEndpointConnection";
            ResourceIdentifier synapsePrivateEndpointConnectionResourceId = SynapsePrivateEndpointConnectionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName, privateEndpointConnectionName);
            SynapsePrivateEndpointConnectionResource synapsePrivateEndpointConnection = client.GetSynapsePrivateEndpointConnectionResource(synapsePrivateEndpointConnectionResourceId);

            // invoke the operation
            SynapsePrivateEndpointConnectionData data = new SynapsePrivateEndpointConnectionData()
            {
                ConnectionState = new SynapsePrivateLinkServiceConnectionState()
                {
                    Status = "Approved",
                    Description = "Approved by abc@example.com",
                },
            };
            ArmOperation<SynapsePrivateEndpointConnectionResource> lro = await synapsePrivateEndpointConnection.UpdateAsync(WaitUntil.Completed, data);
            SynapsePrivateEndpointConnectionResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SynapsePrivateEndpointConnectionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Delete private endpoint connection
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeletePrivateEndpointConnection()
        {
            // Generated from example definition: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/DeletePrivateEndpointConnection.json
            // this example is just showing the usage of "PrivateEndpointConnections_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SynapsePrivateEndpointConnectionResource created on azure
            // for more information of creating SynapsePrivateEndpointConnectionResource, please refer to the document of SynapsePrivateEndpointConnectionResource
            string subscriptionId = "01234567-89ab-4def-0123-456789abcdef";
            string resourceGroupName = "ExampleResourceGroup";
            string workspaceName = "ExampleWorkspace";
            string privateEndpointConnectionName = "ExamplePrivateEndpointConnection";
            ResourceIdentifier synapsePrivateEndpointConnectionResourceId = SynapsePrivateEndpointConnectionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName, privateEndpointConnectionName);
            SynapsePrivateEndpointConnectionResource synapsePrivateEndpointConnection = client.GetSynapsePrivateEndpointConnectionResource(synapsePrivateEndpointConnectionResourceId);

            // invoke the operation
            await synapsePrivateEndpointConnection.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
